/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.export.Exportable;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector3f;
import java.util.Comparator;

public final class Triangle
implements Exportable {
    public static final Comparator<Triangle> X_COMPARATOR = new Comparator<Triangle>(){

        @Override
        public int compare(Triangle t1, Triangle t2) {
            return Float.compare(t1.getCenterX(), t2.getCenterX());
        }
    };
    public static final Comparator<Triangle> Y_COMPARATOR = new Comparator<Triangle>(){

        @Override
        public int compare(Triangle t1, Triangle t2) {
            return Float.compare(t1.getCenterY(), t2.getCenterY());
        }
    };
    public static final Comparator<Triangle> Z_COMPARATOR = new Comparator<Triangle>(){

        @Override
        public int compare(Triangle t1, Triangle t2) {
            return Float.compare(t1.getCenterZ(), t2.getCenterZ());
        }
    };
    protected Vector3f _v1 = new Vector3f();
    protected Vector3f _v2 = new Vector3f();
    protected Vector3f _v3 = new Vector3f();

    public Triangle(Vector3f v1, Vector3f v2, Vector3f v3) {
        this.set(v1, v2, v3);
    }

    public Triangle(Triangle other) {
        this.set(other);
    }

    public Triangle() {
    }

    public Vector3f getFirstVertex() {
        return this._v1;
    }

    public Vector3f getSecondVertex() {
        return this._v2;
    }

    public Vector3f getThirdVertex() {
        return this._v3;
    }

    public Vector3f getVertex(int idx) {
        switch (idx) {
            case 0: {
                return this._v1;
            }
            case 1: {
                return this._v2;
            }
            case 2: {
                return this._v3;
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(idx));
    }

    public Vector3f getCenter() {
        return this._v1.add(this._v2).addLocal(this._v3).multLocal(0.33333334f);
    }

    public float getCenterX() {
        return (this._v1.x + this._v2.x + this._v3.x) * 0.33333334f;
    }

    public float getCenterY() {
        return (this._v1.y + this._v2.y + this._v3.y) * 0.33333334f;
    }

    public float getCenterZ() {
        return (this._v1.z + this._v2.z + this._v3.z) * 0.33333334f;
    }

    public Triangle flipLocal() {
        Vector3f tmp = this._v2;
        this._v2 = this._v3;
        this._v3 = tmp;
        return this;
    }

    public Triangle set(Triangle other) {
        return this.set(other.getFirstVertex(), other.getSecondVertex(), other.getThirdVertex());
    }

    public Triangle set(Vector3f v1, Vector3f v2, Vector3f v3) {
        this._v1.set(v1);
        this._v2.set(v2);
        this._v3.set(v3);
        return this;
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        Vector3f e1 = this._v2.subtract(this._v1);
        Vector3f e2 = this._v3.subtract(this._v1);
        Vector3f dir = ray.getDirection();
        Vector3f pvec = dir.cross(e2);
        float determinant = e1.dot(pvec);
        if (determinant < 1.0E-6f) {
            return false;
        }
        Vector3f origin = ray.getOrigin();
        Vector3f tvec = origin.subtract(this._v1);
        float u = tvec.dot(pvec);
        if (u < 0.0f || u > determinant) {
            return false;
        }
        Vector3f qvec = tvec.cross(e1);
        float v = dir.dot(qvec);
        if (v < 0.0f || u + v > determinant) {
            return false;
        }
        origin.addScaled(dir, e2.dot(qvec) / determinant, result);
        return true;
    }
}

