/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix3f;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import java.io.IOException;

public final class Transform3D
implements Exportable,
Streamable {
    public static final int IDENTITY = 0;
    public static final int RIGID = 1;
    public static final int UNIFORM = 2;
    public static final int AFFINE = 3;
    public static final int GENERAL = 4;
    protected int _type;
    protected Vector3f _translation;
    protected Quaternion _rotation;
    protected float _scale = 1.0f;
    protected Matrix4f _matrix;

    public Transform3D() {
    }

    public Transform3D(int type) {
        this.setType(type);
    }

    public Transform3D(Vector3f translation, Quaternion rotation) {
        this.set(translation, rotation);
    }

    public Transform3D(Vector3f translation, Quaternion rotation, float scale) {
        this.set(translation, rotation, scale);
    }

    public Transform3D(Vector3f translation, Quaternion rotation, Vector3f scale) {
        this.set(translation, rotation, scale);
    }

    public Transform3D(Matrix4f matrix) {
        this.set(matrix);
    }

    public Transform3D(Matrix4f matrix, boolean affine) {
        this.set(matrix, affine);
    }

    public Transform3D(Transform2D transform) {
        this.set(transform);
    }

    public Transform3D(Transform3D transform) {
        this.set(transform);
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
        if ((this._type == 3 || this._type == 4) && this._matrix == null) {
            this._matrix = new Matrix4f();
        } else if ((this._type == 1 || this._type == 2) && this._translation == null) {
            this._translation = new Vector3f();
            this._rotation = new Quaternion();
        }
    }

    public Vector3f getTranslation() {
        return this._translation;
    }

    public Quaternion getRotation() {
        return this._rotation;
    }

    public float getScale() {
        return this._scale;
    }

    public float setScale(float scale) {
        this._scale = scale;
        return this._scale;
    }

    public Matrix4f getMatrix() {
        return this._matrix;
    }

    public Transform3D invertLocal() {
        return this.invert(this);
    }

    public Transform3D invert() {
        return this.invert(new Transform3D());
    }

    public Transform3D invert(Transform3D result) {
        switch (this._type) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                this._rotation.invert(result.getRotation()).transformLocal(this._translation.negate(result.getTranslation()));
                return result;
            }
            case 2: {
                result.setType(2);
                this._rotation.invert(result.getRotation()).transformLocal(this._translation.negate(result.getTranslation())).multLocal(result.setScale(1.0f / this._scale));
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.invertAffine(result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.invert(result.getMatrix());
        return result;
    }

    public Transform3D composeLocal(Transform3D other) {
        return this.compose(other, this);
    }

    public Transform3D compose(Transform3D other) {
        return this.compose(other, new Transform3D());
    }

    public Transform3D compose(Transform3D other, Transform3D result) {
        int ctype = Math.max(this.getType(), other.getType());
        this.update(ctype);
        other.update(ctype);
        switch (ctype) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                this._rotation.transformAndAdd(other.getTranslation(), this._translation, result.getTranslation());
                this._rotation.mult(other.getRotation(), result.getRotation());
                return result;
            }
            case 2: {
                result.setType(2);
                this._rotation.transformScaleAndAdd(other.getTranslation(), this._scale, this._translation, result.getTranslation());
                this._rotation.mult(other.getRotation(), result.getRotation());
                result.setScale(this._scale * other.getScale());
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.multAffine(other.getMatrix(), result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.mult(other.getMatrix(), result.getMatrix());
        return result;
    }

    public Transform3D lerpLocal(Transform3D other, float t) {
        return this.lerp(other, t, this);
    }

    public Transform3D lerp(Transform3D other, float t) {
        return this.lerp(other, t, new Transform3D());
    }

    public Transform3D lerp(Transform3D other, float t, Transform3D result) {
        int ctype = Math.max(this.getType(), other.getType());
        this.update(ctype);
        other.update(ctype);
        switch (ctype) {
            default: {
                return result.setToIdentity();
            }
            case 1: {
                result.setType(1);
                this._translation.lerp(other.getTranslation(), t, result.getTranslation());
                this._rotation.slerp(other.getRotation(), t, result.getRotation());
                return result;
            }
            case 2: {
                result.setType(2);
                this._translation.lerp(other.getTranslation(), t, result.getTranslation());
                this._rotation.slerp(other.getRotation(), t, result.getRotation());
                result.setScale(FloatMath.lerp(this._scale, other.getScale(), t));
                return result;
            }
            case 3: {
                result.setType(3);
                this._matrix.lerpAffine(other.getMatrix(), t, result.getMatrix());
                return result;
            }
            case 4: 
        }
        result.setType(4);
        this._matrix.lerp(other.getMatrix(), t, result.getMatrix());
        return result;
    }

    public Transform3D set(Transform3D transform) {
        switch (transform.getType()) {
            default: {
                return this.setToIdentity();
            }
            case 1: {
                return this.set(transform.getTranslation(), transform.getRotation());
            }
            case 2: {
                return this.set(transform.getTranslation(), transform.getRotation(), transform.getScale());
            }
            case 3: {
                return this.set(transform.getMatrix(), true);
            }
            case 4: 
        }
        return this.set(transform.getMatrix(), false);
    }

    public Transform3D set(Transform2D transform) {
        int type = transform.getType();
        switch (type) {
            default: {
                return this.setToIdentity();
            }
            case 1: 
            case 2: {
                this.setType(type);
                Vector2f translation = transform.getTranslation();
                this._translation.set(translation.x, translation.y, 0.0f);
                this._rotation.fromAngleAxis(transform.getRotation(), Vector3f.UNIT_Z);
                if (type == 2) {
                    this._scale = transform.getScale();
                }
                return this;
            }
            case 3: 
            case 4: 
        }
        this.setType(type);
        Matrix3f matrix = transform.getMatrix();
        this._matrix.set(matrix.m00, matrix.m10, 0.0f, matrix.m20, matrix.m01, matrix.m11, 0.0f, matrix.m21, 0.0f, 0.0f, 1.0f, 0.0f, matrix.m02, matrix.m12, 0.0f, matrix.m22);
        return this;
    }

    public Transform3D setToIdentity() {
        this.setType(0);
        return this;
    }

    public Transform3D set(Vector3f translation, Quaternion rotation) {
        this.setType(1);
        this._translation.set(translation);
        this._rotation.set(rotation);
        return this;
    }

    public Transform3D set(Vector3f translation, Quaternion rotation, float scale) {
        this.setType(2);
        this._translation.set(translation);
        this._rotation.set(rotation);
        this._scale = scale;
        return this;
    }

    public Transform3D set(Vector3f translation, Quaternion rotation, Vector3f scale) {
        this.setType(3);
        this._matrix.setToTransform(translation, rotation, scale);
        return this;
    }

    public Transform3D set(Matrix4f matrix) {
        return this.set(matrix, false);
    }

    public Transform3D set(Matrix4f matrix, boolean affine) {
        this.setType(affine ? 3 : 4);
        this._matrix.set(matrix);
        return this;
    }

    public Transform3D promote(int type) {
        this.update(type);
        this.setType(type);
        return this;
    }

    public Transform3D update(int utype) {
        if (this._type == 0) {
            if (utype >= 3) {
                this._matrix = this._matrix == null ? new Matrix4f() : this._matrix.setToIdentity();
            } else if (utype >= 1) {
                this._translation = this._translation == null ? new Vector3f() : this._translation.set(Vector3f.ZERO);
                this._rotation = this._rotation == null ? new Quaternion() : this._rotation.set(Quaternion.IDENTITY);
                this._scale = 1.0f;
            }
        } else if (this._type == 1) {
            if (utype >= 3) {
                (this._matrix == null ? (this._matrix = new Matrix4f()) : this._matrix).setToTransform(this._translation, this._rotation);
            } else if (utype == 2) {
                this._scale = 1.0f;
            }
        } else if (this._type == 2 && utype >= 3) {
            (this._matrix == null ? (this._matrix = new Matrix4f()) : this._matrix).setToTransform(this._translation, this._rotation, this._scale);
        }
        return this;
    }

    public Vector3f transformPointLocal(Vector3f pt) {
        return this.transformPoint(pt, pt);
    }

    public Vector3f transformPoint(Vector3f pt) {
        return this.transformPoint(pt, new Vector3f());
    }

    public Vector3f transformPoint(Vector3f pt, Vector3f result) {
        switch (this._type) {
            default: {
                return result.set(pt);
            }
            case 1: {
                return this._rotation.transform(pt, result).addLocal(this._translation);
            }
            case 2: {
                return this._rotation.transformLocal(pt.mult(this._scale, result)).addLocal(this._translation);
            }
            case 3: 
            case 4: 
        }
        return this._matrix.transformPoint(pt, result);
    }

    public float transformPointZ(Vector3f pt) {
        switch (this._type) {
            default: {
                return pt.z;
            }
            case 1: {
                return this._rotation.transformZ(pt) + this._translation.z;
            }
            case 2: {
                return this._rotation.transformZ(pt) * this._scale + this._translation.z;
            }
            case 3: 
            case 4: 
        }
        return this._matrix.transformPointZ(pt);
    }

    public Vector3f transformVectorLocal(Vector3f vec) {
        return this.transformVector(vec, vec);
    }

    public Vector3f transformVector(Vector3f vec) {
        return this.transformVector(vec, new Vector3f());
    }

    public Vector3f transformVector(Vector3f vec, Vector3f result) {
        switch (this._type) {
            default: {
                return result.set(vec);
            }
            case 1: {
                return this._rotation.transform(vec, result);
            }
            case 2: {
                return this._rotation.transformLocal(vec.mult(this._scale, result));
            }
            case 3: 
            case 4: 
        }
        return this._matrix.transformVector(vec, result);
    }

    public Vector3f extractTranslation() {
        return this.extractTranslation(new Vector3f());
    }

    public Vector3f extractTranslation(Vector3f result) {
        switch (this._type) {
            default: {
                return result.set(Vector3f.ZERO);
            }
            case 1: 
            case 2: {
                return result.set(this._translation);
            }
            case 3: 
            case 4: 
        }
        return result.set(this._matrix.m30, this._matrix.m31, this._matrix.m32);
    }

    public Quaternion extractRotation() {
        return this.extractRotation(new Quaternion());
    }

    public Quaternion extractRotation(Quaternion result) {
        switch (this._type) {
            default: {
                return result.set(Quaternion.IDENTITY);
            }
            case 1: 
            case 2: {
                return result.set(this._rotation);
            }
            case 3: 
            case 4: 
        }
        return this._matrix.extractRotation(result);
    }

    public Vector3f extractScale() {
        return this.extractScale(new Vector3f());
    }

    public Vector3f extractScale(Vector3f result) {
        switch (this._type) {
            default: {
                return result.set(1.0f, 1.0f, 1.0f);
            }
            case 2: {
                return result.set(this._scale, this._scale, this._scale);
            }
            case 3: 
            case 4: 
        }
        return this._matrix.extractScale(result);
    }

    public float approximateUniformScale() {
        switch (this._type) {
            default: {
                return 1.0f;
            }
            case 2: {
                return this._scale;
            }
            case 3: 
            case 4: 
        }
        return this._matrix.approximateUniformScale();
    }

    public boolean isMirrored() {
        return this._type == 2 && this._scale < 0.0f || (this._type == 3 || this._type == 4) && this._matrix.isMirrored();
    }

    public void writeFields(Exporter out) throws IOException {
        if (this._type == 0) {
            return;
        }
        if (this._type == 3 || this._type == 4) {
            out.write("matrix", this._matrix, Matrix4f.IDENTITY);
        } else {
            if (this._type == 2) {
                out.write("scale", this._scale, 1.0f);
            }
            out.write("translation", this._translation, Vector3f.ZERO);
            out.write("rotation", this._rotation, Quaternion.IDENTITY);
        }
    }

    public void readFields(Importer in) throws IOException {
        this._translation = in.read("translation", (Vector3f)null);
        this._rotation = in.read("rotation", (Quaternion)null);
        this._scale = in.read("scale", 1.0f);
        this._matrix = in.read("matrix", (Matrix4f)null);
        if (this._matrix != null) {
            this._type = this._matrix.isAffine() ? 3 : 4;
        } else if (this._translation != null || this._rotation != null || this._scale != 1.0f) {
            this._translation = this._translation == null ? new Vector3f() : this._translation;
            this._rotation = this._rotation == null ? new Quaternion() : this._rotation;
            this._type = this._scale == 1.0f ? 1 : 2;
        } else {
            this._type = 0;
        }
    }

    public String toString() {
        switch (this._type) {
            default: {
                return "[]";
            }
            case 1: {
                return "[" + this._translation + ", " + this._rotation + "]";
            }
            case 2: {
                return "[" + this._translation + ", " + this._rotation + ", " + this._scale + "]";
            }
            case 3: 
            case 4: 
        }
        return this._matrix.toString();
    }

    public int hashCode() {
        switch (this._type) {
            default: {
                return this._type;
            }
            case 1: 
            case 2: {
                int hash = 31 * this._type + this._translation.hashCode();
                hash = 31 * hash + this._rotation.hashCode();
                return this._type == 2 ? 31 * hash + Float.floatToIntBits(this._scale) : hash;
            }
            case 3: 
            case 4: 
        }
        return 31 * this._type + this._matrix.hashCode();
    }

    public boolean equals(Object other) {
        Transform3D otrans = (Transform3D)other;
        if (!(other instanceof Transform3D) || this._type != otrans.getType()) {
            return false;
        }
        switch (this._type) {
            default: {
                return true;
            }
            case 1: {
                return this._translation.equals(otrans.getTranslation()) && this._rotation.equals(otrans.getRotation());
            }
            case 2: {
                return this._translation.equals(otrans.getTranslation()) && this._rotation.equals(otrans.getRotation()) && this._scale == otrans.getScale();
            }
            case 3: 
            case 4: 
        }
        return this._matrix.equals(otrans.getMatrix());
    }
}

