/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;

public final class Ray2D {
    protected Vector2f _origin = new Vector2f();
    protected Vector2f _direction = new Vector2f();

    public Ray2D(Vector2f origin, Vector2f direction) {
        this.set(origin, direction);
    }

    public Ray2D(Ray2D other) {
        this.set(other);
    }

    public Ray2D() {
    }

    public Vector2f getOrigin() {
        return this._origin;
    }

    public Vector2f getDirection() {
        return this._direction;
    }

    public Ray2D transformLocal(Transform2D transform) {
        return this.transform(transform, this);
    }

    public Ray2D transform(Transform2D transform) {
        return this.transform(transform, new Ray2D());
    }

    public Ray2D transform(Transform2D transform, Ray2D result) {
        transform.transformPoint(this._origin, result._origin);
        transform.transformVector(this._direction, result._direction).normalizeLocal();
        return result;
    }

    public Ray2D set(Ray2D other) {
        return this.set(other.getOrigin(), other.getDirection());
    }

    public Ray2D set(Vector2f origin, Vector2f direction) {
        this._origin.set(origin);
        this._direction.set(direction);
        return this;
    }

    public boolean intersects(Vector2f pt) {
        if (Math.abs(this._direction.x) > Math.abs(this._direction.y)) {
            float t = (pt.x - this._origin.x) / this._direction.x;
            return t >= 0.0f && this._origin.y + t * this._direction.y == pt.y;
        }
        float t = (pt.y - this._origin.y) / this._direction.y;
        return t >= 0.0f && this._origin.x + t * this._direction.x == pt.x;
    }

    public boolean getIntersection(Vector2f start, Vector2f end, Vector2f result) {
        boolean isect;
        float ax = this._origin.x;
        float ay = this._origin.y;
        float bx = this._direction.x;
        float by = this._direction.y;
        float cx = start.x;
        float cy = start.y;
        float dy = end.y - start.y;
        float dx = end.x - start.x;
        float divisor = bx * dy - by * dx;
        if (Math.abs(divisor) < 1.0E-6f) {
            boolean isect2;
            float t = Math.min(this.getIntersection(start), this.getIntersection(end));
            boolean bl = isect2 = t != Float.MAX_VALUE;
            if (isect2) {
                this._origin.addScaled(this._direction, t, result);
            }
            return isect2;
        }
        float cxax = cx - ax;
        float cyay = cy - ay;
        float s = (by * cxax - bx * cyay) / divisor;
        if (s < 0.0f || s > 1.0f) {
            return false;
        }
        float t = (dy * cxax - dx * cyay) / divisor;
        boolean bl = isect = t >= 0.0f;
        if (isect) {
            this._origin.addScaled(this._direction, t, result);
        }
        return isect;
    }

    public boolean getIntersection(Vector2f start, Vector2f end, float radius, Vector2f result) {
        float y;
        float x;
        boolean below;
        float c;
        float dist;
        float a = start.y - end.y;
        float b = end.x - start.x;
        float len = FloatMath.hypot(a, b);
        if (len < 1.0E-6f) {
            return this.getIntersection(start, radius, result);
        }
        float rlen = 1.0f / len;
        boolean above = (dist = (a *= rlen) * this._origin.x + (b *= rlen) * this._origin.y + (c = -a * start.x - b * start.y)) > radius;
        boolean bl = below = dist < -radius;
        if (above || below) {
            float divisor = a * this._direction.x + b * this._direction.y;
            if (Math.abs(divisor) < 1.0E-6f) {
                return false;
            }
            float t = (-a * this._origin.x - b * this._origin.y - (c += above ? -radius : radius)) / divisor;
            if (t < 0.0f) {
                return false;
            }
            x = this._origin.x + t * this._direction.x;
            y = this._origin.y + t * this._direction.y;
        } else {
            x = this._origin.x;
            y = this._origin.y;
        }
        float tmp = a;
        a = b;
        b = -tmp;
        c = -a * start.x - b * start.y;
        dist = a * x + b * y + c;
        if (dist < 0.0f) {
            return this.getIntersection(start, radius, result);
        }
        if (dist > len) {
            return this.getIntersection(end, radius, result);
        }
        result.set(x, y);
        return true;
    }

    public boolean getIntersection(Vector2f center, float radius, Vector2f result) {
        boolean isect;
        if (this._origin.distanceSquared(center) <= radius * radius) {
            result.set(this._origin);
            return true;
        }
        float ax = this._origin.x - center.x;
        float ay = this._origin.y - center.y;
        float b = 2.0f * (this._direction.x * ax + this._direction.y * ay);
        float c = ax * ax + ay * ay - radius * radius;
        float radicand = b * b - 4.0f * c;
        if (radicand < 0.0f) {
            return false;
        }
        float t = (-b - FloatMath.sqrt(radicand)) * 0.5f;
        boolean bl = isect = t >= 0.0f;
        if (isect) {
            this._origin.addScaled(this._direction, t, result);
        }
        return isect;
    }

    public Vector2f getNearestPoint(Vector2f point, Vector2f result) {
        if (result == null) {
            result = new Vector2f();
        }
        float r = point.subtract(this._origin).dot(this._direction);
        result.set(this._origin.add(this._direction.mult(r)));
        return result;
    }

    public String toString() {
        return "[origin=" + this._origin + ", direction=" + this._direction + "]";
    }

    protected float getIntersection(Vector2f pt) {
        if (Math.abs(this._direction.x) > Math.abs(this._direction.y)) {
            float t = (pt.x - this._origin.x) / this._direction.x;
            return t >= 0.0f && this._origin.y + t * this._direction.y == pt.y ? t : Float.MAX_VALUE;
        }
        float t = (pt.y - this._origin.y) / this._direction.y;
        return t >= 0.0f && this._origin.x + t * this._direction.x == pt.x ? t : Float.MAX_VALUE;
    }
}

