/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.DoubleBuffer;

public class Plane
implements Encodable,
Streamable {
    public static final Plane XY_PLANE = new Plane(Vector3f.UNIT_Z, 0.0f);
    public static final Plane XZ_PLANE = new Plane(Vector3f.UNIT_Y, 0.0f);
    public static final Plane YZ_PLANE = new Plane(Vector3f.UNIT_X, 0.0f);
    public float constant;
    protected Vector3f _normal = new Vector3f();
    protected Vector3f _v1 = new Vector3f();
    protected Vector3f _v2 = new Vector3f();

    public Plane(Vector3f normal, float constant) {
        this.set(normal, constant);
    }

    public Plane(float[] values) {
        this.set(values);
    }

    public Plane(float a, float b, float c, float d) {
        this.set(a, b, c, d);
    }

    public Plane(Plane other) {
        this.set(other);
    }

    public Plane() {
    }

    public Vector3f getNormal() {
        return this._normal;
    }

    public Plane fromPoints(Vector3f p1, Vector3f p2, Vector3f p3) {
        p2.subtract(p1, this._v1);
        p3.subtract(p1, this._v2);
        this._v1.cross(this._v2, this._normal).normalizeLocal();
        this.constant = -this._normal.dot(p1);
        return this;
    }

    public Plane fromPointNormal(Vector3f pt, Vector3f normal) {
        return this.set(normal, -normal.dot(pt));
    }

    public Plane set(Plane other) {
        return this.set(other.getNormal(), other.constant);
    }

    public Plane set(Vector3f normal, float constant) {
        return this.set(normal.x, normal.y, normal.z, constant);
    }

    public Plane set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3]);
    }

    public Plane set(float a, float b, float c, float d) {
        this._normal.set(a, b, c);
        this.constant = d;
        return this;
    }

    public Plane transformLocal(Transform3D transform) {
        return this.transform(transform, this);
    }

    public Plane transform(Transform3D transform) {
        return this.transform(transform, new Plane());
    }

    public Plane transform(Transform3D transform, Plane result) {
        transform.transformPointLocal(this._normal.mult(-this.constant, this._v1));
        transform.transformVector(this._normal, this._v2).normalizeLocal();
        return result.fromPointNormal(this._v1, this._v2);
    }

    public Plane negateLocal() {
        return this.negate(this);
    }

    public Plane negate() {
        return this.negate(new Plane());
    }

    public Plane negate(Plane result) {
        this._normal.negate(result.getNormal());
        result.constant = -this.constant;
        return result;
    }

    public boolean getIntersection(Ray3D ray, Vector3f result) {
        float distance = this.getDistance(ray);
        if (Float.isNaN(distance) || distance < 0.0f) {
            return false;
        }
        ray.getOrigin().addScaled(ray.getDirection(), distance, result);
        return true;
    }

    public float getDistance(Ray3D ray) {
        float dividend = -this.getDistance(ray.getOrigin());
        float divisor = this._normal.dot(ray.getDirection());
        if (Math.abs(dividend) < 1.0E-6f) {
            return 0.0f;
        }
        if (Math.abs(divisor) < 1.0E-6f) {
            return Float.NaN;
        }
        return dividend / divisor;
    }

    public float getDistance(Vector3f pt) {
        return this._normal.dot(pt) + this.constant;
    }

    public DoubleBuffer get(DoubleBuffer buf) {
        return buf.put(this._normal.x).put(this._normal.y).put(this._normal.z).put(this.constant);
    }

    @Override
    public String encodeToString() {
        return this._normal.x + ", " + this._normal.y + ", " + this._normal.z + ", " + this.constant;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this._normal.x);
        out.writeFloat(this._normal.y);
        out.writeFloat(this._normal.z);
        out.writeFloat(this.constant);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public int hashCode() {
        return this._normal.hashCode() ^ Float.floatToIntBits(this.constant);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Plane)) {
            return false;
        }
        Plane oplane = (Plane)other;
        return this.constant == oplane.constant && this._normal.equals(oplane.getNormal());
    }
}

