/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.SingularMatrixException;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Matrix3f
implements Encodable,
Streamable {
    public static final Matrix3f IDENTITY = new Matrix3f();
    public float m00;
    public float m10;
    public float m20;
    public float m01;
    public float m11;
    public float m21;
    public float m02;
    public float m12;
    public float m22;

    public Matrix3f(float m00, float m10, float m20, float m01, float m11, float m21, float m02, float m12, float m22) {
        this.set(m00, m10, m20, m01, m11, m21, m02, m12, m22);
    }

    public Matrix3f(float[] values) {
        this.set(values);
    }

    public Matrix3f(Matrix3f other) {
        this.set(other);
    }

    public Matrix3f() {
        this.setToIdentity();
    }

    public Matrix3f setToIdentity() {
        return this.set(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f setToRotation(Vector3f from, Vector3f to) {
        float angle = from.angle(to);
        return angle < 1.0E-4f ? this.setToIdentity() : this.setToRotation(angle, from.cross(to).normalizeLocal());
    }

    public Matrix3f setToRotation(float angle, Vector3f axis) {
        return this.setToRotation(angle, axis.x, axis.y, axis.z);
    }

    public Matrix3f setToRotation(float angle, float x, float y, float z) {
        float c = FloatMath.cos(angle);
        float s = FloatMath.sin(angle);
        float omc = 1.0f - c;
        float xs = x * s;
        float ys = y * s;
        float zs = z * s;
        float xy = x * y;
        float xz = x * z;
        float yz = y * z;
        return this.set(x * x * omc + c, xy * omc - zs, xz * omc + ys, xy * omc + zs, y * y * omc + c, yz * omc - xs, xz * omc - ys, yz * omc + xs, z * z * omc + c);
    }

    public Matrix3f setToRotation(Quaternion quat) {
        float xx = quat.x * quat.x;
        float yy = quat.y * quat.y;
        float zz = quat.z * quat.z;
        float xy = quat.x * quat.y;
        float xz = quat.x * quat.z;
        float xw = quat.x * quat.w;
        float yz = quat.y * quat.z;
        float yw = quat.y * quat.w;
        float zw = quat.z * quat.w;
        return this.set(1.0f - 2.0f * (yy + zz), 2.0f * (xy - zw), 2.0f * (xz + yw), 2.0f * (xy + zw), 1.0f - 2.0f * (xx + zz), 2.0f * (yz - xw), 2.0f * (xz - yw), 2.0f * (yz + xw), 1.0f - 2.0f * (xx + yy));
    }

    public Matrix3f setToScale(Vector3f scale) {
        return this.setToScale(scale.x, scale.y, scale.z);
    }

    public Matrix3f setToScale(float s) {
        return this.setToScale(s, s, s);
    }

    public Matrix3f setToScale(float x, float y, float z) {
        return this.set(x, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, z);
    }

    public Matrix3f setToReflection(Vector3f normal) {
        return this.setToReflection(normal.x, normal.y, normal.z);
    }

    public Matrix3f setToReflection(float x, float y, float z) {
        float x2 = -2.0f * x;
        float y2 = -2.0f * y;
        float z2 = -2.0f * z;
        float xy2 = x2 * y;
        float xz2 = x2 * z;
        float yz2 = y2 * z;
        return this.set(1.0f + x2 * x, xy2, xz2, xy2, 1.0f + y2 * y, yz2, xz2, yz2, 1.0f + z2 * z);
    }

    public Matrix3f setToTransform(Vector2f translation, float rotation) {
        return this.setToRotation(rotation).setTranslation(translation);
    }

    public Matrix3f setToTransform(Vector2f translation, float rotation, float scale) {
        return this.setToRotation(rotation).set(this.m00 * scale, this.m10 * scale, translation.x, this.m01 * scale, this.m11 * scale, translation.y, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f setToTransform(Vector2f translation, float rotation, Vector2f scale) {
        return this.setToRotation(rotation).set(this.m00 * scale.x, this.m10 * scale.y, translation.x, this.m01 * scale.x, this.m11 * scale.y, translation.y, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f setToTranslation(Vector2f translation) {
        return this.setToTranslation(translation.x, translation.y);
    }

    public Matrix3f setToTranslation(float x, float y) {
        return this.set(1.0f, 0.0f, x, 0.0f, 1.0f, y, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f setTranslation(Vector2f translation) {
        return this.setTranslation(translation.x, translation.y);
    }

    public Matrix3f setTranslation(float x, float y) {
        this.m20 = x;
        this.m21 = y;
        return this;
    }

    public Matrix3f setToRotation(float angle) {
        float sina = FloatMath.sin(angle);
        float cosa = FloatMath.cos(angle);
        return this.set(cosa, -sina, 0.0f, sina, cosa, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f transposeLocal() {
        return this.transpose(this);
    }

    public Matrix3f transpose() {
        return this.transpose(new Matrix3f());
    }

    public Matrix3f transpose(Matrix3f result) {
        return result.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Matrix3f multLocal(Matrix3f other) {
        return this.mult(other, this);
    }

    public Matrix3f mult(Matrix3f other) {
        return this.mult(other, new Matrix3f());
    }

    public Matrix3f mult(Matrix3f other, Matrix3f result) {
        return result.set(this.m00 * other.m00 + this.m10 * other.m01 + this.m20 * other.m02, this.m00 * other.m10 + this.m10 * other.m11 + this.m20 * other.m12, this.m00 * other.m20 + this.m10 * other.m21 + this.m20 * other.m22, this.m01 * other.m00 + this.m11 * other.m01 + this.m21 * other.m02, this.m01 * other.m10 + this.m11 * other.m11 + this.m21 * other.m12, this.m01 * other.m20 + this.m11 * other.m21 + this.m21 * other.m22, this.m02 * other.m00 + this.m12 * other.m01 + this.m22 * other.m02, this.m02 * other.m10 + this.m12 * other.m11 + this.m22 * other.m12, this.m02 * other.m20 + this.m12 * other.m21 + this.m22 * other.m22);
    }

    public boolean isAffine() {
        return this.m02 == 0.0f && this.m12 == 0.0f && this.m22 == 1.0f;
    }

    public Matrix3f multAffineLocal(Matrix3f other) {
        return this.multAffine(other, this);
    }

    public Matrix3f multAffine(Matrix3f other) {
        return this.multAffine(other, new Matrix3f());
    }

    public Matrix3f multAffine(Matrix3f other, Matrix3f result) {
        return result.set(this.m00 * other.m00 + this.m10 * other.m01, this.m00 * other.m10 + this.m10 * other.m11, this.m00 * other.m20 + this.m10 * other.m21 + this.m20, this.m01 * other.m00 + this.m11 * other.m01, this.m01 * other.m10 + this.m11 * other.m11, this.m01 * other.m20 + this.m11 * other.m21 + this.m21, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f invertLocal() {
        return this.invert(this);
    }

    public Matrix3f invert() {
        return this.invert(new Matrix3f());
    }

    public Matrix3f invert(Matrix3f result) throws SingularMatrixException {
        float sd00 = this.m11 * this.m22 - this.m21 * this.m12;
        float sd20 = this.m01 * this.m12 - this.m11 * this.m02;
        float sd10 = this.m01 * this.m22 - this.m21 * this.m02;
        float det = this.m00 * sd00 + this.m20 * sd20 - this.m10 * sd10;
        if (Math.abs(det) == 0.0f) {
            throw new SingularMatrixException(this.toString());
        }
        float rdet = 1.0f / det;
        return result.set(sd00 * rdet, -(this.m10 * this.m22 - this.m20 * this.m12) * rdet, (this.m10 * this.m21 - this.m20 * this.m11) * rdet, -sd10 * rdet, (this.m00 * this.m22 - this.m20 * this.m02) * rdet, -(this.m00 * this.m21 - this.m20 * this.m01) * rdet, sd20 * rdet, -(this.m00 * this.m12 - this.m10 * this.m02) * rdet, (this.m00 * this.m11 - this.m10 * this.m01) * rdet);
    }

    public Matrix3f invertAffineLocal() {
        return this.invertAffine(this);
    }

    public Matrix3f invertAffine() {
        return this.invertAffine(new Matrix3f());
    }

    public Matrix3f invertAffine(Matrix3f result) throws SingularMatrixException {
        float det = this.m00 * this.m11 - this.m10 * this.m01;
        if (Math.abs(det) == 0.0f) {
            throw new SingularMatrixException(this.toString());
        }
        float rdet = 1.0f / det;
        return result.set(this.m11 * rdet, -this.m10 * rdet, (this.m10 * this.m21 - this.m20 * this.m11) * rdet, -this.m01 * rdet, this.m00 * rdet, -(this.m00 * this.m21 - this.m20 * this.m01) * rdet, 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f lerpLocal(Matrix3f other, float t) {
        return this.lerp(other, t, this);
    }

    public Matrix3f lerp(Matrix3f other, float t) {
        return this.lerp(other, t, new Matrix3f());
    }

    public Matrix3f lerp(Matrix3f other, float t, Matrix3f result) {
        return result.set(this.m00 + t * (other.m00 - this.m00), this.m10 + t * (other.m10 - this.m10), this.m20 + t * (other.m20 - this.m20), this.m01 + t * (other.m01 - this.m01), this.m11 + t * (other.m11 - this.m11), this.m21 + t * (other.m21 - this.m21), this.m02 + t * (other.m02 - this.m02), this.m12 + t * (other.m12 - this.m12), this.m22 + t * (other.m22 - this.m22));
    }

    public Matrix3f lerpAffineLocal(Matrix3f other, float t) {
        return this.lerpAffine(other, t, this);
    }

    public Matrix3f lerpAffine(Matrix3f other, float t) {
        return this.lerpAffine(other, t, new Matrix3f());
    }

    public Matrix3f lerpAffine(Matrix3f other, float t, Matrix3f result) {
        return result.set(this.m00 + t * (other.m00 - this.m00), this.m10 + t * (other.m10 - this.m10), this.m20 + t * (other.m20 - this.m20), this.m01 + t * (other.m01 - this.m01), this.m11 + t * (other.m11 - this.m11), this.m21 + t * (other.m21 - this.m21), 0.0f, 0.0f, 1.0f);
    }

    public Matrix3f set(Matrix3f other) {
        return this.set(other.m00, other.m10, other.m20, other.m01, other.m11, other.m21, other.m02, other.m12, other.m22);
    }

    public Matrix3f set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8]);
    }

    public Matrix3f set(float m00, float m10, float m20, float m01, float m11, float m21, float m02, float m12, float m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public FloatBuffer get(FloatBuffer buf) {
        buf.put(this.m00).put(this.m01).put(this.m02);
        buf.put(this.m10).put(this.m11).put(this.m12);
        buf.put(this.m20).put(this.m21).put(this.m22);
        return buf;
    }

    public Vector3f transformLocal(Vector3f vector) {
        return this.transform(vector, vector);
    }

    public Vector3f transform(Vector3f vector) {
        return this.transform(vector, new Vector3f());
    }

    public Vector3f transform(Vector3f vector, Vector3f result) {
        return result.set(this.m00 * vector.x + this.m10 * vector.y + this.m20 * vector.z, this.m01 * vector.x + this.m11 * vector.y + this.m21 * vector.z, this.m02 * vector.x + this.m12 * vector.y + this.m22 * vector.z);
    }

    public Vector2f transformPointLocal(Vector2f point) {
        return this.transformPoint(point, point);
    }

    public Vector2f transformPoint(Vector2f point) {
        return this.transformPoint(point, new Vector2f());
    }

    public Vector2f transformPoint(Vector2f point, Vector2f result) {
        return result.set(this.m00 * point.x + this.m10 * point.y + this.m20, this.m01 * point.x + this.m11 * point.y + this.m21);
    }

    public Vector2f transformVectorLocal(Vector2f vector) {
        return this.transformVector(vector, vector);
    }

    public Vector2f transformVector(Vector2f vector) {
        return this.transformVector(vector, new Vector2f());
    }

    public Vector2f transformVector(Vector2f vector, Vector2f result) {
        return result.set(this.m00 * vector.x + this.m10 * vector.y, this.m01 * vector.x + this.m11 * vector.y);
    }

    public float extractRotation() {
        float n00 = this.m00;
        float n10 = this.m10;
        float n01 = this.m01;
        float n11 = this.m11;
        for (int ii = 0; ii < 10; ++ii) {
            float o00 = n00;
            float o11 = n11;
            float o10 = n10;
            float o01 = n01;
            float det = o00 * o11 - o10 * o01;
            if (Math.abs(det) == 0.0f) {
                throw new SingularMatrixException(this.toString());
            }
            float hrdet = 0.5f / det;
            n00 = o11 * hrdet + o00 * 0.5f;
            float d00 = n00 - o00;
            n10 = -o01 * hrdet + o10 * 0.5f;
            float d10 = n10 - o10;
            n01 = -o10 * hrdet + o01 * 0.5f;
            float d01 = n01 - o01;
            n11 = o00 * hrdet + o11 * 0.5f;
            float d11 = n11 - o11;
            if (d00 * d00 + d10 * d10 + d01 * d01 + d11 * d11 < 1.0E-6f) break;
        }
        return FloatMath.atan2(n01, n00);
    }

    public Vector2f extractScale() {
        return this.extractScale(new Vector2f());
    }

    public Vector2f extractScale(Vector2f result) {
        return result.set(FloatMath.sqrt(this.m00 * this.m00 + this.m01 * this.m01), FloatMath.sqrt(this.m10 * this.m10 + this.m11 * this.m11));
    }

    public float approximateUniformScale() {
        float cp = this.m00 * this.m11 - this.m01 * this.m10;
        return cp < 0.0f ? -FloatMath.sqrt(-cp) : FloatMath.sqrt(cp);
    }

    @Override
    public String encodeToString() {
        return this.m00 + ", " + this.m10 + ", " + this.m20 + ", " + this.m01 + ", " + this.m11 + ", " + this.m21 + ", " + this.m02 + ", " + this.m12 + ", " + this.m22;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.m00);
        out.writeFloat(this.m10);
        out.writeFloat(this.m20);
        out.writeFloat(this.m01);
        out.writeFloat(this.m11);
        out.writeFloat(this.m21);
        out.writeFloat(this.m02);
        out.writeFloat(this.m12);
        out.writeFloat(this.m22);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[[" + this.m00 + ", " + this.m10 + ", " + this.m20 + "], [" + this.m01 + ", " + this.m11 + ", " + this.m21 + "], [" + this.m02 + ", " + this.m12 + ", " + this.m22 + "]]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.m00) ^ Float.floatToIntBits(this.m10) ^ Float.floatToIntBits(this.m20) ^ Float.floatToIntBits(this.m01) ^ Float.floatToIntBits(this.m11) ^ Float.floatToIntBits(this.m21) ^ Float.floatToIntBits(this.m02) ^ Float.floatToIntBits(this.m12) ^ Float.floatToIntBits(this.m22);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Matrix3f)) {
            return false;
        }
        Matrix3f omat = (Matrix3f)other;
        return this.m00 == omat.m00 && this.m10 == omat.m10 && this.m20 == omat.m20 && this.m01 == omat.m01 && this.m11 == omat.m11 && this.m21 == omat.m21 && this.m02 == omat.m02 && this.m12 == omat.m12 && this.m22 == omat.m22;
    }
}

