/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.math.Ray2D;
import com.threerings.math.Vector2f;

public class Line {
    public static final Line X_AXIS = new Line(Vector2f.UNIT_Y, 0.0f);
    public static final Line Y_AXIS = new Line(Vector2f.UNIT_X, 0.0f);
    public float constant;
    protected Vector2f _normal = new Vector2f();

    public Line(Vector2f normal, float constant) {
        this.set(normal, constant);
    }

    public Line(float a, float b, float c) {
        this.set(a, b, c);
    }

    public Line(Line other) {
        this.set(other);
    }

    public Line() {
    }

    public Vector2f getNormal() {
        return this._normal;
    }

    public Line fromPoints(Vector2f p1, Vector2f p2) {
        this._normal.set(p1.y - p2.y, p2.x - p1.x).normalizeLocal();
        this.constant = -this._normal.dot(p1);
        return this;
    }

    public Line set(Line other) {
        return this.set(other.getNormal(), other.constant);
    }

    public Line set(Vector2f normal, float constant) {
        return this.set(normal.x, normal.y, constant);
    }

    public Line set(float a, float b, float c) {
        this._normal.set(a, b);
        this.constant = c;
        return this;
    }

    public boolean getIntersection(Ray2D ray, Vector2f result) {
        float distance = this.getDistance(ray);
        if (Float.isNaN(distance) || distance < 0.0f) {
            return false;
        }
        ray.getOrigin().addScaled(ray.getDirection(), distance, result);
        return true;
    }

    public float getDistance(Ray2D ray) {
        float dividend = -this.getDistance(ray.getOrigin());
        float divisor = this._normal.dot(ray.getDirection());
        if (Math.abs(dividend) < 1.0E-6f) {
            return 0.0f;
        }
        if (Math.abs(divisor) < 1.0E-6f) {
            return Float.NaN;
        }
        return dividend / divisor;
    }

    public float getDistance(Vector2f pt) {
        return this._normal.dot(pt) + this.constant;
    }

    public int hashCode() {
        return this._normal.hashCode() ^ Float.floatToIntBits(this.constant);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Line)) {
            return false;
        }
        Line oline = (Line)other;
        return this.constant == oline.constant && this._normal.equals(oline.getNormal());
    }
}

