/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.RandomUtil;
import com.threerings.math.Vector3f;

public class FloatMath {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 0.7853982f;
    public static final float E = (float)Math.E;
    public static final float EPSILON = 1.0E-6f;

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float asin(float a) {
        return (float)Math.asin(a);
    }

    public static float acos(float a) {
        return (float)Math.acos(a);
    }

    public static float atan(float a) {
        return (float)Math.atan(a);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float toDegrees(float a) {
        return a * 57.295776f;
    }

    public static float toRadians(float a) {
        return a * ((float)Math.PI / 180);
    }

    public static float sqrt(float v) {
        return (float)Math.sqrt(v);
    }

    public static float cbrt(float v) {
        return (float)Math.cbrt(v);
    }

    public static float hypot(float x, float y) {
        return (float)Math.hypot(x, y);
    }

    public static float exp(float v) {
        return (float)Math.exp(v);
    }

    public static float log(float v) {
        return (float)Math.log(v);
    }

    public static float log10(float v) {
        return (float)Math.log10(v);
    }

    public static float pow(float v, float e) {
        return (float)Math.pow(v, e);
    }

    public static float floor(float v) {
        return (float)Math.floor(v);
    }

    public static int round(float v) {
        return v < 0.0f ? (int)(v - 0.5f) : (int)(v + 0.5f);
    }

    public static int ifloor(float v) {
        int iv = (int)v;
        return v < 0.0f ? ((float)iv == v || iv == Integer.MIN_VALUE ? iv : iv - 1) : iv;
    }

    public static float ceil(float v) {
        return (float)Math.ceil(v);
    }

    public static int iceil(float v) {
        int iv = (int)v;
        return v > 0.0f ? ((float)iv == v || iv == Integer.MAX_VALUE ? iv : iv + 1) : iv;
    }

    public static float IEEEremainder(float f1, float f2) {
        return (float)Math.IEEEremainder(f1, f2);
    }

    public static float clamp(float v, float lower, float upper) {
        return Math.min(Math.max(v, lower), upper);
    }

    public static float roundNearest(float v, float target) {
        target = Math.abs(target);
        if (v >= 0.0f) {
            return target * FloatMath.floor((v + 0.5f * target) / target);
        }
        return target * FloatMath.ceil((v - 0.5f * target) / target);
    }

    public static boolean isWithin(float v, float lower, float upper) {
        return v >= lower && v <= upper;
    }

    public static float random(float lower, float upper) {
        return FloatMath.lerp(lower, upper, FloatMath.random());
    }

    public static float random() {
        return RandomUtil.rand.nextFloat();
    }

    public static float normal(float mean, float stddev) {
        return stddev * FloatMath.normal() + mean;
    }

    public static float normal() {
        return (float)RandomUtil.rand.nextGaussian();
    }

    public static float exponential(float mean) {
        return -FloatMath.log(1.0f - FloatMath.random()) * mean;
    }

    public static float lerpa(float a1, float a2, float t) {
        float md;
        float ma1 = FloatMath.mirrorAngle(a1);
        float ma2 = FloatMath.mirrorAngle(a2);
        float d = Math.abs(a2 - a1);
        return d < (md = Math.abs(ma1 - ma2)) ? FloatMath.lerp(a1, a2, t) : FloatMath.mirrorAngle(FloatMath.lerp(ma1, ma2, t));
    }

    public static float lerp(float v1, float v2, float t) {
        return v1 + t * (v2 - v1);
    }

    public static boolean epsilonEquals(float v1, float v2) {
        return Math.abs(v1 - v2) < 1.0E-6f;
    }

    public static float getAngularDistance(float a1, float a2) {
        float ma1 = FloatMath.mirrorAngle(a1);
        float ma2 = FloatMath.mirrorAngle(a2);
        return Math.min(Math.abs(a1 - a2), Math.abs(ma1 - ma2));
    }

    public static float getAngularDifference(float a1, float a2) {
        float ma1 = FloatMath.mirrorAngle(a1);
        float ma2 = FloatMath.mirrorAngle(a2);
        float diff = a1 - a2;
        float mdiff = ma2 - ma1;
        return Math.abs(diff) < Math.abs(mdiff) ? diff : mdiff;
    }

    public static float normalizeAngle(float a) {
        while (a < (float)(-Math.PI)) {
            a += (float)Math.PI * 2;
        }
        while (a > (float)Math.PI) {
            a -= (float)Math.PI * 2;
        }
        return a;
    }

    public static float normalizeAnglePositive(float a) {
        while (a < 0.0f) {
            a += (float)Math.PI * 2;
        }
        while (a > (float)Math.PI * 2) {
            a -= (float)Math.PI * 2;
        }
        return a;
    }

    public static float mirrorAngle(float a) {
        return (a > 0.0f ? (float)Math.PI : (float)(-Math.PI)) - a;
    }

    public static Vector3f reflect(Vector3f i, Vector3f n) {
        return FloatMath.reflect(i, n, new Vector3f());
    }

    public static Vector3f reflect(Vector3f i, Vector3f n, Vector3f result) {
        return result.set(n).multLocal(-2.0f * n.dot(i)).addLocal(i);
    }

    public static Vector3f refract(Vector3f i, Vector3f n, float eta) {
        return FloatMath.refract(i, n, eta, new Vector3f());
    }

    public static Vector3f refract(Vector3f i, Vector3f n, float eta, Vector3f result) {
        float ndoti = n.dot(i);
        float k = 1.0f - eta * eta * (1.0f - ndoti * ndoti);
        return k < 0.0f ? result.set(Vector3f.ZERO) : result.set(n).multLocal(-eta * ndoti - FloatMath.sqrt(k)).addScaledLocal(i, eta);
    }

    public static Vector3f updateClosest(Vector3f origin, Vector3f result, Vector3f closest) {
        if (result == closest) {
            return new Vector3f();
        }
        if (origin.distanceSquared(result) < origin.distanceSquared(closest)) {
            closest.set(result);
        }
        return result;
    }
}

