/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Quaternion;

@EditorTypes(value={Constant.class, Reference.class, Angles.class})
public abstract class QuaternionExpression
extends ObjectExpression<Quaternion> {

    public static class Angles
    extends QuaternionExpression {
        @Editable
        public FloatExpression x = new FloatExpression.Constant();
        @Editable
        public FloatExpression y = new FloatExpression.Constant();
        @Editable
        public FloatExpression z = new FloatExpression.Constant();

        @Override
        public ObjectExpression.Evaluator<Quaternion> createEvaluator(Scope scope) {
            final FloatExpression.Evaluator xeval = this.x.createEvaluator(scope);
            final FloatExpression.Evaluator yeval = this.y.createEvaluator(scope);
            final FloatExpression.Evaluator zeval = this.z.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Quaternion>(){
                protected Quaternion _result = new Quaternion();

                @Override
                public Quaternion evaluate() {
                    return this._result.fromAngles(xeval.evaluate(), yeval.evaluate(), zeval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.x.invalidate();
            this.y.invalidate();
            this.z.invalidate();
        }
    }

    public static class Reference
    extends QuaternionExpression {
        @Editable
        public String name = "";
        @Editable
        public Quaternion defvalue = new Quaternion();

        @Override
        public ObjectExpression.Evaluator<Quaternion> createEvaluator(Scope scope) {
            final Quaternion value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Quaternion>(){

                @Override
                public Quaternion evaluate() {
                    return value;
                }
            };
        }
    }

    public static class Constant
    extends QuaternionExpression {
        @Editable
        public Quaternion value = new Quaternion();

        @Override
        public ObjectExpression.Evaluator<Quaternion> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Quaternion>(){

                @Override
                public Quaternion evaluate() {
                    return value;
                }
            };
        }
    }
}

