/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionParser;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scope;
import com.threerings.expr.Variable;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.FloatMath;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.NoiseUtil;
import java.io.Reader;
import java.io.StringReader;

@EditorTypes(value={Parsed.class, Constant.class, Reference.class, Clock.class, Negate.class, Add.class, Subtract.class, Multiply.class, Divide.class, Remainder.class, Pow.class, Exp.class, Sin.class, Cos.class, Tan.class, Square.class, Triangle.class, Ramp.class, Saw.class, Noise1.class, Noise2.class})
public abstract class FloatExpression
extends DeepObject
implements Exportable {
    public abstract Evaluator createEvaluator(Scope var1);

    public void invalidate() {
    }

    protected static FloatExpression parseExpression(String expression) throws Exception {
        return (FloatExpression)new ExpressionParser<Object>((Reader)new StringReader(expression)){

            @Override
            protected Object handleNumber(double value) {
                return new Constant((float)value);
            }

            @Override
            protected Object handleString(String value) {
                return value;
            }

            @Override
            protected Object handleOperator(String operator, int arity) throws Exception {
                BinaryOperation result;
                if (arity == 1) {
                    if (operator.equals("+")) {
                        return this._output.pop();
                    }
                    if (operator.equals("-")) {
                        Negate negate = new Negate();
                        negate.operand = (FloatExpression)this._output.pop();
                        return negate;
                    }
                    return super.handleOperator(operator, arity);
                }
                if (operator.equals("+")) {
                    result = new Add();
                } else if (operator.equals("-")) {
                    result = new Subtract();
                } else if (operator.equals("*")) {
                    result = new Multiply();
                } else if (operator.equals("/")) {
                    result = new Divide();
                } else if (operator.equals("%")) {
                    result = new Remainder();
                } else {
                    return super.handleOperator(operator, arity);
                }
                result.secondOperand = (FloatExpression)this._output.pop();
                result.firstOperand = (FloatExpression)this._output.pop();
                return result;
            }

            @Override
            protected Object handleFunctionCall(String function, int arity) throws Exception {
                UnaryOperation result;
                if (function.equals("clock")) {
                    this.assertArity("clock", arity, 0, 1);
                    Clock clock = new Clock();
                    clock.scope = arity == 1 ? (String)this._output.pop() : "";
                    return clock;
                }
                if (function.equals("pow")) {
                    this.assertArity("pow", arity, 2, 2);
                    Pow pow = new Pow();
                    pow.secondOperand = (FloatExpression)this._output.pop();
                    pow.firstOperand = (FloatExpression)this._output.pop();
                    return pow;
                }
                if (function.equals("noise2")) {
                    this.assertArity("noise2", arity, 2, 2);
                    Noise2 noise = new Noise2();
                    noise.secondOperand = (FloatExpression)this._output.pop();
                    noise.firstOperand = (FloatExpression)this._output.pop();
                    return noise;
                }
                if (function.equals("max")) {
                    this.assertArity("max", arity, 2, 2);
                    Max max = new Max();
                    max.secondOperand = (FloatExpression)this._output.pop();
                    max.firstOperand = (FloatExpression)this._output.pop();
                    return max;
                }
                if (function.equals("min")) {
                    this.assertArity("min", arity, 2, 2);
                    Min min = new Min();
                    min.secondOperand = (FloatExpression)this._output.pop();
                    min.firstOperand = (FloatExpression)this._output.pop();
                    return min;
                }
                if (function.equals("exp")) {
                    result = new Exp();
                } else if (function.equals("sin")) {
                    result = new Sin();
                } else if (function.equals("cos")) {
                    result = new Cos();
                } else if (function.equals("tan")) {
                    result = new Tan();
                } else if (function.equals("square")) {
                    result = new Square();
                } else if (function.equals("triangle")) {
                    result = new Triangle();
                } else if (function.equals("ramp")) {
                    result = new Ramp();
                } else if (function.equals("saw")) {
                    result = new Saw();
                } else if (function.equals("noise1")) {
                    result = new Noise1();
                } else {
                    return super.handleFunctionCall(function, arity);
                }
                this.assertArity(function, arity, 1, 1);
                result.operand = (FloatExpression)this._output.pop();
                return result;
            }

            @Override
            protected Object handleIdentifier(String name) {
                Reference ref = new Reference();
                ref.name = name;
                return ref;
            }

            protected void assertArity(String function, int arity, int min, int max) throws Exception {
                if (arity < min || arity > max) {
                    throw new Exception("Wrong number of arguments for " + function);
                }
            }
        }.parse();
    }

    public static abstract class Evaluator {
        public abstract float evaluate();
    }

    public static class Min
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return Math.min(eval1.evaluate(), eval2.evaluate());
                }
            };
        }
    }

    public static class Max
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return Math.max(eval1.evaluate(), eval2.evaluate());
                }
            };
        }
    }

    public static class Noise2
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return NoiseUtil.getNoise(eval1.evaluate(), eval2.evaluate());
                }
            };
        }
    }

    public static class Pow
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return FloatMath.pow(eval1.evaluate(), eval2.evaluate());
                }
            };
        }
    }

    public static class Remainder
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return eval1.evaluate() % eval2.evaluate();
                }
            };
        }
    }

    public static class Divide
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return eval1.evaluate() / eval2.evaluate();
                }
            };
        }
    }

    public static class Multiply
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return eval1.evaluate() * eval2.evaluate();
                }
            };
        }
    }

    public static class Subtract
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return eval1.evaluate() - eval2.evaluate();
                }
            };
        }
    }

    public static class Add
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return eval1.evaluate() + eval2.evaluate();
                }
            };
        }
    }

    public static abstract class BinaryOperation
    extends FloatExpression {
        @Editable
        public FloatExpression firstOperand = new Constant();
        @Editable
        public FloatExpression secondOperand = new Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return this.createEvaluator(this.firstOperand.createEvaluator(scope), this.secondOperand.createEvaluator(scope));
        }

        @Override
        public void invalidate() {
            this.firstOperand.invalidate();
            this.secondOperand.invalidate();
        }

        protected abstract Evaluator createEvaluator(Evaluator var1, Evaluator var2);
    }

    public static class Noise1
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return NoiseUtil.getNoise(eval.evaluate());
                }
            };
        }
    }

    public static class Saw
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    float mod = (eval.evaluate() / ((float)Math.PI * 2) + 0.5f) % 1.0f;
                    return (mod < 0.0f ? -1.0f : 1.0f) - 2.0f * mod;
                }
            };
        }
    }

    public static class Ramp
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    float mod = (eval.evaluate() / ((float)Math.PI * 2) + 0.5f) % 1.0f;
                    return (mod < 0.0f ? 1.0f : -1.0f) + 2.0f * mod;
                }
            };
        }
    }

    public static class Triangle
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    float val = Math.abs(eval.evaluate() / (float)Math.PI + 0.5f);
                    float mod = 2.0f * (val % 1.0f) - 1.0f;
                    return (FloatMath.ifloor(val) & 1) == 0 ? mod : -mod;
                }
            };
        }
    }

    public static class Square
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return (FloatMath.ifloor(eval.evaluate() / (float)Math.PI) & 1) == 0 ? 1.0f : -1.0f;
                }
            };
        }
    }

    public static class Tan
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return FloatMath.tan(eval.evaluate());
                }
            };
        }
    }

    public static class Cos
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return FloatMath.cos(eval.evaluate());
                }
            };
        }
    }

    public static class Sin
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return FloatMath.sin(eval.evaluate());
                }
            };
        }
    }

    public static class Exp
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return FloatMath.exp(eval.evaluate());
                }
            };
        }
    }

    public static class Negate
    extends UnaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return -eval.evaluate();
                }
            };
        }
    }

    public static abstract class UnaryOperation
    extends FloatExpression {
        @Editable
        public FloatExpression operand = new Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return this.createEvaluator(this.operand.createEvaluator(scope));
        }

        @Override
        public void invalidate() {
            this.operand.invalidate();
        }

        protected abstract Evaluator createEvaluator(Evaluator var1);
    }

    public static class Clock
    extends FloatExpression {
        @Editable
        public String scope = "";

        @Override
        public Evaluator createEvaluator(Scope scope) {
            String name = this.scope.trim();
            name = name.length() > 0 ? name + ":" + "epoch" : "epoch";
            MutableLong defvalue = new MutableLong(System.currentTimeMillis());
            final MutableLong epoch = ScopeUtil.resolve(scope, name, defvalue);
            final MutableLong now = ScopeUtil.resolve(scope, "now", defvalue);
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return (float)(now.value - epoch.value) / 1000.0f;
                }
            };
        }
    }

    public static class Reference
    extends FloatExpression {
        @Editable(hgroup="n")
        public String name = "";
        @Editable(step=0.01, hgroup="n")
        public float defvalue;

        @Override
        public Evaluator createEvaluator(Scope scope) {
            final MutableFloat reference = ScopeUtil.resolve(scope, this.name, (MutableFloat)null);
            if (reference != null) {
                return new Evaluator(){

                    @Override
                    public float evaluate() {
                        return reference.value;
                    }
                };
            }
            final Variable variable = ScopeUtil.resolve(scope, this.name, Variable.newInstance(this.defvalue));
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return variable.getFloat();
                }
            };
        }
    }

    public static class Constant
    extends FloatExpression {
        @Editable(step=0.01)
        public float value;

        public Constant(float value) {
            this.value = value;
        }

        public Constant() {
        }

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return new Evaluator(){

                @Override
                public float evaluate() {
                    return value;
                }
            };
        }
    }

    public static class Parsed
    extends FloatExpression {
        @Editable(width=20)
        public String expression = "0.0";
        @DeepOmit
        protected transient FloatExpression _expr;

        @Override
        public Evaluator createEvaluator(Scope scope) {
            if (this._expr == null) {
                try {
                    this._expr = Parsed.parseExpression(this.expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._expr == null) {
                    this._expr = new Constant(0.0f);
                }
            }
            return this._expr.createEvaluator(scope);
        }

        @Override
        public void invalidate() {
            this._expr = null;
        }
    }
}

