/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Tuple;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigManager;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.PathProperty;
import com.threerings.editor.Property;
import com.threerings.export.Exportable;
import com.threerings.expr.Color4fExpression;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.IntegerExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.StringExpression;
import com.threerings.expr.Transform3DExpression;
import com.threerings.expr.Updater;
import com.threerings.math.Transform3D;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

@EditorTypes(value={FloatBinding.class, IntegerBinding.class, Color4fBinding.class, StringBinding.class, Transform3DBinding.class})
public abstract class ExpressionBinding
extends DeepObject
implements Exportable,
Preloadable.LoadableConfig {
    public static final ExpressionBinding[] EMPTY_ARRAY = new ExpressionBinding[0];
    @Editable(width=40)
    public String[] paths = ArrayUtil.EMPTY_STRING;
    @Editable(width=40)
    public String[] flags = ArrayUtil.EMPTY_STRING;
    @DeepOmit
    protected transient Property[][] _paths;
    @DeepOmit
    protected transient Property[][] _flagPaths;

    public abstract Updater createUpdater(ConfigManager var1, Scope var2, Object var3);

    public void invalidate() {
        this._flagPaths = null;
        this._paths = null;
    }

    @Override
    public void preload(GlContext ctx) {
    }

    protected <T> Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object, ObjectExpression<T> expression, Class<T> clazz) {
        final ObjectExpression.Evaluator<T> evaluator = expression.createEvaluator(scope);
        final Tuple<Property, Object>[] targets = this.getTargets(cfgmgr, object, clazz);
        final Tuple<Property, Object>[] flags = this.getFlags(cfgmgr, object);
        return new Updater(){

            @Override
            public void update() {
                Object value = evaluator.evaluate();
                for (Tuple target : targets) {
                    ((Property)target.left).set(target.right, value);
                }
                for (Tuple flag : flags) {
                    ((Property)flag.left).setBoolean(flag.right, true);
                }
            }
        };
    }

    protected Tuple<Property, Object>[] getTargets(ConfigManager cfgmgr, Object object, Class<?> type) {
        if (this._paths == null) {
            this._paths = this.createPaths(cfgmgr, object, this.paths, type);
        }
        return this.resolvePaths(object, this._paths);
    }

    protected Tuple<Property, Object>[] getFlags(ConfigManager cfgmgr, Object object) {
        if (this._flagPaths == null) {
            this._flagPaths = this.createPaths(cfgmgr, object, this.flags, Boolean.TYPE);
        }
        return this.resolvePaths(object, this._flagPaths);
    }

    protected Property[][] createPaths(ConfigManager cfgmgr, Object reference, String[] paths, Class<?> type) {
        ArrayList<Property[]> list = new ArrayList<Property[]>(paths.length);
        for (String path : paths) {
            Property[] props = PathProperty.createPath(cfgmgr, reference, path);
            if (props == null || !props[props.length - 1].getType().isAssignableFrom(type)) continue;
            list.add(props);
        }
        return (Property[][])list.toArray((T[])new Property[list.size()][]);
    }

    protected Tuple<Property, Object>[] resolvePaths(Object object, Property[][] paths) {
        ArrayList list = Lists.newArrayListWithCapacity((int)paths.length);
        for (Property[] path : paths) {
            Object ref = object;
            int lidx = path.length - 1;
            try {
                for (int ii = 0; ii < lidx; ++ii) {
                    ref = path[ii].get(ref);
                }
                list.add(new Tuple((Object)path[lidx], ref));
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Error resolving path.", new Object[]{"object", object, "path", path, e});
            }
        }
        Tuple[] array = new Tuple[list.size()];
        return list.toArray(array);
    }

    public static class Transform3DBinding
    extends ExpressionBinding {
        @Editable
        public Transform3DExpression expression = new Transform3DExpression.Constant();

        @Override
        public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
            return this.createUpdater(cfgmgr, scope, object, this.expression, Transform3D.class);
        }

        @Override
        public void preload(GlContext ctx) {
            this.expression.createEvaluator(ctx.getScope());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.expression.invalidate();
        }
    }

    public static class StringBinding
    extends ExpressionBinding {
        @Editable
        public StringExpression expression = new StringExpression.Constant();

        @Override
        public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
            return this.createUpdater(cfgmgr, scope, object, this.expression, String.class);
        }

        @Override
        public void preload(GlContext ctx) {
            this.expression.createEvaluator(ctx.getScope());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.expression.invalidate();
        }
    }

    public static class Color4fBinding
    extends ExpressionBinding {
        @Editable
        public Color4fExpression expression = new Color4fExpression.Constant();

        @Override
        public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
            return this.createUpdater(cfgmgr, scope, object, this.expression, Color4f.class);
        }

        @Override
        public void preload(GlContext ctx) {
            this.expression.createEvaluator(ctx.getScope());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.expression.invalidate();
        }
    }

    public static class IntegerBinding
    extends ExpressionBinding {
        @Editable
        public IntegerExpression expression = new IntegerExpression.Constant();

        @Override
        public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
            final IntegerExpression.Evaluator evaluator = this.expression.createEvaluator(scope);
            final Tuple<Property, Object>[] targets = this.getTargets(cfgmgr, object, Integer.TYPE);
            final Tuple<Property, Object>[] flags = this.getFlags(cfgmgr, object);
            return new Updater(){

                @Override
                public void update() {
                    int value = evaluator.evaluate();
                    for (Tuple target : targets) {
                        ((Property)target.left).setInt(target.right, value);
                    }
                    for (Tuple flag : flags) {
                        ((Property)flag.left).setBoolean(flag.right, true);
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            this.expression.createEvaluator(ctx.getScope());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.expression.invalidate();
        }
    }

    public static class FloatBinding
    extends ExpressionBinding {
        @Editable
        public FloatExpression expression = new FloatExpression.Constant();

        @Override
        public Updater createUpdater(ConfigManager cfgmgr, Scope scope, Object object) {
            final FloatExpression.Evaluator evaluator = this.expression.createEvaluator(scope);
            final Tuple<Property, Object>[] targets = this.getTargets(cfgmgr, object, Float.TYPE);
            final Tuple<Property, Object>[] flags = this.getFlags(cfgmgr, object);
            return new Updater(){

                @Override
                public void update() {
                    float value = evaluator.evaluate();
                    for (Tuple target : targets) {
                        ((Property)target.left).setFloat(target.right, value);
                    }
                    for (Tuple flag : flags) {
                        ((Property)flag.left).setBoolean(flag.right, true);
                    }
                }
            };
        }

        @Override
        public void preload(GlContext ctx) {
            this.expression.createEvaluator(ctx.getScope());
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.expression.invalidate();
        }
    }
}

