/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionParser;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.MutableBoolean;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.StringExpression;
import com.threerings.expr.Variable;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.io.Reader;
import java.io.StringReader;

@EditorTypes(value={Parsed.class, Constant.class, Reference.class, Not.class, And.class, Or.class, Xor.class, BooleanEquals.class, FloatLess.class, FloatGreater.class, FloatEquals.class, FloatLessEquals.class, FloatGreaterEquals.class, StringEquals.class})
public abstract class BooleanExpression
extends DeepObject
implements Exportable {
    public abstract Evaluator createEvaluator(Scope var1);

    public void invalidate() {
    }

    protected static BooleanExpression parseExpression(String expression) throws Exception {
        return (BooleanExpression)new ExpressionParser<Object>((Reader)new StringReader(expression)){

            @Override
            protected Object handleNumber(double value) {
                return new FloatExpression.Constant((float)value);
            }

            @Override
            protected Object handleString(String value) {
                return new StringExpression.Constant(value);
            }

            @Override
            protected Object handleOperator(String operator, int arity) throws Exception {
                BinaryOperation result;
                if (arity == 1) {
                    if (operator.equals("!")) {
                        Not not = new Not();
                        not.operand = (BooleanExpression)this._output.pop();
                        return not;
                    }
                    return super.handleOperator(operator, arity);
                }
                if (operator.equals("&") || operator.equals("&&")) {
                    result = new And();
                } else if (operator.equals("|") || operator.equals("||")) {
                    result = new Or();
                } else if (operator.equals("^")) {
                    result = new Xor();
                } else {
                    if (operator.equals("<")) {
                        return this.handleFloatBinaryOperation(new FloatLess());
                    }
                    if (operator.equals(">")) {
                        return this.handleFloatBinaryOperation(new FloatGreater());
                    }
                    if (operator.equals("=") || operator.equals("==")) {
                        return this.handleEquals();
                    }
                    if (operator.equals("!=")) {
                        Not not = new Not();
                        not.operand = this.handleEquals();
                        return not;
                    }
                    if (operator.equals("<=")) {
                        return this.handleFloatBinaryOperation(new FloatLessEquals());
                    }
                    if (operator.equals(">=")) {
                        return this.handleFloatBinaryOperation(new FloatGreaterEquals());
                    }
                    return super.handleOperator(operator, arity);
                }
                result.secondOperand = (BooleanExpression)this._output.pop();
                result.firstOperand = (BooleanExpression)this._output.pop();
                return result;
            }

            @Override
            protected Object handleFunctionCall(String function, int arity) throws Exception {
                if (function.equals("float")) {
                    StringExpression.Constant expr = (StringExpression.Constant)this._output.pop();
                    return FloatExpression.parseExpression(expr.value);
                }
                if (function.equals("string")) {
                    StringExpression.Constant expr = (StringExpression.Constant)this._output.pop();
                    return StringExpression.parseExpression(expr.value);
                }
                return super.handleFunctionCall(function, arity);
            }

            @Override
            protected Object handleIdentifier(String name) {
                if (name.equalsIgnoreCase("true")) {
                    return new Constant(true);
                }
                if (name.equalsIgnoreCase("false")) {
                    return new Constant(false);
                }
                Reference ref = new Reference();
                ref.name = name;
                return ref;
            }

            protected Object handleFloatBinaryOperation(FloatBinaryOperation op) throws Exception {
                op.secondOperand = this.coerceToFloatExpression(this._output.pop());
                op.firstOperand = this.coerceToFloatExpression(this._output.pop());
                return op;
            }

            protected BooleanExpression handleEquals() throws Exception {
                Object secondOperand = this._output.pop();
                Object firstOperand = this._output.pop();
                if (firstOperand instanceof FloatExpression || secondOperand instanceof FloatExpression) {
                    FloatEquals result = new FloatEquals();
                    result.firstOperand = this.coerceToFloatExpression(firstOperand);
                    result.secondOperand = this.coerceToFloatExpression(secondOperand);
                    return result;
                }
                if (firstOperand instanceof StringExpression || secondOperand instanceof StringExpression) {
                    StringEquals result = new StringEquals();
                    result.firstOperand = this.coerceToStringExpression(firstOperand);
                    result.secondOperand = this.coerceToStringExpression(secondOperand);
                    return result;
                }
                BooleanEquals result = new BooleanEquals();
                result.firstOperand = this.coerceToBooleanExpression(firstOperand);
                result.secondOperand = this.coerceToBooleanExpression(secondOperand);
                return result;
            }

            protected BooleanExpression coerceToBooleanExpression(Object object) throws Exception {
                if (object instanceof BooleanExpression) {
                    return (BooleanExpression)object;
                }
                throw new Exception("Cannot coerce to boolean expression " + object);
            }

            protected FloatExpression coerceToFloatExpression(Object object) throws Exception {
                if (object instanceof FloatExpression) {
                    return (FloatExpression)object;
                }
                if (object instanceof Reference) {
                    Reference ref = (Reference)object;
                    FloatExpression.Reference nref = new FloatExpression.Reference();
                    nref.name = ref.name;
                    return nref;
                }
                throw new Exception("Cannot coerce to float expression " + object);
            }

            protected StringExpression coerceToStringExpression(Object object) throws Exception {
                if (object instanceof StringExpression) {
                    return (StringExpression)object;
                }
                if (object instanceof Reference) {
                    Reference ref = (Reference)object;
                    StringExpression.Reference nref = new StringExpression.Reference();
                    nref.name = ref.name;
                    return nref;
                }
                throw new Exception("Cannot coerce to string expression " + object);
            }
        }.parse();
    }

    public static abstract class Evaluator {
        public abstract boolean evaluate();
    }

    public static class StringEquals
    extends BooleanExpression {
        @Editable
        public StringExpression firstOperand = new StringExpression.Constant();
        @Editable
        public StringExpression secondOperand = new StringExpression.Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            final ObjectExpression.Evaluator eval1 = this.firstOperand.createEvaluator(scope);
            final ObjectExpression.Evaluator eval2 = this.secondOperand.createEvaluator(scope);
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return ((String)eval1.evaluate()).equals(eval2.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.firstOperand.invalidate();
            this.secondOperand.invalidate();
        }
    }

    public static class FloatGreaterEquals
    extends FloatBinaryOperation {
        @Override
        protected Evaluator createEvaluator(final FloatExpression.Evaluator eval1, final FloatExpression.Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() >= eval2.evaluate();
                }
            };
        }
    }

    public static class FloatLessEquals
    extends FloatBinaryOperation {
        @Override
        protected Evaluator createEvaluator(final FloatExpression.Evaluator eval1, final FloatExpression.Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() <= eval2.evaluate();
                }
            };
        }
    }

    public static class FloatEquals
    extends FloatBinaryOperation {
        @Override
        protected Evaluator createEvaluator(final FloatExpression.Evaluator eval1, final FloatExpression.Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() == eval2.evaluate();
                }
            };
        }
    }

    public static class FloatGreater
    extends FloatBinaryOperation {
        @Override
        protected Evaluator createEvaluator(final FloatExpression.Evaluator eval1, final FloatExpression.Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() > eval2.evaluate();
                }
            };
        }
    }

    public static class FloatLess
    extends FloatBinaryOperation {
        @Override
        protected Evaluator createEvaluator(final FloatExpression.Evaluator eval1, final FloatExpression.Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() < eval2.evaluate();
                }
            };
        }
    }

    public static abstract class FloatBinaryOperation
    extends BooleanExpression {
        @Editable
        public FloatExpression firstOperand = new FloatExpression.Constant();
        @Editable
        public FloatExpression secondOperand = new FloatExpression.Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return this.createEvaluator(this.firstOperand.createEvaluator(scope), this.secondOperand.createEvaluator(scope));
        }

        @Override
        public void invalidate() {
            this.firstOperand.invalidate();
            this.secondOperand.invalidate();
        }

        protected abstract Evaluator createEvaluator(FloatExpression.Evaluator var1, FloatExpression.Evaluator var2);
    }

    public static class BooleanEquals
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() == eval2.evaluate();
                }
            };
        }
    }

    public static class Xor
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() ^ eval2.evaluate();
                }
            };
        }
    }

    public static class Or
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() || eval2.evaluate();
                }
            };
        }
    }

    public static class And
    extends BinaryOperation {
        @Override
        protected Evaluator createEvaluator(final Evaluator eval1, final Evaluator eval2) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return eval1.evaluate() && eval2.evaluate();
                }
            };
        }
    }

    public static abstract class BinaryOperation
    extends BooleanExpression {
        @Editable
        public BooleanExpression firstOperand = new Constant();
        @Editable
        public BooleanExpression secondOperand = new Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return this.createEvaluator(this.firstOperand.createEvaluator(scope), this.secondOperand.createEvaluator(scope));
        }

        @Override
        public void invalidate() {
            this.firstOperand.invalidate();
            this.secondOperand.invalidate();
        }

        protected abstract Evaluator createEvaluator(Evaluator var1, Evaluator var2);
    }

    public static class Not
    extends BooleanExpression {
        @Editable
        public BooleanExpression operand = new Constant();

        @Override
        public Evaluator createEvaluator(Scope scope) {
            final Evaluator eval = this.operand.createEvaluator(scope);
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return !eval.evaluate();
                }
            };
        }

        @Override
        public void invalidate() {
            this.operand.invalidate();
        }
    }

    public static class Reference
    extends BooleanExpression {
        @Editable(hgroup="n")
        public String name = "";
        @Editable(hgroup="n")
        public boolean defvalue;

        @Override
        public Evaluator createEvaluator(Scope scope) {
            final MutableBoolean reference = ScopeUtil.resolve(scope, this.name, (MutableBoolean)null);
            if (reference != null) {
                return new Evaluator(){

                    @Override
                    public boolean evaluate() {
                        return reference.value;
                    }
                };
            }
            final Variable variable = ScopeUtil.resolve(scope, this.name, Variable.newInstance(this.defvalue));
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return variable.getBoolean();
                }
            };
        }
    }

    public static class Constant
    extends BooleanExpression {
        @Editable
        public boolean value;

        public Constant(boolean value) {
            this.value = value;
        }

        public Constant() {
        }

        @Override
        public Evaluator createEvaluator(Scope scope) {
            return new Evaluator(){

                @Override
                public boolean evaluate() {
                    return value;
                }
            };
        }
    }

    public static class Parsed
    extends BooleanExpression {
        @Editable(width=20)
        public String expression = "false";
        @DeepOmit
        protected transient BooleanExpression _expr;

        @Override
        public Evaluator createEvaluator(Scope scope) {
            if (this._expr == null) {
                try {
                    this._expr = Parsed.parseExpression(this.expression);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this._expr == null) {
                    this._expr = new Constant(false);
                }
            }
            return this._expr.createEvaluator(scope);
        }

        @Override
        public void invalidate() {
            this._expr = null;
        }
    }
}

