/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public class LazyOutputStream
extends OutputStream {
    protected Callable<? extends OutputStream> _creator;
    protected OutputStream _out;

    public LazyOutputStream(Callable<? extends OutputStream> creator) {
        this._creator = (Callable)Preconditions.checkNotNull(creator);
    }

    public LazyOutputStream(final File file) {
        this((Callable<? extends OutputStream>)new Callable<FileOutputStream>(){

            @Override
            public FileOutputStream call() throws IOException {
                return new FileOutputStream(file);
            }
        });
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureInitialized();
        this._out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureInitialized();
        this._out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureInitialized();
        this._out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this._out != null) {
            this._out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._out != null) {
            this._out.close();
        }
    }

    protected void ensureInitialized() throws IOException {
        if (this._out == null) {
            try {
                this._out = this._creator.call();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException("Exception lazy-creating OutputStream: " + e.getMessage(), e);
            }
            finally {
                this._creator = null;
            }
        }
    }
}

