/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.threerings.export.Exportable;
import com.threerings.export.ObjectMarshaller;
import com.threerings.math.Matrix3f;
import com.threerings.math.Matrix4f;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.renderer.Color4f;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public abstract class Importer
implements Closeable {
    protected Object _object;
    protected ObjectMarshaller _marshaller;

    public abstract Object readObject() throws IOException;

    public void defaultReadFields() throws IOException {
        if (this._marshaller == null) {
            throw new IllegalStateException("Not invoking a custom readFields method.");
        }
        this._marshaller.readFields(this._object, this, false);
    }

    public abstract boolean read(String var1, boolean var2) throws IOException;

    public abstract byte read(String var1, byte var2) throws IOException;

    public abstract char read(String var1, char var2) throws IOException;

    public abstract double read(String var1, double var2) throws IOException;

    public abstract float read(String var1, float var2) throws IOException;

    public abstract int read(String var1, int var2) throws IOException;

    public abstract long read(String var1, long var2) throws IOException;

    public abstract short read(String var1, short var2) throws IOException;

    public boolean[] read(String name, boolean[] defvalue) throws IOException {
        return this.read(name, defvalue, boolean[].class);
    }

    public byte[] read(String name, byte[] defvalue) throws IOException {
        return this.read(name, defvalue, byte[].class);
    }

    public char[] read(String name, char[] defvalue) throws IOException {
        return this.read(name, defvalue, char[].class);
    }

    public double[] read(String name, double[] defvalue) throws IOException {
        return this.read(name, defvalue, double[].class);
    }

    public float[] read(String name, float[] defvalue) throws IOException {
        return this.read(name, defvalue, float[].class);
    }

    public int[] read(String name, int[] defvalue) throws IOException {
        return this.read(name, defvalue, int[].class);
    }

    public long[] read(String name, long[] defvalue) throws IOException {
        return this.read(name, defvalue, long[].class);
    }

    public short[] read(String name, short[] defvalue) throws IOException {
        return this.read(name, defvalue, short[].class);
    }

    public String read(String name, String defvalue) throws IOException {
        return this.read(name, defvalue, String.class);
    }

    public ByteBuffer read(String name, ByteBuffer defvalue) throws IOException {
        return this.read(name, defvalue, ByteBuffer.class);
    }

    public CharBuffer read(String name, CharBuffer defvalue) throws IOException {
        return this.read(name, defvalue, CharBuffer.class);
    }

    public DoubleBuffer read(String name, DoubleBuffer defvalue) throws IOException {
        return this.read(name, defvalue, DoubleBuffer.class);
    }

    public FloatBuffer read(String name, FloatBuffer defvalue) throws IOException {
        return this.read(name, defvalue, FloatBuffer.class);
    }

    public IntBuffer read(String name, IntBuffer defvalue) throws IOException {
        return this.read(name, defvalue, IntBuffer.class);
    }

    public LongBuffer read(String name, LongBuffer defvalue) throws IOException {
        return this.read(name, defvalue, LongBuffer.class);
    }

    public ShortBuffer read(String name, ShortBuffer defvalue) throws IOException {
        return this.read(name, defvalue, ShortBuffer.class);
    }

    public Color4f read(String name, Color4f defvalue) throws IOException {
        return this.read(name, defvalue, Color4f.class);
    }

    public Matrix3f read(String name, Matrix3f defvalue) throws IOException {
        return this.read(name, defvalue, Matrix3f.class);
    }

    public Matrix4f read(String name, Matrix4f defvalue) throws IOException {
        return this.read(name, defvalue, Matrix4f.class);
    }

    public Quaternion read(String name, Quaternion defvalue) throws IOException {
        return this.read(name, defvalue, Quaternion.class);
    }

    public Vector2f read(String name, Vector2f defvalue) throws IOException {
        return this.read(name, defvalue, Vector2f.class);
    }

    public Vector3f read(String name, Vector3f defvalue) throws IOException {
        return this.read(name, defvalue, Vector3f.class);
    }

    public Exportable read(String name, Exportable defvalue) throws IOException {
        return this.read(name, defvalue, Exportable.class);
    }

    public abstract <T> T read(String var1, T var2, Class<T> var3) throws IOException;

    @Override
    public abstract void close() throws IOException;

    protected Object read(String name, Object defvalue, Field field) throws IOException {
        Class<?> clazz = field.getType();
        return this.read(name, defvalue, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFields(Exportable object) throws IOException {
        Object oobject = this._object;
        ObjectMarshaller omarshaller = this._marshaller;
        try {
            this._object = object;
            this._marshaller = ObjectMarshaller.getObjectMarshaller(object.getClass());
            this._marshaller.readFields(this._object, this, true);
        }
        finally {
            this._object = oobject;
            this._marshaller = omarshaller;
        }
    }
}

