/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.collect.ImmutableMap;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;

public abstract class FieldMarshaller {
    protected static final Map<Class<?>, FieldMarshaller> MARSHALLERS = ImmutableMap.builder().put(Boolean.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setBoolean(target, importer.read(name, field.getBoolean(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getBoolean(source), field.getBoolean(prototype));
        }
    }).put(Byte.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setByte(target, importer.read(name, field.getByte(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getByte(source), field.getByte(prototype));
        }
    }).put(Character.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setChar(target, importer.read(name, field.getChar(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getChar(source), field.getChar(prototype));
        }
    }).put(Double.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setDouble(target, importer.read(name, field.getDouble(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getDouble(source), field.getDouble(prototype));
        }
    }).put(Float.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setFloat(target, importer.read(name, field.getFloat(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getFloat(source), field.getFloat(prototype));
        }
    }).put(Integer.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setInt(target, importer.read(name, field.getInt(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getInt(source), field.getInt(prototype));
        }
    }).put(Long.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setLong(target, importer.read(name, field.getLong(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getLong(source), field.getLong(prototype));
        }
    }).put(Short.TYPE, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            field.setShort(target, importer.read(name, field.getShort(prototype)));
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            exporter.write(name, field.getShort(source), field.getShort(prototype));
        }
    }).put(Object.class, (Object)new FieldMarshaller(){

        @Override
        public void readField(Field field, String name, Object target, Object prototype, Importer importer) throws IOException, IllegalAccessException {
            Object defvalue = field.get(prototype);
            Object value = importer.read(name, defvalue, field);
            if (value != defvalue) {
                field.set(target, value);
            }
        }

        @Override
        public void writeField(Field field, String name, Object source, Object prototype, Exporter exporter) throws IOException, IllegalAccessException {
            Class<?> clazz = field.getType();
            exporter.write(name, field.get(source), field.get(prototype), clazz);
        }
    }).build();

    public static FieldMarshaller getFieldMarshaller(Field field) {
        FieldMarshaller marshaller = MARSHALLERS.get(field.getType());
        if (marshaller != null) {
            return marshaller;
        }
        return MARSHALLERS.get(Object.class);
    }

    public abstract void readField(Field var1, String var2, Object var3, Object var4, Importer var5) throws IOException, IllegalAccessException;

    public abstract void writeField(Field var1, String var2, Object var3, Object var4, Exporter var5) throws IOException, IllegalAccessException;
}

