/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors.util;

import com.google.common.base.Splitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractRecentList
extends JPanel {
    protected JList _list;
    protected DefaultListModel _listModel = new DefaultListModel();
    protected String _prefKey;
    protected Preferences _prefs;
    protected boolean _block;
    protected static final int MAX_SIZE = 50;

    public AbstractRecentList(String prefKey, Preferences prefs) {
        super(new BorderLayout());
        this._prefKey = prefKey;
        this._prefs = prefs;
        this.readPrefs();
        this._list = new JList(this._listModel);
        this._list.setVisibleRowCount(4);
        JScrollPane pane = new JScrollPane(this._list, 21, 31);
        this.add((Component)pane, "Center");
        this._list.setSelectionMode(0);
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (AbstractRecentList.this._block) {
                    return;
                }
                Object selected = AbstractRecentList.this._list.getSelectedValue();
                if (selected != null) {
                    AbstractRecentList.this.valueSelected((String)selected);
                }
            }
        });
        this._list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String fullString = String.valueOf(value);
                super.getListCellRendererComponent((JList<?>)list, fullString, index, isSelected, cellHasFocus);
                int maxWidth = list.getSize().width;
                int maxChop = AbstractRecentList.this.getMaximumChop(fullString);
                for (int chop = 1; chop <= maxChop && this.getPreferredSize().width > maxWidth; ++chop) {
                    this.setText("..." + fullString.substring(chop));
                }
                return this;
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.height = Math.max(d.height, this._list.getPreferredScrollableViewportSize().height);
        return d;
    }

    protected abstract void valueSelected(String var1);

    protected int getMaximumChop(String value) {
        return Math.max(0, value.length() - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRecent(String value) {
        int size = this._listModel.getSize();
        int curIdx = -1;
        for (int ii = 0; ii < size; ++ii) {
            if (!value.equals(this._listModel.getElementAt(ii))) continue;
            curIdx = ii;
            break;
        }
        if (curIdx == 0) {
            return;
        }
        this._block = true;
        try {
            if (curIdx > 0) {
                this._listModel.removeElementAt(curIdx);
            } else if (size == 50) {
                this._listModel.removeElementAt(size - 1);
            }
            this._listModel.insertElementAt(value, 0);
            this._list.setSelectedIndex(0);
        }
        finally {
            this._block = false;
        }
        this.writePrefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPrefs() {
        if (this._prefKey == null) {
            return;
        }
        this._block = true;
        try {
            String encoded = this._prefs.get(this._prefKey, "");
            this._listModel.removeAllElements();
            for (String piece : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)encoded)) {
                this._listModel.addElement(piece.replace("%BAR%", "|"));
            }
        }
        finally {
            this._block = false;
        }
    }

    protected void writePrefs() {
        if (this._prefKey == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int nn = this._listModel.getSize();
        for (int ii = 0; ii < nn; ++ii) {
            String value = (String)this._listModel.getElementAt(ii);
            value = value.replace("|", "%BAR%");
            if (builder.length() + value.length() + 1 > 8192) break;
            builder.append(value).append('|');
        }
        this._prefs.put(this._prefKey, builder.toString());
    }
}

