/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LongEditor
extends PropertyEditor
implements ChangeListener {
    protected DraggableSpinner _spinner;
    protected JLabel _value;

    @Override
    public void stateChanged(ChangeEvent event) {
        Long nvalue = (Long)this._spinner.getValue();
        if (!this._property.get(this._object).equals(nvalue)) {
            this._property.set(this._object, nvalue);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        Long value = (Long)this._property.get(this._object);
        if (this._property.getAnnotation().constant()) {
            this._value.setText(String.valueOf(value));
            return;
        }
        this._spinner.setValue(value);
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        long min = this.getLongMinimum();
        long max = this.getLongMaximum();
        if (this._property.getAnnotation().constant()) {
            this._value = new JLabel(" ");
            this.add(this._value);
        } else {
            this._spinner = new DraggableSpinner((Number)min, (Comparable<? extends Number>)min, (Comparable<? extends Number>)max, (Number)((long)this.getStep()));
            this.add(this._spinner);
            int width = this._property.getWidth(-1);
            if (width != -1) {
                ((JSpinner.NumberEditor)this._spinner.getEditor()).getTextField().setColumns(width);
                this._spinner.setPreferredSize(null);
            }
            this._spinner.addChangeListener(this);
        }
        this.addUnits((JPanel)((Object)this));
    }

    protected long getLongMinimum() {
        return Math.max((long)this.getMinimum(), Long.MIN_VALUE);
    }

    protected long getLongMaximum() {
        return Math.min((long)this.getMaximum(), Long.MAX_VALUE);
    }
}

