/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.samskivert.util.Calendars;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.util.MessageBundle;
import com.threerings.util.MoreObjects;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DateTimeEditor
extends PropertyEditor
implements DocumentListener,
FocusListener {
    protected JTextField _field;
    protected String _nullStr = "";
    protected DateFormat _format;

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._field) {
            this.canonicalize();
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        boolean newInvalid;
        String text = this._field.getText().trim();
        try {
            Comparable<Date> newVal;
            Object oldVal = this._property.get(this._object);
            if (("".equals(text) || this._nullStr.equals(text)) && this._property.nullable()) {
                newVal = null;
            } else {
                Date d = this._format.parse(text);
                if (oldVal instanceof Date) {
                    newVal = d;
                } else {
                    long time = d.getTime();
                    if (time == 0L) {
                        time = 1L;
                    }
                    newVal = time;
                }
            }
            if (!Objects.equal(newVal, (Object)oldVal)) {
                this._property.set(this._object, newVal);
                this.fireStateChanged();
            }
            newInvalid = false;
        }
        catch (Exception e) {
            newInvalid = true;
        }
        if (newInvalid != this._invalid) {
            this._invalid = newInvalid;
            this.updateBorder();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.canonicalize();
    }

    public void canonicalize() {
        if (!this._invalid) {
            this.update();
        }
    }

    @Override
    public void update() {
        this._field.getDocument().removeDocumentListener(this);
        Object prop = this._property.get(this._object);
        boolean rewrite = false;
        if (prop instanceof Long && 0L == (Long)prop) {
            rewrite = true;
            prop = Calendars.now().addHours(1).set(14, 0).set(13, 0).set(12, 0).toTime();
        }
        this._field.setText(prop == null ? this._nullStr : this._format.format(prop));
        this._field.getDocument().addDocumentListener(this);
        if (rewrite) {
            this.changedUpdate(null);
        }
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        this._field = new JTextField(this._property.getWidth(12));
        this.add(this._field);
        this._field.getDocument().addDocumentListener(this);
        this._field.addFocusListener(this);
        this._field.addActionListener(this);
        this.configureMode();
        this.addUnits((JPanel)((Object)this));
        this._field.setEnabled(!this._property.getAnnotation().constant());
    }

    @Override
    protected String getUnits() {
        String units = super.getUnits();
        return "".equals(units) ? MessageBundle.taint((Object)this._format.getTimeZone().getID()) : units;
    }

    protected void configureMode() {
        String localeSpec;
        HashMap modeArgs = Maps.newHashMap((Map)Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator("=").split((CharSequence)this.getMode()));
        String modeSpec = (String)modeArgs.remove("mode");
        Mode mode = this.getDefaultMode();
        if (modeSpec != null) {
            for (Mode m : Mode.values()) {
                if (!modeSpec.equalsIgnoreCase(m.name())) continue;
                mode = m;
                break;
            }
        }
        int style = 3;
        TimeZone timezone = TimeZone.getDefault();
        Locale locale = Locale.getDefault();
        String format = this.getDefaultFormat(mode);
        String styleSpec = (String)modeArgs.remove("style");
        if (styleSpec != null) {
            format = null;
            if ("short".equalsIgnoreCase(styleSpec)) {
                style = 3;
            } else if ("medium".equalsIgnoreCase(styleSpec)) {
                style = 2;
            } else if ("long".equalsIgnoreCase(styleSpec)) {
                style = 1;
            } else if ("full".equalsIgnoreCase(styleSpec)) {
                style = 0;
            } else {
                Log.log.warning((Object)("Unknown style mode: " + styleSpec), new Object[0]);
            }
        }
        format = MoreObjects.firstNonNull((String)modeArgs.remove("format"), format);
        String tzSpec = (String)modeArgs.remove("timezone");
        if (tzSpec != null) {
            timezone = TimeZone.getTimeZone(tzSpec);
        }
        if ((localeSpec = (String)modeArgs.remove("locale")) != null) {
            String[] specs = (String[])Iterables.toArray((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).omitEmptyStrings().split((CharSequence)localeSpec), String.class);
            switch (specs.length) {
                case 1: {
                    locale = new Locale(specs[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(specs[0], specs[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(specs[0], specs[1], specs[2]);
                    break;
                }
                default: {
                    Log.log.warning((Object)("Too many arguments to locale: " + localeSpec), new Object[0]);
                }
            }
        }
        String nullKeySpec = MoreObjects.firstNonNull((String)modeArgs.remove("nullKey"), "m.null_value");
        MessageBundle msgs = this._msgmgr.getBundle(this._property.getMessageBundle());
        if (msgs.exists(nullKeySpec)) {
            this._nullStr = msgs.get(nullKeySpec);
        }
        if (!modeArgs.isEmpty()) {
            Log.log.warning((Object)("Unknown mode arguments: " + modeArgs), new Object[0]);
        }
        this._format = format != null ? new SimpleDateFormat(format, locale) : this.createFormat(mode, style, locale);
        this._format.setTimeZone(timezone);
        this._format.setLenient(false);
    }

    protected Mode getDefaultMode() {
        return Mode.DATETIME;
    }

    protected DateFormat createFormat(Mode mode, int style, Locale locale) {
        switch (mode) {
            default: {
                return DateFormat.getDateTimeInstance(style, style, locale);
            }
            case DATE: {
                return DateFormat.getDateInstance(style, locale);
            }
            case TIME: 
        }
        return DateFormat.getTimeInstance(style, locale);
    }

    protected String getDefaultFormat(Mode mode) {
        switch (mode) {
            default: {
                return "yyyy-MM-dd HH:mm";
            }
            case DATE: {
                return "yyyy-MM-dd";
            }
            case TIME: 
        }
        return "HH:mm:ss";
    }

    protected static enum Mode {
        DATETIME,
        DATE,
        TIME;

    }

    public static class TimeOnlyEditor
    extends DateTimeEditor {
        @Override
        protected Mode getDefaultMode() {
            return Mode.TIME;
        }
    }

    public static class DateOnlyEditor
    extends DateTimeEditor {
        @Override
        protected Mode getDefaultMode() {
            return Mode.DATE;
        }
    }
}

