/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.editor.Log;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.swing.editors.PathTableArrayListEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParameterHighlighter {
    protected BaseEditorPanel _editor;
    protected Map<BasePropertyEditor, String> _editorToPath = Maps.newIdentityHashMap();
    protected Map<String, BasePropertyEditor> _pathToEditor = Maps.newHashMap();
    protected Map<PathTableArrayListEditor, ParameterWatcher> _params = Maps.newIdentityHashMap();
    protected ContainerListener _containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            SwingUtil.applyToHierarchy((Component)e.getChild(), (SwingUtil.ComponentOp)new SwingUtil.ComponentOp(){

                public void apply(Component comp) {
                    ParameterHighlighter.this.registerDescendant(comp);
                }
            });
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            SwingUtil.applyToHierarchy((Component)e.getChild(), (SwingUtil.ComponentOp)new SwingUtil.ComponentOp(){

                public void apply(Component comp) {
                    ParameterHighlighter.this.unregisterDescendant(comp);
                }
            });
        }
    };

    public ParameterHighlighter(BaseEditorPanel editor) {
        this._editor = editor;
        editor.addContainerListener(this._containerListener);
    }

    protected void registerDescendant(Component c) {
        if (c instanceof Container) {
            ((Container)c).addContainerListener(this._containerListener);
        }
        if (c instanceof BasePropertyEditor) {
            BasePropertyEditor pe = (BasePropertyEditor)((Object)c);
            String path = this._editor.getComponentPath((Component)((Object)pe), false);
            if (path.startsWith(".")) {
                path = path.substring(1);
            }
            if (this._pathToEditor.containsKey(path)) {
                return;
            }
            this._pathToEditor.put(path, pe);
            this._editorToPath.put(pe, path);
            if (pe instanceof PathTableArrayListEditor) {
                PathTableArrayListEditor paths = (PathTableArrayListEditor)pe;
                this._params.put(paths, new ParameterWatcher(paths));
            }
        }
    }

    protected void unregisterDescendant(Component c) {
        if (c instanceof Container) {
            ((Container)c).removeContainerListener(this._containerListener);
        }
        if (c instanceof BasePropertyEditor) {
            BasePropertyEditor pe = (BasePropertyEditor)((Object)c);
            String path = this._editorToPath.remove(pe);
            if (path != null) {
                this._pathToEditor.remove(path);
            }
            if (pe instanceof PathTableArrayListEditor) {
                ParameterWatcher watcher = this._params.remove(pe);
                if (watcher == null) {
                    Log.log.warning((Object)("What?: " + pe), new Object[0]);
                } else {
                    watcher.shutdown();
                }
            }
        }
    }

    protected class ParameterWatcher
    implements ChangeListener {
        protected final PathTableArrayListEditor _pathsEditor;
        protected final PropertyEditor _nameEditor;
        protected Set<BasePropertyEditor> _lastTargets = ImmutableSet.of();

        public ParameterWatcher(PathTableArrayListEditor paths) {
            PropertyEditor name = null;
            for (Object p = paths; p != null; p = ((Component)p).getParent()) {
                if (!(p instanceof EditorPanel)) continue;
                name = ((EditorPanel)p).getPropertyEditor("name");
                break;
            }
            this._pathsEditor = paths;
            this._nameEditor = name;
            this._pathsEditor.addChangeListener(this);
            this._nameEditor.addChangeListener(this);
            this.update();
        }

        public void shutdown() {
            this._pathsEditor.removeChangeListener(this);
            this._nameEditor.removeChangeListener(this);
            this.update((Map<BasePropertyEditor, String>)ImmutableMap.of());
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.update();
        }

        protected void update() {
            IdentityHashMap targets = Maps.newIdentityHashMap();
            int rowCount = this._pathsEditor.getRowCount();
            int colCount = this._pathsEditor.getColumnCount();
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < colCount; ++col) {
                    String path = (String)this._pathsEditor.getValueAt(row, col);
                    BasePropertyEditor pe = ParameterHighlighter.this._pathToEditor.get(path);
                    String pathInfo = "";
                    while (pe == null && path.endsWith("]")) {
                        int lastBracket = path.lastIndexOf("[");
                        pathInfo = path.substring(lastBracket) + pathInfo;
                        path = path.substring(0, lastBracket);
                        pe = ParameterHighlighter.this._pathToEditor.get(path);
                    }
                    if (pe == null) continue;
                    targets.put(pe, pathInfo);
                }
            }
            this.update(targets);
        }

        protected void update(Map<BasePropertyEditor, String> newTargets) {
            for (BasePropertyEditor pe : Sets.difference(this._lastTargets, newTargets.keySet())) {
                pe.setParameterLabel(null, "");
            }
            String label = String.valueOf(this._nameEditor.getProperty().get(this._nameEditor.getObject()));
            for (Map.Entry<BasePropertyEditor, String> entry : newTargets.entrySet()) {
                entry.getKey().setParameterLabel(label, entry.getValue());
            }
            this._lastTargets = newTargets.keySet();
        }
    }
}

