/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.ObjectUtil;
import com.threerings.editor.Groupable;
import com.threerings.editor.Log;
import com.threerings.editor.PreparedEditable;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.TreeEditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.util.DeepUtil;
import com.threerings.util.ReflectionUtil;
import com.threerings.util.Validatable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjectPanel
extends BasePropertyEditor
implements ActionListener,
ChangeListener {
    protected EditorContext _ctx;
    protected JComboBox _box;
    protected BaseEditorPanel _panel;
    protected Object _outer;
    protected Class<?>[] _types;
    protected Object[] _values;
    protected Object _lvalue;
    protected Action _group;
    protected Action _ungroup;
    protected Action _regroup;

    public ObjectPanel(EditorContext ctx, String tlabel, Class<?>[] types, Property[] ancestors, Object outer) {
        this(ctx, tlabel, types, ancestors, outer, false);
    }

    public ObjectPanel(EditorContext ctx, String tlabel, Class<?>[] types, Property[] ancestors, Object outer, boolean omitColumns) {
        this._ctx = ctx;
        this._msgmgr = ctx.getMessageManager();
        this._msgs = this._msgmgr.getBundle("editor.default");
        this._outer = outer;
        this._types = types;
        this.setBackground(this.getBackgroundColor(ancestors));
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        if (this._types.length > 1) {
            JPanel tpanel = new JPanel();
            tpanel.setBackground(null);
            this.add(tpanel);
            tpanel.add(new JLabel(this.getLabel(tlabel) + ":"));
            String[] labels = new String[this._types.length];
            for (int ii = 0; ii < this._types.length; ++ii) {
                labels[ii] = this.getLabel(this._types[ii]);
            }
            this._box = new JComboBox<String>(labels);
            tpanel.add(this._box);
            this._box.addActionListener(this);
            this._values = new Object[this._types.length];
            this.maybeConfigureGrouping(tpanel);
        }
        this._panel = new EditorPanel(this._ctx, EditorPanel.CategoryMode.PANELS, ancestors, omitColumns);
        this.add((Component)((Object)this._panel));
        this._panel.addChangeListener(this);
    }

    public void setOuter(Object outer) {
        this._outer = outer;
    }

    public void setValue(Object value) {
        int tidx = this.getTypeIndex(value);
        if (tidx == -1) {
            Log.log.warning((Object)"Wrong type for object panel.", new Object[]{"value", value, "types", this._types});
            return;
        }
        if (this._box != null) {
            Arrays.fill(this._values, null);
            this._values[tidx] = value;
            this._box.removeActionListener(this);
            this._box.setSelectedIndex(tidx);
            this._box.addActionListener(this);
        }
        this._lvalue = value;
        if (this._panel.getObject() == this._lvalue) {
            this._panel.update();
        } else {
            this._panel.setObject(value);
        }
        this.checkValid(value);
    }

    public Object getValue() {
        return this._panel.getObject();
    }

    @Override
    public void setTreeModeEnabled(boolean enabled) {
        BaseEditorPanel opanel = this._panel;
        this.remove((Component)((Object)opanel));
        this._panel = enabled ? new TreeEditorPanel(this._ctx, opanel.getAncestors(), opanel.getOmitColumns()) : new EditorPanel(this._ctx, EditorPanel.CategoryMode.PANELS, opanel.getAncestors(), opanel.getOmitColumns());
        this.add((Component)((Object)this._panel));
        this._panel.addChangeListener(this);
        this._panel.setObject(opanel.getObject());
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int idx = this._box.getSelectedIndex();
        Object value = null;
        Class<?> type = this._types[idx];
        if (type != null) {
            value = this._values[idx];
            if (value == null) {
                try {
                    this._values[idx] = value = this.newInstance(type);
                }
                catch (Exception e) {
                    Log.log.warning((Object)("Failed to create instance [type=" + type + "]."), new Object[]{e});
                }
            }
            if (this._lvalue != null && value != null) {
                DeepUtil.transfer(this._lvalue, value);
            }
        }
        this._panel.setObject(value);
        if (value != null) {
            this._lvalue = value;
        }
        this.fireStateChanged();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        return this._panel.getComponentPath(comp, mouse);
    }

    protected void maybeConfigureGrouping(JPanel tpanel) {
        for (Class<?> clazz : this._types) {
            if (clazz == null || !Groupable.class.isAssignableFrom(clazz)) continue;
            this.configureGrouping(tpanel);
            break;
        }
    }

    protected void configureGrouping(JPanel tpanel) {
        this._group = new AbstractAction(null, this.loadIcon("group", this._ctx)){

            @Override
            public void actionPerformed(ActionEvent event) {
                ObjectPanel.this.groupGroupable(event);
            }
        };
        this._group.putValue("ShortDescription", "Group");
        this._ungroup = new AbstractAction(null, this.loadIcon("ungroup", this._ctx)){

            @Override
            public void actionPerformed(ActionEvent event) {
                ObjectPanel.this.ungroupGroupable();
            }
        };
        this._ungroup.putValue("ShortDescription", "Ungroup");
        this._ungroup.setEnabled(false);
        this._regroup = new AbstractAction(null, this.loadIcon("regroup", this._ctx)){

            @Override
            public void actionPerformed(ActionEvent event) {
                ObjectPanel.this.regroupGroupable(event);
            }
        };
        this._regroup.putValue("ShortDescription", "Regroup");
        this._regroup.setEnabled(false);
        JButton jb = new JButton(this._group);
        tpanel.add(jb);
        jb.setPreferredSize(PANEL_BUTTON_SIZE);
        jb = new JButton(this._ungroup);
        tpanel.add(jb);
        jb.setPreferredSize(PANEL_BUTTON_SIZE);
        jb = new JButton(this._regroup);
        tpanel.add(jb);
        jb.setPreferredSize(PANEL_BUTTON_SIZE);
    }

    @Override
    protected void fireStateChanged() {
        this.checkValid(this.getValue());
        super.fireStateChanged();
    }

    protected int getTypeIndex(Object value) {
        Class<?> type = value == null ? null : value.getClass();
        for (int ii = 0; ii < this._types.length; ++ii) {
            if (this._types[ii] != type) continue;
            return ii;
        }
        return -1;
    }

    protected void checkValid(Object value) {
        boolean invalid;
        boolean bl = invalid = value instanceof Validatable && !((Validatable)value).isValid();
        if (invalid != this._invalid) {
            this._invalid = invalid;
            this.updateBorder();
        }
        if (this._ungroup != null) {
            List eValues;
            boolean ungroup = false;
            boolean regroup = false;
            if (value instanceof Groupable && (eValues = ((Groupable)value).getGrouped()) != null && eValues.size() > 0) {
                boolean allValid = true;
                for (Object eValue : eValues) {
                    if (this.getTypeIndex(eValue) != -1) continue;
                    allValid = false;
                    break;
                }
                regroup = allValid;
                ungroup = allValid && eValues.size() == 1;
            }
            this._ungroup.setEnabled(ungroup);
            this._regroup.setEnabled(regroup);
        }
    }

    protected Object newInstance(Class<?> type) throws Exception {
        if (this._lvalue != null) {
            boolean inner = ReflectionUtil.isInner(type);
            Constructor<?> cctor = null;
            Class<?> cptype = null;
            for (Constructor<?> ctor : type.getConstructors()) {
                Class<?>[] ptypes = ctor.getParameterTypes();
                if (!inner ? ptypes.length != 1 : ptypes.length != 2 || !ptypes[0].isInstance(this._outer)) continue;
                Class<?> ptype = ptypes[ptypes.length - 1];
                if (!ptype.isInstance(this._lvalue) || cctor != null && !cptype.isAssignableFrom(ptype)) continue;
                cctor = ctor;
                cptype = ptype;
            }
            if (cctor != null) {
                return PreparedEditable.PREPARER.apply(inner ? cctor.newInstance(this._outer, this._lvalue) : cctor.newInstance(this._lvalue));
            }
        }
        return PreparedEditable.PREPARER.apply(ReflectionUtil.newInstance(type, this._outer));
    }

    protected void groupGroupable(ActionEvent event) {
        this.tryGrouping(Collections.singletonList(this.getValue()), event);
    }

    protected void ungroupGroupable() {
        List eValues = ((Groupable)this.getValue()).getGrouped();
        this.setValue(eValues.get(0));
        this.fireStateChanged();
    }

    protected void regroupGroupable(ActionEvent event) {
        this.tryGrouping(((Groupable)this.getValue()).getGrouped(), event);
    }

    protected boolean tryGrouping(List<?> values, ActionEvent event) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        List<?> gvalues = values;
        HashMap instances = Maps.newHashMap();
        ArrayList names = Lists.newArrayList();
        for (Class<?> type : this._types) {
            Object instance;
            if (type == null || !Groupable.class.isAssignableFrom(type)) continue;
            try {
                instance = this.newInstance(type);
                Groupable groupable = (Groupable)instance;
                groupable.setGrouped(gvalues);
            }
            catch (UnsupportedOperationException uoe) {
                continue;
            }
            catch (Exception ue) {
                Log.log.warning((Object)"Unexpected exception trying to group into Groupable", new Object[]{ue});
                continue;
            }
            String name = this.getLabel(type);
            while (instances.containsKey(name)) {
                name = name + "-2";
            }
            instances.put(name, instance);
            names.add(name);
        }
        if (names.isEmpty()) {
            Log.log.warning((Object)"Unable to group.", new Object[0]);
            return false;
        }
        Component parentComp = (Component)MoreObjects.firstNonNull((Object)((Component)ObjectUtil.as((Object)event.getSource(), Component.class)), (Object)this);
        Object choice = JOptionPane.showInputDialog(parentComp, "Choose group container type", "Group", -1, this.loadIcon("regroup", this._ctx), names.toArray(), names.get(0));
        if (choice == null) {
            return true;
        }
        this.setValue(instances.get(choice));
        this.fireStateChanged();
        return true;
    }
}

