/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.delta;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import com.samskivert.io.ByteArrayOutInputStream;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Tuple;
import com.threerings.delta.BareArrayMask;
import com.threerings.delta.ClassMappingProvider;
import com.threerings.delta.Delta;
import com.threerings.delta.DeltaFinal;
import com.threerings.delta.ProtobufField;
import com.threerings.expr.MutableInteger;
import com.threerings.io.ArrayMask;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.protobuf.io.ProtobufInputStream;
import com.threerings.protobuf.io.ProtobufOutputStream;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import com.threerings.tudey.util.ObjectMap;
import com.threerings.tudey.util.Pool;
import com.threerings.util.DeepObject;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReflectiveDelta
extends Delta
implements Pool.Poolable {
    protected transient ClassMapping _cmap;
    protected Class<?> _clazz;
    protected transient IntMap<Object> _protobufFields = new HashIntMap();
    protected transient IntMap<Tuple<Field, FieldHandler>> _protobufHandlers = null;
    protected static Map<Class<?>, IntMap<Tuple<Field, FieldHandler>>> CLASS_HANDLER_MAP = Maps.newHashMap();
    protected BareArrayMask _mask;
    protected Object[] _values;
    protected static ObjectMap<Class<?>, ClassMapping> _classes = new ObjectMap();
    protected static final Map<Class<?>, FieldHandler> PRIMITIVE_FIELD_HANDLERS = ImmutableMap.builder().put(Boolean.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            boolean nvalue = field.getBoolean(revised);
            if (field.getBoolean(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                boolean nvalue = field.getBoolean(revised);
                if (field.getBoolean(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeBoolean(((Boolean)values[vidx.value++]).booleanValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readBoolean());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            boolean value = mask.isSet(midx.value++) ? ((Boolean)values[vidx.value++]).booleanValue() : field.getBoolean(original);
            field.setBoolean(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            boolean value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Boolean)map.get(protoField.fieldNumber())).booleanValue() : field.getBoolean(original);
            field.setBoolean(revised, value);
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeBool(index, ((Boolean)value).booleanValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)intput.readBool());
        }
    }).put(Byte.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            byte nvalue = field.getByte(revised);
            if (field.getByte(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                byte nvalue = field.getByte(revised);
                if (field.getByte(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeByte((int)((Byte)values[vidx.value++]).byteValue());
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeFixed32(index, ((Integer)value).intValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)((byte)intput.readFixed32()));
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readByte());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            byte value = mask.isSet(midx.value++) ? ((Byte)values[vidx.value++]).byteValue() : field.getByte(original);
            field.setByte(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            byte value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Byte)map.get(protoField.fieldNumber())).byteValue() : field.getByte(original);
            field.setByte(revised, value);
        }
    }).put(Character.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            char nvalue = field.getChar(revised);
            if (field.getChar(original) != nvalue) {
                mask.set(idx);
                values.add(Character.valueOf(nvalue));
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                char nvalue = field.getChar(revised);
                if (field.getChar(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)Character.valueOf(nvalue));
                }
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeChar((int)((Character)values[vidx.value++]).charValue());
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeFixed32(index, (int)((Character)value).charValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)Character.valueOf((char)intput.readFixed32()));
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(Character.valueOf(in.readChar()));
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            char value = mask.isSet(midx.value++) ? ((Character)values[vidx.value++]).charValue() : field.getChar(original);
            field.setChar(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            char value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Character)map.get(protoField.fieldNumber())).charValue() : field.getChar(original);
            field.setChar(revised, value);
        }
    }).put(Double.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            double nvalue = field.getDouble(revised);
            if (field.getDouble(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                double nvalue = field.getDouble(revised);
                if (field.getDouble(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeDouble(((Double)values[vidx.value++]).doubleValue());
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeDouble(index, ((Double)value).doubleValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)intput.readDouble());
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readDouble());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            double value = mask.isSet(midx.value++) ? ((Double)values[vidx.value++]).doubleValue() : field.getDouble(original);
            field.setDouble(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            double value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Double)map.get(protoField.fieldNumber())).doubleValue() : field.getDouble(original);
            field.setDouble(revised, value);
        }
    }).put(Float.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            float nvalue = field.getFloat(revised);
            if (field.getFloat(original) != nvalue) {
                mask.set(idx);
                values.add(Float.valueOf(nvalue));
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                float nvalue = field.getFloat(revised);
                if (field.getFloat(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)Float.valueOf(nvalue));
                }
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeFloat(index, ((Float)value).floatValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)Float.valueOf(intput.readFloat()));
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeFloat(((Float)values[vidx.value++]).floatValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(Float.valueOf(in.readFloat()));
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            float value = mask.isSet(midx.value++) ? ((Float)values[vidx.value++]).floatValue() : field.getFloat(original);
            field.setFloat(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            float value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Float)map.get(protoField.fieldNumber())).floatValue() : field.getFloat(original);
            field.setFloat(revised, value);
        }
    }).put(Integer.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            int nvalue = field.getInt(revised);
            if (field.getInt(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                int nvalue = field.getInt(revised);
                if (field.getInt(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeInt32(index, ((Integer)value).intValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)intput.readInt32());
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeInt(((Integer)values[vidx.value++]).intValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readInt());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            int value = mask.isSet(midx.value++) ? ((Integer)values[vidx.value++]).intValue() : field.getInt(original);
            field.setInt(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            int value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Integer)map.get(protoField.fieldNumber())).intValue() : field.getInt(original);
            field.setInt(revised, value);
        }
    }).put(Long.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            long nvalue = field.getLong(revised);
            if (field.getLong(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                long nvalue = field.getLong(revised);
                if (field.getLong(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeInt64(index, ((Long)value).longValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)intput.readInt64());
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeLong(((Long)values[vidx.value++]).longValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readLong());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            long value = mask.isSet(midx.value++) ? ((Long)values[vidx.value++]).longValue() : field.getLong(original);
            field.setLong(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            long value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Long)map.get(protoField.fieldNumber())).longValue() : field.getLong(original);
            field.setLong(revised, value);
        }
    }).put(Short.TYPE, (Object)new FieldHandler(){

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            short nvalue = field.getShort(revised);
            if (field.getShort(original) != nvalue) {
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                short nvalue = field.getShort(revised);
                if (field.getShort(original) != nvalue) {
                    values.put(protoField.fieldNumber(), (Object)nvalue);
                }
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            output.writeInt32(index, (int)((Short)value).shortValue());
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            map.put(index, (Object)intput.readInt32());
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeShort((int)((Short)values[vidx.value++]).shortValue());
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readShort());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            short value = mask.isSet(midx.value++) ? ((Short)values[vidx.value++]).shortValue() : field.getShort(original);
            field.setShort(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            short value = protoField != null && map.containsKey(protoField.fieldNumber()) ? ((Short)map.get(protoField.fieldNumber())).shortValue() : field.getShort(original);
            field.setShort(revised, value);
        }
    }).build();
    protected static final Map<Class<?>, FieldHandler> FINAL_PRIMITIVE_FIELD_HANDLERS = ImmutableMap.builder().put(Boolean.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setBoolean(revised, field.getBoolean(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setBoolean(revised, field.getBoolean(original));
        }
    }).put(Byte.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setByte(revised, field.getByte(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setByte(revised, field.getByte(original));
        }
    }).put(Character.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setChar(revised, field.getChar(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setChar(revised, field.getChar(original));
        }
    }).put(Double.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setDouble(revised, field.getDouble(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setDouble(revised, field.getDouble(original));
        }
    }).put(Float.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setFloat(revised, field.getFloat(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setFloat(revised, field.getFloat(original));
        }
    }).put(Integer.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setInt(revised, field.getInt(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setInt(revised, field.getInt(original));
        }
    }).put(Long.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setLong(revised, field.getLong(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setLong(revised, field.getLong(original));
        }
    }).put(Short.TYPE, (Object)new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.setShort(revised, field.getShort(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.setShort(revised, field.getShort(original));
        }
    }).build();
    protected static final FieldHandler OBJECT_FIELD_HANDLER = new FieldHandler(){
        protected Object[] _oarray = new Object[1];
        protected Object[] _narray = new Object[1];

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
            int idx = midx.value++;
            Object ovalue = this._oarray[0] = field.get(original);
            Object nvalue = this._narray[0] = field.get(revised);
            if (!Arrays.deepEquals(this._oarray, this._narray)) {
                if (Delta.checkDeltable(ovalue, nvalue)) {
                    nvalue = Delta.createDelta(ovalue, nvalue);
                }
                mask.set(idx);
                values.add(nvalue);
            }
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null) {
                Object ovalue = this._oarray[0] = field.get(original);
                Object nvalue = this._narray[0] = field.get(revised);
                if (!Arrays.deepEquals(this._oarray, this._narray)) {
                    if (Delta.checkDeltable(ovalue, nvalue)) {
                        nvalue = Delta.createDelta(ovalue, nvalue);
                    }
                    values.put(protoField.fieldNumber(), nvalue);
                }
            }
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
            if (value instanceof ProtobufProvider) {
                Message messsage = ((ProtobufProvider)value).transform();
                output.writeMessage(index, (MessageLite)messsage);
            }
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
            try {
                Message.Builder builder = ProtobufRegistry.getBuilder(field.getType());
                intput.readMessage((MessageLite.Builder)builder, ExtensionRegistryLite.getEmptyRegistry());
                Message message = builder.build();
                Object value = ProtobufRegistry.transform((Message)message);
                map.put(index, value);
            }
            catch (Exception e) {
                throw new IOException("cannot instance builder for field=" + field.toString(), e);
            }
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
            if (mask.isSet(midx.value++)) {
                out.writeObject(values[vidx.value++]);
            }
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
            if (mask.isSet(midx.value++)) {
                values.add(in.readObject());
            }
        }

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            Object value;
            if (mask.isSet(midx.value++)) {
                if ((value = values[vidx.value++]) instanceof Delta) {
                    value = ((Delta)value).apply(field.get(original));
                }
            } else {
                value = field.get(original);
            }
            field.set(revised, value);
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            Object value;
            ProtobufField protoField = field.getAnnotation(ProtobufField.class);
            if (protoField != null && map.containsKey(protoField.fieldNumber())) {
                value = map.get(protoField.fieldNumber());
                if (value instanceof Delta) {
                    value = ((Delta)value).apply(field.get(original));
                }
            } else {
                value = field.get(original);
            }
            field.set(revised, value);
        }
    };
    protected static final FieldHandler FINAL_OBJECT_FIELD_HANDLER = new FinalFieldHandler(){

        @Override
        public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
            field.set(revised, field.get(original));
        }

        @Override
        public void applyProtobuf(Field field, Object original, Object revised, IntMap<Object> map) throws IllegalAccessException {
            field.set(revised, field.get(original));
        }
    };

    public ReflectiveDelta(Object original, Object revised) {
        this.initProtobuf(original, revised);
    }

    public void init(Object original, Object revised) {
        this._clazz = original.getClass();
        this._cmap = null;
        if (original instanceof ClassMappingProvider) {
            this._cmap = ((ClassMappingProvider)original).getClassMapping();
            if (this._cmap == null) {
                this._cmap = this.getInnerClassMapping(this._clazz);
            }
        } else {
            this._cmap = this.getInnerClassMapping(this._clazz);
        }
        this._mask = new BareArrayMask(this._cmap.getMaskLength());
        Field[] fields = this._cmap.getFields();
        FieldHandler[] handlers = this._cmap.getHandlers();
        ArrayList values = Lists.newArrayList();
        MutableInteger midx = new MutableInteger();
        for (int ii = 0; ii < fields.length; ++ii) {
            try {
                handlers[ii].populate(fields[ii], original, revised, this._mask, midx, values);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta computation", e);
            }
        }
        this._values = values.toArray();
    }

    public void init(Class clazz) {
        this._clazz = clazz;
        this._cmap = ReflectiveDelta.getClassMapping(clazz);
        Field[] fields = this._cmap.getFields();
        FieldHandler[] handlers = this._cmap.getHandlers();
        HashIntMap map = CLASS_HANDLER_MAP.get(this._clazz);
        if (map == null) {
            map = new HashIntMap();
            CLASS_HANDLER_MAP.put(this._clazz, (IntMap<Tuple<Field, FieldHandler>>)map);
            for (int ii = 0; ii < fields.length; ++ii) {
                ProtobufField pfield = fields[ii].getAnnotation(ProtobufField.class);
                if (pfield == null) continue;
                Tuple tuple = new Tuple((Object)fields[ii], (Object)handlers[ii]);
                map.put(pfield.fieldNumber(), (Object)tuple);
            }
        }
        this._protobufHandlers = map;
    }

    public void initProtobuf(Object original, Object revised) {
        int ii;
        this._clazz = original.getClass();
        this._cmap = null;
        if (original instanceof ClassMappingProvider) {
            this._cmap = ((ClassMappingProvider)original).getClassMapping();
            if (this._cmap == null) {
                this._cmap = this.getInnerClassMapping(this._clazz);
            }
        } else {
            this._cmap = this.getInnerClassMapping(this._clazz);
        }
        Field[] fields = this._cmap.getFields();
        FieldHandler[] handlers = this._cmap.getHandlers();
        HashIntMap map = CLASS_HANDLER_MAP.get(this._clazz);
        if (map == null) {
            map = new HashIntMap();
            CLASS_HANDLER_MAP.put(this._clazz, (IntMap<Tuple<Field, FieldHandler>>)map);
            for (ii = 0; ii < fields.length; ++ii) {
                ProtobufField pfield = fields[ii].getAnnotation(ProtobufField.class);
                if (pfield == null) continue;
                Tuple tuple = new Tuple((Object)fields[ii], (Object)handlers[ii]);
                map.put(pfield.fieldNumber(), (Object)tuple);
            }
        }
        this._protobufHandlers = map;
        for (ii = 0; ii < fields.length; ++ii) {
            try {
                handlers[ii].populateProtobuf(fields[ii], original, revised, this._protobufFields);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta computation", e);
            }
        }
    }

    public ReflectiveDelta() {
    }

    public boolean isEmpty() {
        return this._protobufFields == null || this._protobufFields.size() == 0;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        if (out instanceof ProtobufOutputStream) {
            ByteArrayOutInputStream bos = new ByteArrayOutInputStream();
            CodedOutputStream cout = CodedOutputStream.newInstance((OutputStream)bos);
            for (Map.Entry entry : this._protobufFields.entrySet()) {
                Tuple tuple = (Tuple)this._protobufHandlers.get(entry.getKey());
                ((FieldHandler)tuple.right).write(cout, (Integer)entry.getKey(), entry.getValue());
            }
            cout.flush();
            byte[] bts = bos.toByteArray();
            out.writeInt(bts.length);
            out.writeInt(this._protobufFields.size());
            out.write(bts, 0, bts.length);
        } else {
            _classStreamer.writeObject(this._clazz, out, true);
            this._mask.writeTo(out);
            MutableInteger midx = new MutableInteger();
            MutableInteger vidx = new MutableInteger();
            for (FieldHandler handler : this.getInnerClassMapping(this._clazz).getHandlers()) {
                handler.write(this._mask, midx, this._values, vidx, out);
            }
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in instanceof ProtobufInputStream) {
            int length = in.readInt();
            int size = in.readInt();
            byte[] bts = new byte[length];
            if (length > 0) {
                in.read(bts);
                CodedInputStream cint = CodedInputStream.newInstance((byte[])bts);
                for (int i = 0; i < size; ++i) {
                    int number = WireFormat.getTagFieldNumber((int)cint.readTag());
                    Tuple tuple = (Tuple)this._protobufHandlers.get(number);
                    if (tuple == null) continue;
                    ((FieldHandler)tuple.right).read(cint, (Field)tuple.left, number, this._protobufFields);
                }
            }
        } else {
            this._clazz = (Class)_classStreamer.createObject(in);
            ClassMapping cmap = this.getInnerClassMapping(this._clazz);
            this._mask = new BareArrayMask(cmap.getMaskLength());
            this._mask.readFrom(in);
            ArrayList values = Lists.newArrayList();
            MutableInteger midx = new MutableInteger();
            for (FieldHandler handler : cmap.getHandlers()) {
                handler.read(this._mask, midx, values, in);
            }
            this._values = values.toArray();
        }
    }

    @Override
    public Object apply(Object original) {
        Object revised;
        if (original.getClass() != this._clazz) {
            throw new IllegalArgumentException("Delta class mismatch: original is " + original.getClass() + ", expected " + this._clazz);
        }
        try {
            revised = this._clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + this._clazz + " for delta application", e);
        }
        ClassMapping cmap = this.getInnerClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        for (int ii = 0; ii < fields.length; ++ii) {
            try {
                handlers[ii].apply(fields[ii], original, revised, this._mask, midx, this._values, vidx);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta application", e);
            }
        }
        return revised;
    }

    public Object applyWithProtobuf(DeepObject original) {
        if (original.getClass() != this._clazz) {
            throw new IllegalArgumentException("Delta class mismatch: original is " + original.getClass() + ", expected " + this._clazz);
        }
        for (Map.Entry entry : this._protobufHandlers.entrySet()) {
            Tuple tuple = (Tuple)entry.getValue();
            try {
                ((FieldHandler)tuple.right).applyProtobuf((Field)tuple.left, original, original, this._protobufFields);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + tuple.left + " for delta application", e);
            }
        }
        return original;
    }

    @Override
    public Delta merge(Delta other) {
        if (!(other instanceof ReflectiveDelta)) {
            throw new IllegalArgumentException("Cannot merge delta " + other);
        }
        ReflectiveDelta merged = new ReflectiveDelta();
        this.populateMerged((ReflectiveDelta)other, merged);
        return merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[class=").append(this._clazz.getName());
        ClassMapping cmap = this.getInnerClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        if (this._mask != null) {
            FieldHandler[] handlers = cmap.getHandlers();
            MutableInteger midx = new MutableInteger();
            MutableInteger vidx = new MutableInteger();
            for (int ii = 0; ii < fields.length; ++ii) {
                handlers[ii].toString(fields[ii], this._mask, midx, this._values, vidx, buf);
            }
        } else if (this._protobufFields != null && this._protobufFields.size() > 0) {
            buf.append("{");
            for (Map.Entry entry : this._protobufFields.entrySet()) {
                buf.append(entry.getKey()).append("=").append(StringUtil.toString(entry.getValue())).append(";");
            }
            buf.append("}");
        }
        return buf.append("]").toString();
    }

    @Override
    public void reset() {
        this._clazz = null;
        this._cmap = null;
        this._mask = null;
        this._values = null;
    }

    protected void populateMerged(ReflectiveDelta other, ReflectiveDelta merged) {
        if (this._clazz != other._clazz) {
            throw new IllegalArgumentException("Merge class mismatch: other is " + other._clazz + ", expected " + this._clazz);
        }
        merged._clazz = this._clazz;
        int mlength = this.getInnerClassMapping(this._clazz).getMaskLength();
        merged._mask = new BareArrayMask(mlength);
        ArrayList values = Lists.newArrayList();
        int oidx = 0;
        int nidx = 0;
        for (int ii = 0; ii < mlength; ++ii) {
            Object value;
            if (this._mask.isSet(ii)) {
                Object ovalue = this._values[oidx++];
                if (other._mask.isSet(ii)) {
                    Object nvalue;
                    if ((nvalue = other._values[nidx++]) instanceof Delta) {
                        Delta ndelta = (Delta)nvalue;
                        value = ovalue instanceof Delta ? ((Delta)ovalue).merge(ndelta) : ndelta.apply(ovalue);
                    } else {
                        value = nvalue;
                    }
                } else {
                    value = ovalue;
                }
            } else {
                if (!other._mask.isSet(ii)) continue;
                value = other._values[nidx++];
            }
            merged._mask.set(ii);
            values.add(value);
        }
        merged._values = values.toArray();
    }

    protected void populateMergedProtobuf(ReflectiveDelta other, ReflectiveDelta merged) {
        if (this._clazz != other._clazz) {
            throw new IllegalArgumentException("Merge class mismatch: other is " + other._clazz + ", expected " + this._clazz);
        }
        for (Map.Entry entry : this._protobufFields.entrySet()) {
            Object nvalue = entry.getValue();
            if (nvalue instanceof Delta) {
                Object ovalue = merged._protobufFields.get(entry.getKey());
                if (ovalue == null) {
                    merged._protobufFields.put((Object)((Integer)entry.getKey()), nvalue);
                    continue;
                }
                Delta ndelta = (Delta)nvalue;
                Object value = ovalue instanceof Delta ? ((Delta)ovalue).merge(ndelta) : ndelta.apply(ovalue);
                merged._protobufFields.put((Object)((Integer)entry.getKey()), value);
                continue;
            }
            merged._protobufFields.put((Object)((Integer)entry.getKey()), nvalue);
        }
    }

    protected ClassMapping getInnerClassMapping(Class<?> clazz) {
        if (this._cmap == null) {
            this._cmap = ReflectiveDelta.getClassMapping(clazz);
            return this._cmap;
        }
        return this._cmap;
    }

    public static ClassMapping getClassMapping(Class<?> clazz) {
        ClassMapping _cmap = _classes.get(clazz);
        if (_cmap == null) {
            _cmap = new ClassMapping(clazz);
            _classes.put(clazz, _cmap);
        }
        return _cmap;
    }

    protected static void collectFields(Class<?> clazz, List<Field> fields) {
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != Object.class) {
            ReflectiveDelta.collectFields(sclazz, fields);
        }
        for (Field field : clazz.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isTransient(mods) || field.isSynthetic()) continue;
            field.setAccessible(true);
            fields.add(field);
        }
    }

    protected static abstract class FinalFieldHandler
    extends FieldHandler {
        protected FinalFieldHandler() {
        }

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) {
        }

        @Override
        public void populateProtobuf(Field field, Object original, Object revised, IntMap<Object> values) throws IllegalAccessException {
        }

        @Override
        public void write(CodedOutputStream output, int index, Object value) throws IOException {
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) {
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) {
        }

        @Override
        public void read(CodedInputStream intput, Field field, int index, IntMap<Object> map) throws IOException {
        }

        @Override
        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
        }
    }

    protected static abstract class FieldHandler {
        protected FieldHandler() {
        }

        public abstract void populate(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, List<Object> var6) throws IllegalAccessException;

        public abstract void populateProtobuf(Field var1, Object var2, Object var3, IntMap<Object> var4) throws IllegalAccessException;

        public abstract void write(ArrayMask var1, MutableInteger var2, Object[] var3, MutableInteger var4, ObjectOutputStream var5) throws IOException;

        public abstract void write(CodedOutputStream var1, int var2, Object var3) throws IOException;

        public abstract void read(CodedInputStream var1, Field var2, int var3, IntMap<Object> var4) throws IOException;

        public abstract void read(ArrayMask var1, MutableInteger var2, List<Object> var3, ObjectInputStream var4) throws IOException, ClassNotFoundException;

        public abstract void apply(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, Object[] var6, MutableInteger var7) throws IllegalAccessException;

        public abstract void applyProtobuf(Field var1, Object var2, Object var3, IntMap<Object> var4) throws IllegalAccessException;

        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
            if (mask.isSet(midx.value++)) {
                buf.append(", " + field.getName() + "=" + values[vidx.value++]);
            }
        }
    }

    public static class ClassMapping {
        protected Field[] _fields;
        protected FieldHandler[] _handlers;
        protected int _maskLength;
        protected int _maxFieldNumber;

        public ClassMapping(Class<?> clazz) {
            ArrayList fields = Lists.newArrayList();
            ReflectiveDelta.collectFields(clazz, fields);
            this._fields = fields.toArray(new Field[fields.size()]);
            this._handlers = new FieldHandler[this._fields.length];
            for (int ii = 0; ii < this._fields.length; ++ii) {
                Field field = this._fields[ii];
                Class<?> type = field.getType();
                if (Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(DeltaFinal.class)) {
                    this._handlers[ii] = type.isPrimitive() ? FINAL_PRIMITIVE_FIELD_HANDLERS.get(type) : FINAL_OBJECT_FIELD_HANDLER;
                    continue;
                }
                ProtobufField protoField = field.getAnnotation(ProtobufField.class);
                if (protoField != null) {
                    this._maxFieldNumber = Math.max(this._maxFieldNumber, protoField.fieldNumber());
                }
                ++this._maskLength;
                this._handlers[ii] = type.isPrimitive() ? PRIMITIVE_FIELD_HANDLERS.get(type) : OBJECT_FIELD_HANDLER;
            }
        }

        public Field[] getFields() {
            return this._fields;
        }

        public FieldHandler[] getHandlers() {
            return this._handlers;
        }

        public int getMaskLength() {
            return this._maskLength;
        }
    }
}

