/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.delta;

import com.google.common.collect.Maps;
import com.threerings.delta.ArrayDelta;
import com.threerings.delta.Deltable;
import com.threerings.delta.ReflectiveDelta;
import com.threerings.io.Streamable;
import com.threerings.io.Streamer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class Delta
implements Streamable {
    protected static HashMap<Class<?>, Method> _creators = new HashMap();
    protected static Method _none;
    protected static Streamer _classStreamer;
    protected static HashMap<Class<?>, Streamer> _wrapperStreamers;

    public static boolean checkDeltable(Object original, Object revised) {
        Class<?> oclazz = original == null ? null : original.getClass();
        Class<?> rclazz = revised == null ? null : revised.getClass();
        return oclazz == rclazz && (original instanceof Deltable || oclazz.isArray());
    }

    public static Delta createDelta(Object original, Object revised) {
        if (original instanceof Deltable) {
            Class<?> clazz = original.getClass();
            Method creator = _creators.get(clazz);
            if (creator == null) {
                try {
                    creator = clazz.getMethod("createDelta", Object.class);
                }
                catch (NoSuchMethodException e) {
                    creator = _none;
                }
                _creators.put(clazz, creator);
            }
            if (creator == _none) {
                return new ReflectiveDelta(original, revised);
            }
            try {
                return (Delta)creator.invoke(original, revised);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking custom delta method " + creator, e);
            }
        }
        Class<?> clazz = original.getClass();
        if (clazz.isArray()) {
            return new ArrayDelta(original, revised);
        }
        throw new RuntimeException("Cannot create delta for " + clazz);
    }

    public abstract Object apply(Object var1);

    public abstract Delta merge(Delta var1);

    static {
        try {
            _none = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        _wrapperStreamers = Maps.newHashMap();
        try {
            _classStreamer = Streamer.getStreamer(Class.class);
            _wrapperStreamers.put(Boolean.TYPE, Streamer.getStreamer(Boolean.class));
            _wrapperStreamers.put(Byte.TYPE, Streamer.getStreamer(Byte.class));
            _wrapperStreamers.put(Character.TYPE, Streamer.getStreamer(Character.class));
            _wrapperStreamers.put(Double.TYPE, Streamer.getStreamer(Double.class));
            _wrapperStreamers.put(Float.TYPE, Streamer.getStreamer(Float.class));
            _wrapperStreamers.put(Integer.TYPE, Streamer.getStreamer(Integer.class));
            _wrapperStreamers.put(Long.TYPE, Streamer.getStreamer(Long.class));
            _wrapperStreamers.put(Short.TYPE, Streamer.getStreamer(Short.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize ReflectiveDelta class", e);
        }
    }
}

