/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class FieldCache {
    protected final Predicate<? super Field> _pred;
    protected final LoadingCache<Class<?>, ImmutableList<Field>> _fields = CacheBuilder.newBuilder().concurrencyLevel(1).build(new CacheLoader<Class<?>, ImmutableList<Field>>(){

        public ImmutableList<Field> load(Class<?> clazz) {
            ImmutableList.Builder builder = ImmutableList.builder();
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz != null) {
                builder.addAll((Iterable)FieldCache.this._fields.getUnchecked(superClazz));
            }
            ArrayList ourFields = Lists.newArrayList();
            for (Field f : clazz.getDeclaredFields()) {
                if (!FieldCache.this._pred.apply((Object)f)) continue;
                f.setAccessible(true);
                ourFields.add(f);
            }
            builder.addAll((Iterable)Ordering.natural().onResultOf((Function)new Function<Field, String>(){

                public String apply(Field field) {
                    return field.getName();
                }
            }).immutableSortedCopy((Iterable)ourFields));
            return builder.build();
        }
    });

    public static Predicate<Field> getDefaultPredicate() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return 0 == (field.getModifiers() & 0x88);
            }
        };
    }

    public FieldCache() {
        this(FieldCache.getDefaultPredicate());
    }

    public FieldCache(Predicate<? super Field> pred) {
        this._pred = pred;
    }

    public ImmutableList<Field> getFields(Class<?> clazz) {
        return (ImmutableList)this._fields.getUnchecked(clazz);
    }
}

