/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.config.util.FieldCache;
import com.threerings.editor.util.EditorContext;
import com.threerings.export.util.ExportFileUtil;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.util.ResourceUtil;
import com.threerings.util.ToolUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ConfigSearcher
extends JFrame {
    protected EditorContext _ctx;
    protected JPanel _content;
    protected JLabel _status;
    protected long _nextStatusUpdate;
    protected ToolUtil.EditablePrefs _eprefs = new ToolUtil.EditablePrefs(Preferences.userNodeForPackage(ConfigSearcher.class));
    protected static final FieldCache _fieldCache = new FieldCache();

    public static boolean find(Object val, Detector detector) {
        return !ConfigSearcher.findAttributes(val, new AttributeDetectorAdapter(detector)).isEmpty();
    }

    public static int count(Object val, Detector detector) {
        return ConfigSearcher.findAttributes(val, new AttributeDetectorAdapter(detector)).size();
    }

    public static <T> Multiset<T> findAttributes(Object val, AttributeDetector<T> detector) {
        return ConfigSearcher.findAttributes(val, null, detector);
    }

    public static <T> Multiset<T> findAttributes(Object val, Type valType, AttributeDetector<T> detector) {
        return ConfigSearcher.findAttributes(val, valType, detector, Sets.newIdentityHashSet());
    }

    public <T> ConfigSearcher(EditorContext ctx, String title, final SearchReporter<T> detector, final Iterable<Domain> domains) {
        this._ctx = ctx;
        this._content = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.LEFT, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._status = new JLabel(".");
        this.add((Component)new JScrollPane(this._content), "Center");
        this.add((Component)this._status, "North");
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.setSize(850, 600);
        SwingUtil.centerWindow((Window)this);
        this._eprefs.bindWindowBounds("ConfigSearcher." + ResourceUtil.getPrefsPrefix(), this);
        this.setVisible(true);
        EventQueue.invokeLater(new Runnable(){
            protected Iterator<Result> _resultIterator = ImmutableSet.of().iterator();
            protected Iterator<Domain> _domainIterator = domains.iterator();

            @Override
            public void run() {
                if (!ConfigSearcher.this.isShowing()) {
                    return;
                }
                while (!this._resultIterator.hasNext()) {
                    if (!this._domainIterator.hasNext()) {
                        ConfigSearcher.this.addLabel("DONE.");
                        ConfigSearcher.this._status.setText("");
                        return;
                    }
                    Domain domain = this._domainIterator.next();
                    ConfigSearcher.this.addLabel(domain.getLabel());
                    this._resultIterator = domain.getResults(detector);
                }
                Result result = this._resultIterator.next();
                if (result != null) {
                    ConfigSearcher.this.addResult(result);
                }
                ConfigSearcher.this.updateStatusLabel();
                EventQueue.invokeLater(this);
            }
        });
    }

    protected void addLabel(String label) {
        this._content.add(new JLabel(label));
        SwingUtil.refresh((JComponent)this._content);
    }

    protected void addResult(final Result result) {
        JLabel label = new JLabel("  " + result.getLabel());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                result.onClick();
            }
        });
        this._content.add(label);
        SwingUtil.refresh((JComponent)this._content);
    }

    protected void updateStatusLabel() {
        long now = System.currentTimeMillis();
        if (now >= this._nextStatusUpdate) {
            this._status.setText(StringUtil.fill((char)'.', (int)(1 + this._status.getText().length() % 4)));
            this._nextStatusUpdate = now + 800L;
        }
    }

    protected static <T> Multiset<T> findAttributes(Object val, Type valGenericType, AttributeDetector<T> detector, Set<Object> seen) {
        if (val == null) {
            return ImmutableMultiset.of();
        }
        Class<?> c = val.getClass();
        if (c == String.class || c.isPrimitive() || Primitives.isWrapperType(c) || !seen.add(val)) {
            return ImmutableMultiset.of();
        }
        Multiset<T> attrs = null;
        if (val instanceof ConfigReference) {
            ConfigReference ref = (ConfigReference)val;
            Class<?> refType = ConfigSearcher.asClass(ConfigSearcher.getFirstGenericType(valGenericType));
            attrs = ConfigSearcher.addAll(attrs, detector.apply(ref, refType));
            for (Object value : ref.getArguments().values()) {
                attrs = ConfigSearcher.addAll(attrs, ConfigSearcher.findAttributes(value, null, detector, seen));
            }
        } else if (c.isArray()) {
            Class<?> subType = c.getComponentType();
            int nn = Array.getLength(val);
            for (int ii = 0; ii < nn; ++ii) {
                attrs = ConfigSearcher.addAll(attrs, ConfigSearcher.findAttributes(Array.get(val, ii), subType, detector, seen));
            }
        } else if (val instanceof Collection) {
            Type subType = ConfigSearcher.getFirstGenericType(valGenericType);
            for (Object o : (Collection)val) {
                attrs = ConfigSearcher.addAll(attrs, ConfigSearcher.findAttributes(o, subType, detector, seen));
            }
        } else {
            for (Field f : _fieldCache.getFields(c)) {
                Object o;
                try {
                    o = f.get(val);
                }
                catch (IllegalAccessException iae) {
                    continue;
                }
                attrs = ConfigSearcher.addAll(attrs, ConfigSearcher.findAttributes(o, f.getGenericType(), detector, seen));
            }
        }
        return attrs != null ? attrs : ImmutableMultiset.of();
    }

    protected static <T> Multiset<T> addAll(Multiset<T> accum, Multiset<T> toAdd) {
        if (!toAdd.isEmpty()) {
            if (accum == null) {
                accum = HashMultiset.create();
            }
            accum.addAll(toAdd);
        }
        return accum;
    }

    protected static Class<?> asClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    protected static Type getFirstGenericType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            return args.length > 0 ? args[0] : null;
        }
        return null;
    }

    protected static class AttributeDetectorAdapter
    implements AttributeDetector<Boolean> {
        protected final Detector _det;
        protected static final Multiset<Boolean> NO = ImmutableMultiset.of();
        protected static final Multiset<Boolean> YES = ImmutableMultiset.of((Object)true);

        public AttributeDetectorAdapter(Detector det) {
            this._det = det;
        }

        @Override
        public Multiset<Boolean> apply(ConfigReference<?> ref, Class<?> typeIfKnown) {
            return this._det.apply(ref, typeIfKnown) ? YES : NO;
        }
    }

    public static abstract class TudeySceneDomain
    extends FileDomain {
        public TudeySceneDomain(EditorContext ctx, String label, File dir, String ... subdirs) {
            super(ctx, label, dir, subdirs);
        }

        @Override
        protected <T> Multiset<T> attrsForFile(File file, SearchReporter<T> detector) {
            TudeySceneModel model;
            try {
                model = ExportFileUtil.readObject(file, TudeySceneModel.class);
            }
            catch (Exception e) {
                return ImmutableMultiset.of();
            }
            model.init(this._ctx.getConfigManager());
            Multiset<T> attrs = null;
            for (TudeySceneModel.Entry entry : model.getEntries()) {
                attrs = ConfigSearcher.addAll(attrs, ConfigSearcher.findAttributes(entry.getReference(), entry.getReferenceType(), detector));
            }
            return attrs == null ? ImmutableMultiset.of() : attrs;
        }
    }

    public static abstract class FileDomain
    implements Domain {
        protected EditorContext _ctx;
        protected String _label;
        protected File _dir;
        protected List<File> _dirs;
        protected static final FileFilter DIR_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && !".svn".equals(f.getName());
            }
        };
        protected static final FileFilter DAT_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".dat");
            }
        };

        public FileDomain(EditorContext ctx, String label, File dir, String ... subdirs) {
            this._ctx = ctx;
            this._label = label;
            this._dir = this.validateDir(dir);
            if (subdirs.length == 0) {
                this._dirs = ImmutableList.of((Object)dir);
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String s : subdirs) {
                    builder.add((Object)this.validateDir(new File(dir, s)));
                }
                this._dirs = builder.build();
            }
        }

        protected File validateDir(File dir) {
            Preconditions.checkArgument((boolean)dir.isDirectory(), (String)"Invalid directory: %s", (Object[])new Object[]{dir});
            return dir;
        }

        @Override
        public String getLabel() {
            return this._label;
        }

        @Override
        public <T> Iterator<Result> getResults(final SearchReporter<T> detector) {
            Iterable allFiles = Iterables.concat((Iterable)Iterables.transform(this._dirs, (Function)new Function<File, Iterable<File>>(){

                public Iterable<File> apply(File dir) {
                    return this.findFiles(dir);
                }
            }));
            return Iterables.transform((Iterable)allFiles, (Function)new Function<File, Result>(){

                public Result apply(File f) {
                    return this.resultForFile(f, detector);
                }
            }).iterator();
        }

        protected Iterable<File> findFiles(File directory) {
            return this.findFiles(directory, DAT_FILTER);
        }

        protected Iterable<File> findFiles(File directory, final FileFilter filter) {
            return Iterables.concat(Arrays.asList(directory.listFiles(filter)), (Iterable)Iterables.concat((Iterable)Iterables.transform(Arrays.asList(directory.listFiles(DIR_FILTER)), (Function)new Function<File, Iterable<File>>(){

                public Iterable<File> apply(File dir) {
                    return this.findFiles(dir, filter);
                }
            })));
        }

        protected <T> Result resultForFile(File file, SearchReporter<T> detector) {
            Multiset<T> attrs = this.attrsForFile(file, detector);
            return attrs.isEmpty() ? null : new FileResult(this._dir, file, detector, attrs);
        }

        protected abstract <T> Multiset<T> attrsForFile(File var1, SearchReporter<T> var2);

        protected abstract void openFile(File var1);

        protected class FileResult
        extends Result {
            protected File _file;

            public <T> FileResult(File topDir, File file, SearchReporter<T> det, Multiset<T> result) {
                super(det.formatLabel(file.getAbsolutePath().substring(topDir.getAbsolutePath().length()), result));
                this._file = file;
            }

            @Override
            public void onClick() {
                FileDomain.this.openFile(this._file);
            }
        }
    }

    public static class ConfigDomain
    implements Domain {
        protected EditorContext _ctx;

        public ConfigDomain(EditorContext ctx) {
            this._ctx = ctx;
        }

        @Override
        public String getLabel() {
            return "CONFIGS";
        }

        @Override
        public <T> Iterator<Result> getResults(final SearchReporter<T> detector) {
            return new AbstractIterator<Result>(){
                protected Iterator<? extends ManagedConfig> _cfgIterator = ImmutableSet.of().iterator();
                protected Iterator<ConfigGroup<?>> _groupIterator;
                protected ConfigGroup<?> _currentGroup;
                {
                    this._groupIterator = _ctx.getConfigManager().getGroups().iterator();
                }

                protected Result computeNext() {
                    while (!this._cfgIterator.hasNext()) {
                        if (!this._groupIterator.hasNext()) {
                            return (Result)this.endOfData();
                        }
                        this._currentGroup = this._groupIterator.next();
                        this._cfgIterator = this._currentGroup.getRawConfigs().iterator();
                    }
                    final ManagedConfig cfg = this._cfgIterator.next();
                    final ConfigGroup<?> group = this._currentGroup;
                    Multiset attrs = ConfigSearcher.findAttributes(cfg, detector);
                    return attrs.isEmpty() ? null : new Result(detector.formatLabel(group.getName() + ": " + cfg.getName(), attrs)){

                        @Override
                        public void onClick() {
                            BaseConfigEditor.createEditor(_ctx, group.getConfigClass(), cfg.getName()).setVisible(true);
                        }
                    };
                }
            };
        }
    }

    public static interface Domain {
        public String getLabel();

        public <T> Iterator<Result> getResults(SearchReporter<T> var1);
    }

    public static abstract class Result {
        protected String _label;

        public String getLabel() {
            return this._label;
        }

        public abstract void onClick();

        public Result(String label) {
            this._label = label;
        }
    }

    public static enum Presence {
        MATCH,
        POSSIBLE_MATCH;

        protected static final ImmutableMultiset<Presence> RESULT_NONE;
        protected static final ImmutableMultiset<Presence> RESULT_MATCH;
        protected static final ImmutableMultiset<Presence> RESULT_POSSIBLE_MATCH;

        public static SearchReporter<Presence> getReporter(final Class<?> clazz, final Predicate<? super ConfigReference<?>> pred) {
            return new SearchReporter<Presence>(){

                @Override
                public Multiset<Presence> apply(ConfigReference<?> ref, @Nullable Class<?> type) {
                    boolean fuzzy;
                    boolean bl = fuzzy = type == null;
                    return (fuzzy || type.equals(clazz)) && pred.apply(ref) ? (fuzzy ? RESULT_POSSIBLE_MATCH : RESULT_MATCH) : RESULT_NONE;
                }

                @Override
                public String formatLabel(String label, Multiset<Presence> attrs) {
                    int possible = attrs.count((Object)POSSIBLE_MATCH);
                    return attrs.count((Object)MATCH) + ": " + (possible == 0 ? "" : "(" + possible + " maybe): ") + label;
                }
            };
        }

        static {
            RESULT_NONE = ImmutableMultiset.of();
            RESULT_MATCH = ImmutableMultiset.of((Object)((Object)MATCH));
            RESULT_POSSIBLE_MATCH = ImmutableMultiset.of((Object)((Object)POSSIBLE_MATCH));
        }
    }

    public static interface SearchReporter<T>
    extends AttributeDetector<T> {
        public String formatLabel(String var1, Multiset<T> var2);
    }

    public static interface AttributeDetector<T> {
        public Multiset<T> apply(ConfigReference<?> var1, @Nullable Class<?> var2);
    }

    public static interface Detector {
        public boolean apply(ConfigReference<?> var1, @Nullable Class<?> var2);
    }
}

