/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.samskivert.util.Tuple;
import com.threerings.config.ConfigGroup;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ConfigTreeNode
extends DefaultMutableTreeNode
implements Exportable {
    protected ManagedConfig _config;
    protected int _count = 1;
    protected boolean _expanded;
    protected transient HashMap<String, ConfigTreeNode> _childrenByName;
    protected static final String SLASH_REPLACEMENT = "%SLASH%";

    public ConfigTreeNode(String partialName, ManagedConfig config) {
        super(partialName, config == null);
        this._config = config;
    }

    public ConfigTreeNode() {
    }

    public String getName() {
        String partialName = ConfigTreeNode.encode((String)this.userObject);
        String parentName = this.parent == null ? null : ((ConfigTreeNode)this.parent).getName();
        return parentName == null ? partialName : parentName + "/" + partialName;
    }

    public ManagedConfig getConfig() {
        return this._config;
    }

    public void incrementCount() {
        ++this._count;
    }

    public int decrementCount() {
        return --this._count;
    }

    public void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    public Tuple<ConfigTreeNode, ConfigTreeNode> getInsertionPoint(ManagedConfig config, String name) {
        ConfigTreeNode child;
        int idx = name.indexOf(47);
        if (idx == -1) {
            ConfigTreeNode child2;
            String partial = ConfigTreeNode.decode(name);
            ConfigTreeNode configTreeNode = child2 = this._childrenByName == null ? null : this._childrenByName.get(partial);
            if (child2 == null) {
                child2 = new ConfigTreeNode(partial, config);
            }
            return new Tuple((Object)this, (Object)child2);
        }
        String partial = ConfigTreeNode.decode(name.substring(0, idx));
        ConfigTreeNode configTreeNode = child = this._childrenByName == null ? null : this._childrenByName.get(partial);
        if (child == null) {
            child = new ConfigTreeNode(partial, null);
            child.insertConfig(config, name.substring(idx + 1));
            return new Tuple((Object)this, (Object)child);
        }
        return child.getInsertionPoint(config, name.substring(idx + 1));
    }

    public void insertConfig(ManagedConfig config, String name) {
        int idx = name.indexOf(47);
        if (idx == -1) {
            ConfigTreeNode child;
            String partial = ConfigTreeNode.decode(name);
            ConfigTreeNode configTreeNode = child = this._childrenByName == null ? null : this._childrenByName.get(partial);
            if (child == null) {
                child = new ConfigTreeNode(partial, config);
                this.insert(child, this.getInsertionIndex(child));
            } else {
                child.incrementCount();
            }
        } else {
            ConfigTreeNode child;
            String partial = ConfigTreeNode.decode(name.substring(0, idx));
            ConfigTreeNode configTreeNode = child = this._childrenByName == null ? null : this._childrenByName.get(partial);
            if (child == null) {
                child = new ConfigTreeNode(partial, null);
                this.insert(child, this.getInsertionIndex(child));
            }
            child.insertConfig(config, name.substring(idx + 1));
        }
    }

    public void addConfigs(ConfigGroup<ManagedConfig> group) {
        if (this._config != null) {
            this._config.setName(this.getName());
            group.addConfig(this._config);
        } else if (this.children != null) {
            for (Object child : this.children) {
                ((ConfigTreeNode)child).addConfigs(group);
            }
        }
    }

    public void removeConfigs(ConfigGroup<ManagedConfig> group) {
        if (this._config != null) {
            group.removeConfig(this._config);
        } else if (this.children != null) {
            for (Object child : this.children) {
                ((ConfigTreeNode)child).removeConfigs(group);
            }
        }
    }

    public void getConfigs(List<ManagedConfig> configs) {
        this.getConfigs(configs, false);
    }

    public void getConfigs(List<ManagedConfig> configs, boolean immediate) {
        if (this._config != null) {
            configs.add(this._config);
        } else if (this.children != null) {
            for (Object child : this.children) {
                if (immediate) {
                    ManagedConfig config = ((ConfigTreeNode)child).getConfig();
                    if (config == null) continue;
                    configs.add(config);
                    continue;
                }
                ((ConfigTreeNode)child).getConfigs(configs);
            }
        }
    }

    public ConfigTreeNode getNode(String name) {
        int idx = name.indexOf(47);
        if (idx == -1) {
            return this._childrenByName == null ? null : this._childrenByName.get(ConfigTreeNode.decode(name));
        }
        String partial = ConfigTreeNode.decode(name.substring(0, idx));
        ConfigTreeNode child = this._childrenByName == null ? null : this._childrenByName.get(partial);
        return child == null ? null : child.getNode(name.substring(idx + 1));
    }

    public boolean verifyConfigClass(Class<?> clazz) {
        if (this._config != null) {
            return clazz.isInstance(this._config) || this._config instanceof DerivedConfig;
        }
        if (this.children != null) {
            for (Object child : this.children) {
                if (((ConfigTreeNode)child).verifyConfigClass(clazz)) continue;
                return false;
            }
        }
        return true;
    }

    public String findNameForChild(String base) {
        if (this._childrenByName == null || !this._childrenByName.containsKey(base)) {
            return base;
        }
        int ii = 2;
        String name;
        while (this._childrenByName.containsKey(name = base + " (" + ii + ")")) {
            ++ii;
        }
        return name;
    }

    public int getInsertionIndex(ConfigTreeNode child) {
        if (this.children == null) {
            return 0;
        }
        String name = (String)child.getUserObject();
        boolean folder = child.getAllowsChildren();
        int nn = this.children.size();
        for (int ii = 0; ii < nn; ++ii) {
            ConfigTreeNode ochild = (ConfigTreeNode)this.children.get(ii);
            String oname = (String)ochild.getUserObject();
            boolean ofolder = ochild.getAllowsChildren();
            if (!(folder == ofolder ? name.compareTo(oname) <= 0 : !folder)) continue;
            return ii;
        }
        return this.children.size();
    }

    public void expandPaths(JTree tree) {
        if (this._expanded) {
            tree.expandPath(new TreePath(this.getPath()));
            if (this.children != null) {
                for (Object child : this.children) {
                    ((ConfigTreeNode)child).expandPaths(tree);
                }
            }
        }
    }

    public void expandPaths(JTree tree, int depth) {
        if (!this.getAllowsChildren()) {
            return;
        }
        tree.expandPath(new TreePath(this.getPath()));
        if (depth-- > 0 && this.children != null) {
            for (Object child : this.children) {
                ((ConfigTreeNode)child).expandPaths(tree, depth);
            }
        }
    }

    public void writeFields(Exporter out) throws IOException {
        out.defaultWriteFields();
        out.write("name", (String)this.userObject, (String)null);
        out.write("parent", this.parent, null, MutableTreeNode.class);
        out.write("children", this.children, null, Vector.class);
    }

    public void readFields(Importer in) throws IOException {
        in.defaultReadFields();
        this.userObject = in.read("name", (String)null);
        this.parent = in.read("parent", null, MutableTreeNode.class);
        this.children = in.read("children", null, Vector.class);
        if (this.children != null) {
            this._childrenByName = new HashMap(this.children.size());
            for (Object child : this.children) {
                ConfigTreeNode node = (ConfigTreeNode)child;
                this._childrenByName.put((String)node.getUserObject(), node);
            }
        }
        this.allowsChildren = this._config == null;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        super.insert(child, index);
        if (this._childrenByName == null) {
            this._childrenByName = new HashMap(1);
        }
        ConfigTreeNode node = (ConfigTreeNode)child;
        this._childrenByName.put((String)node.getUserObject(), node);
    }

    @Override
    public void remove(int index) {
        ConfigTreeNode child = (ConfigTreeNode)this.children.get(index);
        this._childrenByName.remove(child.getUserObject());
        if (this._childrenByName.isEmpty()) {
            this._childrenByName = null;
        }
        super.remove(index);
    }

    @Override
    public ConfigTreeNode clone() {
        ConfigTreeNode cnode = (ConfigTreeNode)super.clone();
        cnode.parent = null;
        if (this._config != null) {
            cnode._config = (ManagedConfig)this._config.clone();
        } else if (this.children != null) {
            cnode.children = new Vector();
            int nn = this.children.size();
            for (int ii = 0; ii < nn; ++ii) {
                ConfigTreeNode child = (ConfigTreeNode)this.children.get(ii);
                cnode.insert(child.clone(), ii);
            }
        }
        return cnode;
    }

    public ConfigTreeNode deepClone() {
        ConfigTreeNode cnode = (ConfigTreeNode)super.clone();
        cnode.parent = null;
        if (this._config != null) {
            cnode._config = this._config.getOriginalCopy();
        } else if (this.children != null) {
            cnode.children = new Vector();
            int nn = this.children.size();
            for (int ii = 0; ii < nn; ++ii) {
                ConfigTreeNode child = (ConfigTreeNode)this.children.get(ii);
                cnode.insert(child.deepClone(), ii);
            }
        }
        return cnode;
    }

    protected static String encode(String name) {
        return name == null ? null : name.replace("/", SLASH_REPLACEMENT);
    }

    protected static String decode(String name) {
        return name == null ? null : name.replace(SLASH_REPLACEMENT, "/");
    }
}

