/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.config.ReferenceConstraints;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeFilterPanel;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.editor.Introspector;
import com.threerings.editor.swing.editors.util.RecentDirectoryList;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.resource.ResourceManager;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public abstract class ConfigChooser
extends JPanel {
    protected ChoseListener listener;
    protected static Preferences _prefs = Preferences.userNodeForPackage(ConfigChooser.class);

    public ChoseListener getListener() {
        return this.listener;
    }

    public void setListener(ChoseListener listener) {
        this.listener = listener;
    }

    public static ConfigChooser createInstance(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz) {
        return cfgmgr.isResourceClass(clazz) ? new ResourceChooser(msgmgr, cfgmgr.getResourceManager(), clazz) : new TreeChooser(msgmgr, cfgmgr, clazz);
    }

    public static ConfigChooser createInstance(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz, ReferenceConstraints constraints) {
        ConfigChooser chooser = ConfigChooser.createInstance(msgmgr, cfgmgr, clazz);
        if (constraints != null && chooser instanceof TreeChooser) {
            String desc = constraints.description();
            if ("".equals(desc)) {
                List<Class<? extends ManagedConfig>> vals = Arrays.asList(constraints.value());
                desc = Joiner.on((String)", ").join(Iterables.transform(vals, (Function)new Function<Class<?>, String>(){

                    public String apply(Class<?> clazz) {
                        return ConfigGroup.getName(clazz);
                    }
                }));
            } else {
                MessageBundle msgs = msgmgr.getBundle(Introspector.getMessageBundle(clazz));
                if (msgs.exists(desc)) {
                    desc = msgs.get(desc);
                }
            }
            ((TreeChooser)chooser)._filterPanel.addConstraint(desc, PropertyUtil.getRawConfigPredicate(constraints), false);
        }
        return chooser;
    }

    public static ConfigChooser createInstance(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz, String config) {
        ConfigChooser chooser = ConfigChooser.createInstance(msgmgr, cfgmgr, clazz);
        if (config != null) {
            chooser.setSelectedConfig(config);
        }
        return chooser;
    }

    public abstract boolean showDialog(Component var1);

    public abstract void setSelectedConfig(String var1);

    public abstract String getSelectedConfig();

    protected String getLabel(MessageManager msgmgr, Class<?> clazz, String type) {
        String key;
        MessageBundle msgs = msgmgr.getBundle(Introspector.getMessageBundle(clazz));
        return msgs.exists(key = "m." + type) ? msgs.get(key) : type;
    }

    protected static class TreeChooser
    extends ConfigChooser {
        protected MessageBundle _msgs;
        protected String _label;
        protected ConfigTreeFilterPanel _filterPanel;
        protected ConfigGroup<?>[] _groups;
        protected JButton _ok;
        protected JButton _cancel;
        protected String _selected;

        public TreeChooser(MessageManager msgmgr, ConfigManager cfgmgr, Class<?> clazz) {
            this._msgs = msgmgr.getBundle("editor.config");
            this._label = this.getLabel(msgmgr, clazz, ConfigGroup.getName(clazz));
            Class<?> cclass = clazz;
            this._groups = cfgmgr.getGroups(cclass);
            this.setLayout(new BorderLayout());
            this._filterPanel = new ConfigTreeFilterPanel(msgmgr);
            this.add((Component)this._filterPanel, "North");
            JPanel bpanel = new JPanel();
            this.add((Component)bpanel, "South");
            this._ok = new JButton(this._msgs.get("b.ok"));
            bpanel.add(this._ok);
            this._cancel = new JButton(this._msgs.get("b.cancel"));
            bpanel.add(this._cancel);
        }

        @Override
        public boolean showDialog(Component parent) {
            Component root = SwingUtilities.getRoot(parent);
            String title = this._msgs.get("m.select_config", new String[]{this._label});
            final JDialog dialog = root instanceof Dialog ? new JDialog((Dialog)root, title, true) : new JDialog((Frame)(root instanceof Frame ? root : null), title, true);
            dialog.add((Component)this, "Center");
            final ConfigTree tree = new ConfigTree(this._groups);
            JScrollPane pane = new JScrollPane(tree);
            this.add((Component)pane, "Center");
            this._filterPanel.setTree(tree);
            final boolean[] result = new boolean[1];
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (event.getSource() == _ok) {
                        _selected = tree.getSelectedNode().getName();
                        result[0] = true;
                    }
                    if (event.getSource() == _cancel && listener != null) {
                        listener.cancel();
                    }
                    dialog.setVisible(false);
                }
            };
            this._ok.addActionListener(al);
            this._cancel.addActionListener(al);
            tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (event.getClickCount() == 2) {
                        int row = tree.getRowForLocation(event.getX(), event.getY());
                        ConfigTreeNode node = tree.getSelectedNode();
                        if (row != -1 && node != null && node.getConfig() != null) {
                            _selected = node.getName();
                            result[0] = true;
                            dialog.setVisible(false);
                        }
                    }
                }
            });
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent event) {
                    boolean isConfig;
                    ConfigTreeNode node = tree.getSelectedNode();
                    if (node == null) {
                        return;
                    }
                    _selected = node.getName();
                    boolean bl = isConfig = node != null && node.getConfig() != null;
                    if (listener != null && isConfig) {
                        listener.onChange(_selected);
                    }
                    _ok.setEnabled(isConfig);
                }
            });
            this._ok.setEnabled(false);
            tree.setSelectedNode(this._selected);
            dialog.setSize(300, 400);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
            this._ok.removeActionListener(al);
            this._cancel.removeActionListener(al);
            this.remove(pane);
            tree.dispose();
            dialog.dispose();
            return result[0];
        }

        @Override
        public void setSelectedConfig(String config) {
            this._selected = config;
        }

        @Override
        public String getSelectedConfig() {
            return this._selected;
        }
    }

    protected static class ResourceChooser
    extends ConfigChooser {
        protected ResourceManager _rsrcmgr;
        protected JFileChooser _chooser;
        protected String _prefdir;

        public ResourceChooser(MessageManager msgmgr, ResourceManager rsrcmgr, Class<?> clazz) {
            this._rsrcmgr = rsrcmgr;
            final MessageBundle msgs = msgmgr.getBundle("editor.config");
            String ddir = rsrcmgr.getResourceFile("").toString();
            String type = ConfigGroup.getName(clazz);
            final String label = this.getLabel(msgmgr, clazz, type);
            this._prefdir = type + "_dir";
            this._chooser = new JFileChooser(_prefs.get(this._prefdir, ddir));
            this._chooser.setDialogTitle(msgs.get("m.select_config", new String[]{label}));
            this._chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || StringUtil.toUSLowerCase((String)file.getName()).endsWith(".dat");
                }

                @Override
                public String getDescription() {
                    return msgs.get("m.config_files", new String[]{label});
                }
            });
            this._chooser.setAccessory(new RecentDirectoryList("rsrc:" + clazz.getName()));
        }

        @Override
        public void setListener(ChoseListener listener) {
            super.setListener(listener);
            String old = listener._oldValue;
            if (old != null) {
                File file = this._rsrcmgr.getResourceFile(old);
                if (file != null) {
                    this._chooser.setCurrentDirectory(file.getParentFile());
                }
            } else {
                this._chooser.setCurrentDirectory(this._rsrcmgr.getResourceFile(""));
            }
        }

        @Override
        public boolean showDialog(Component parent) {
            boolean approved = this._chooser.showOpenDialog(parent) == 0;
            _prefs.put(this._prefdir, this._chooser.getCurrentDirectory().toString());
            return approved;
        }

        @Override
        public void setSelectedConfig(String config) {
            this._chooser.setSelectedFile(config == null ? null : this._rsrcmgr.getResourceFile(config));
        }

        @Override
        public String getSelectedConfig() {
            File file = this._chooser.getSelectedFile();
            return file == null ? null : this._rsrcmgr.getResourcePath(file);
        }
    }

    public static abstract class ChoseListener {
        private String _oldValue = null;

        public ChoseListener(String oldValue) {
            this._oldValue = oldValue;
        }

        public abstract void onChange(String var1);

        public void cancel() {
            this.onChange(this._oldValue);
        }
    }
}

