/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.dist.data;

import com.threerings.ClydeLog;
import com.threerings.config.dist.data.ConfigEntry;
import com.threerings.config.dist.data.ConfigKey;
import com.threerings.config.dist.data.DConfigMarshaller;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.ObjectAccessException;

public class DConfigObject
extends DObject {
    public static final String DCONFIG_SERVICE = "dconfigService";
    public static final String ADDED = "added";
    public static final String UPDATED = "updated";
    public static final String REMOVED = "removed";
    public DConfigMarshaller dconfigService;
    public DSet<ConfigEntry> added = DSet.newDSet();
    public DSet<ConfigEntry> updated = DSet.newDSet();
    public DSet<ConfigKey> removed = DSet.newDSet();

    public <T extends DSet.Entry> void requestEntryAdd(String name, DSet<T> set, T entry, int clientOid) {
        this.applyAndPostEvent((DEvent)new ClientEntryAddedEvent<T>(this._oid, name, entry, clientOid));
    }

    public <T extends DSet.Entry> void requestEntryRemove(String name, DSet<T> set, Comparable<?> key, int clientOid) {
        this.applyAndPostEvent((DEvent)new ClientEntryRemovedEvent(this._oid, name, key, clientOid));
    }

    public <T extends DSet.Entry> void requestEntryUpdate(String name, DSet<T> set, T entry, int clientOid) {
        this.applyAndPostEvent((DEvent)new ClientEntryUpdatedEvent<T>(this._oid, name, entry, clientOid));
    }

    public void setDconfigService(DConfigMarshaller value) {
        DConfigMarshaller ovalue = this.dconfigService;
        this.requestAttributeChange(DCONFIG_SERVICE, value, ovalue);
        this.dconfigService = value;
    }

    public void addToAdded(ConfigEntry elem) {
        this.requestEntryAdd(ADDED, this.added, elem);
    }

    public void removeFromAdded(Comparable<?> key) {
        this.requestEntryRemove(ADDED, this.added, key);
    }

    public void updateAdded(ConfigEntry elem) {
        this.requestEntryUpdate(ADDED, this.added, elem);
    }

    public void setAdded(DSet<ConfigEntry> value) {
        DSet clone;
        this.requestAttributeChange(ADDED, value, this.added);
        this.added = clone = value == null ? null : value.clone();
    }

    public void addToUpdated(ConfigEntry elem) {
        this.requestEntryAdd(UPDATED, this.updated, elem);
    }

    public void removeFromUpdated(Comparable<?> key) {
        this.requestEntryRemove(UPDATED, this.updated, key);
    }

    public void updateUpdated(ConfigEntry elem) {
        this.requestEntryUpdate(UPDATED, this.updated, elem);
    }

    public void setUpdated(DSet<ConfigEntry> value) {
        DSet clone;
        this.requestAttributeChange(UPDATED, value, this.updated);
        this.updated = clone = value == null ? null : value.clone();
    }

    public void addToRemoved(ConfigKey elem) {
        this.requestEntryAdd(REMOVED, this.removed, elem);
    }

    public void removeFromRemoved(Comparable<?> key) {
        this.requestEntryRemove(REMOVED, this.removed, key);
    }

    public void updateRemoved(ConfigKey elem) {
        this.requestEntryUpdate(REMOVED, this.removed, elem);
    }

    public void setRemoved(DSet<ConfigKey> value) {
        DSet clone;
        this.requestAttributeChange(REMOVED, value, this.removed);
        this.removed = clone = value == null ? null : value.clone();
    }

    protected void applyAndPostEvent(DEvent event) {
        try {
            event.applyToObject((DObject)this);
        }
        catch (ObjectAccessException e) {
            ClydeLog.log.warning((Object)"Failed to apply event.", new Object[]{e});
        }
        this.postEvent(event);
    }

    public static class ClientEntryUpdatedEvent<T extends DSet.Entry>
    extends EntryUpdatedEvent<T> {
        protected int _clientOid;

        public ClientEntryUpdatedEvent(int toid, String name, T entry, int clientOid) {
            super(toid, name, entry);
            this._clientOid = clientOid;
        }

        public int getClientOid() {
            return this._clientOid;
        }
    }

    public static class ClientEntryRemovedEvent<T extends DSet.Entry>
    extends EntryRemovedEvent<T> {
        protected int _clientOid;

        public ClientEntryRemovedEvent(int toid, String name, Comparable<?> key, int clientOid) {
            super(toid, name, key);
            this._clientOid = clientOid;
        }

        public int getClientOid() {
            return this._clientOid;
        }
    }

    public static class ClientEntryAddedEvent<T extends DSet.Entry>
    extends EntryAddedEvent<T> {
        protected int _clientOid;

        public ClientEntryAddedEvent(int toid, String name, T entry, int clientOid) {
            super(toid, name, entry);
            this._clientOid = clientOid;
        }

        public int getClientOid() {
            return this._clientOid;
        }

        public boolean applyToObject(DObject target) throws ObjectAccessException {
            boolean result = super.applyToObject(target);
            this._alreadyApplied = true;
            return result;
        }
    }
}

