/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.editor.Editable;
import com.threerings.editor.Property;
import com.threerings.editor.util.Validator;
import com.threerings.expr.Scope;
import com.threerings.util.CacheUtil;
import com.threerings.util.DeepOmit;
import com.threerings.util.DeepUtil;
import java.util.Map;

public class ParameterizedConfig
extends ManagedConfig {
    @Editable(weight=1.0)
    public Parameter[] parameters = Parameter.EMPTY_ARRAY;
    @DeepOmit
    protected transient ParameterizedConfig _base;
    @DeepOmit
    protected transient ArgumentMap _args;
    @DeepOmit
    protected transient Map<ArgumentMap, ParameterizedConfig> _derived;

    public Parameter getParameter(String name) {
        return ParameterizedConfig.getParameter(this.parameters, name);
    }

    @Override
    public ConfigReference<? extends ManagedConfig> getReference() {
        ConfigReference<? extends ManagedConfig> ref = super.getReference();
        if (this._args != null) {
            this._args.copy(ref.getArguments());
        }
        return ref;
    }

    @Override
    public ManagedConfig getInstance(Scope scope, ArgumentMap args) {
        ParameterizedConfig instance;
        if (args == null || args.isEmpty() || this.parameters.length == 0) {
            return this.getBound(scope);
        }
        ArgumentMap filteredArgs = args;
        ArgumentMap derivedArgs = null;
        for (String name : args.keySet()) {
            if (this.getParameter(name) != null) continue;
            filteredArgs = derivedArgs = new ArgumentMap();
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                name = entry.getKey();
                if (this.getParameter(name) == null) continue;
                filteredArgs.put(name, entry.getValue());
            }
            if (!filteredArgs.isEmpty()) break;
            return this.getBound(scope);
        }
        if (this._derived == null) {
            this._derived = CacheUtil.softValues(1);
        }
        if ((instance = this._derived.get(filteredArgs)) == null) {
            if (derivedArgs == null) {
                derivedArgs = filteredArgs.clone();
            }
            instance = (ParameterizedConfig)this.clone();
            this._derived.put(derivedArgs, instance);
            instance.init(this._cfgmgr);
            instance._base = this;
            instance._args = derivedArgs;
            this.applyArguments(instance, derivedArgs);
        }
        return instance.getBound(scope);
    }

    @Override
    public void wasUpdated() {
        for (Parameter parameter : this.parameters) {
            parameter.invalidateProperties();
        }
        super.wasUpdated();
        if (this._derived != null) {
            for (Map.Entry entry : this._derived.entrySet()) {
                ParameterizedConfig instance = (ParameterizedConfig)entry.getValue();
                this.copy(instance);
                this.applyArguments(instance, (ArgumentMap)entry.getKey());
                instance.wasUpdated();
            }
            if (this._derived.isEmpty()) {
                this._derived = null;
            }
        }
    }

    public boolean isInvalidParameterPath(String path) {
        return path.equals("comment") || path.equals("config_type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateReferences(Validator validator) {
        boolean result = super.validateReferences(validator);
        for (Parameter parameter : this.parameters) {
            validator.pushWhere(parameter.name);
            try {
                result &= parameter.validatePaths(validator, this);
            }
            finally {
                validator.popWhere();
            }
        }
        return result;
    }

    @Override
    public void validateOuters(String where) {
        for (Parameter parameter : this.parameters) {
            parameter.validateOuters(where, this);
        }
    }

    @Override
    protected void maybeFireOnConfigManager() {
        if (this._base == null) {
            super.maybeFireOnConfigManager();
        }
    }

    protected ManagedConfig getBound(Scope scope) {
        return this;
    }

    protected void applyArguments(ParameterizedConfig instance, ArgumentMap args) {
        this.applyArguments(instance, args, this.parameters);
    }

    protected void applyArguments(ParameterizedConfig instance, ArgumentMap args, Parameter[] params) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            Object value;
            Property prop;
            Parameter param = ParameterizedConfig.getParameter(params, entry.getKey());
            if (param == null || (prop = param.getProperty(this)) == null || !prop.isLegalValue(value = entry.getValue())) continue;
            prop.set(instance, DeepUtil.copy(value));
        }
    }

    protected static Parameter getParameter(Parameter[] params, String name) {
        for (Parameter param : params) {
            if (!param.name.equals(name)) continue;
            return param;
        }
        return null;
    }
}

