/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.ArgumentPathProperty;
import com.threerings.editor.DynamicallyEditable;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.InvalidPathsException;
import com.threerings.editor.PathProperty;
import com.threerings.editor.Property;
import com.threerings.editor.TranslatedPathProperty;
import com.threerings.editor.util.Validator;
import com.threerings.export.Exportable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import com.threerings.util.Inner;
import com.threerings.util.ReflectionUtil;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import proguard.annotation.Keep;

@EditorTypes(value={Direct.class, Choice.class, Translated.class})
public abstract class Parameter
extends DeepObject
implements Exportable {
    public static final Parameter[] EMPTY_ARRAY = new Parameter[0];
    @Editable
    public String name = "";
    @DeepOmit
    protected transient Property _property = INVALID_PROPERTY;
    @DeepOmit
    protected transient Property _argumentProperty = INVALID_PROPERTY;
    protected static final Property INVALID_PROPERTY = new Property(){

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public Type getGenericType() {
            return null;
        }

        @Override
        public Object get(Object object) {
            return null;
        }

        @Override
        public void set(Object object, Object value) {
        }
    };

    public Property getProperty(ParameterizedConfig reference) {
        if (this._property == INVALID_PROPERTY) {
            this._property = this.createProperty(reference);
        }
        return this._property;
    }

    public Property getArgumentProperty(ParameterizedConfig reference) {
        if (this._argumentProperty == INVALID_PROPERTY) {
            this._argumentProperty = this.createArgumentProperty(reference);
        }
        return this._argumentProperty;
    }

    public void invalidateProperties() {
        this._property = this._argumentProperty = INVALID_PROPERTY;
    }

    public abstract boolean validatePaths(Validator var1, ParameterizedConfig var2);

    public void validateOuters(String where, ParameterizedConfig outer) {
    }

    protected abstract Property createProperty(ParameterizedConfig var1);

    protected abstract Property createArgumentProperty(ParameterizedConfig var1);

    public static class Choice
    extends Parameter
    implements Inner {
        public static final Option[] EMPTY_OPTION_ARRAY = new Option[0];
        @Editable
        public Direct[] directs = Direct.EMPTY_ARRAY;
        @Editable(depends={"directs"})
        public Option[] options = EMPTY_OPTION_ARRAY;
        @Editable(editor="choice", depends={"options"})
        public String choice;
        @DeepOmit
        protected transient ParameterizedConfig _outer;
        @DeepOmit
        protected transient Property[] _optionProperties;

        public Choice(ParameterizedConfig outer) {
            this._outer = outer;
        }

        @Keep
        public String[] getChoiceOptions() {
            String[] names = new String[this.options.length];
            for (int ii = 0; ii < this.options.length; ++ii) {
                names[ii] = this.options[ii].name;
            }
            return names;
        }

        @Override
        public void setOuter(Object outer) {
            this._outer = (ParameterizedConfig)outer;
        }

        @Override
        public Object getOuter() {
            return this._outer;
        }

        @Override
        public void invalidateProperties() {
            super.invalidateProperties();
            for (Direct direct : this.directs) {
                direct.invalidateProperties();
            }
            for (DeepObject deepObject : this.options) {
                ((Option)deepObject).updateArguments();
            }
            this._optionProperties = null;
        }

        @Override
        public boolean validatePaths(Validator validator, ParameterizedConfig reference) {
            boolean result = true;
            for (Direct direct : this.directs) {
                result &= direct.validatePaths(validator, reference);
            }
            return result;
        }

        @Override
        public void validateOuters(String where, ParameterizedConfig outer) {
            if (this._outer != outer) {
                this._outer = outer;
                ClydeLog.log.warning((Object)"Fixed invalid outer reference.", new Object[]{"where", where, "parameter", this.name});
            }
            for (Option option : this.options) {
                option.validateOuters(where, this);
            }
        }

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            int idx = ListUtil.indexOfRef((Object[])reference.parameters, (Object)this);
            if (idx == -1) {
                return null;
            }
            try {
                return new PathProperty(reference.getConfigManager(), this.name, reference, new String[]{"parameters[" + idx + "].choice"}){

                    @Override
                    public void set(Object object, Object value) {
                        super.set(object, value);
                        Option option = this.getOption((String)value);
                        if (option != null) {
                            option.apply((ParameterizedConfig)object);
                        }
                    }
                };
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }

        @Override
        protected Property createArgumentProperty(ParameterizedConfig reference) {
            int idx = ListUtil.indexOfRef((Object[])reference.parameters, (Object)this);
            if (idx == -1) {
                return null;
            }
            try {
                return new ArgumentPathProperty(reference.getConfigManager(), this.name, (Object)reference, "parameters[" + idx + "].choice");
            }
            catch (InvalidPathsException e) {
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Failed to create argument property.", new Object[]{"name", this.name, e});
                return null;
            }
        }

        protected Option getOption(String name) {
            for (Option option : this.options) {
                if (!option.name.equals(name)) continue;
                return option;
            }
            return null;
        }

        protected Property[] getOptionProperties() {
            if (this._optionProperties == null) {
                ArrayList<2> props = new ArrayList<2>(this.directs.length);
                for (Direct direct : this.directs) {
                    final Property aprop = direct.getArgumentProperty(this._outer);
                    if (aprop == null) continue;
                    props.add(new Property(){
                        {
                            this._name = aprop.getName();
                        }

                        @Override
                        public Member getMember() {
                            return aprop.getMember();
                        }

                        @Override
                        public Object getMemberObject(Object object) {
                            return aprop.getMemberObject(object);
                        }

                        @Override
                        public Class<?> getType() {
                            return aprop.getType();
                        }

                        @Override
                        public Type getGenericType() {
                            return aprop.getGenericType();
                        }

                        @Override
                        public Object get(Object object) {
                            return aprop.get(((Option)object)._arguments);
                        }

                        @Override
                        public void set(Object object, Object value) {
                            aprop.set(((Option)object)._arguments, value);
                        }
                    });
                }
                this._optionProperties = props.toArray(new Property[props.size()]);
            }
            return this._optionProperties;
        }

        public class Option
        extends DeepObject
        implements DynamicallyEditable,
        Exportable {
            @Editable
            public String name = "";
            protected ArgumentMap _arguments = new ArgumentMap();

            public void apply(ParameterizedConfig instance) {
                Choice.this._outer.applyArguments(instance, this._arguments, Choice.this.directs);
            }

            public void validateOuters(String where, Choice outer) {
                if (Choice.this != outer) {
                    ReflectionUtil.setOuter(this, outer);
                    ClydeLog.log.warning((Object)"Fixed invalid outer reference.", new Object[]{"where", where, "parameter", outer.name, "option", this.name});
                }
                Iterator it = this._arguments.keySet().iterator();
                block0: while (it.hasNext()) {
                    String arg = (String)it.next();
                    for (Direct d : Choice.this.directs) {
                        if (arg.equals(d.name)) continue block0;
                    }
                    it.remove();
                }
            }

            protected void updateArguments() {
                HashSet directNames = Sets.newHashSet();
                for (Direct d : Choice.this.directs) {
                    directNames.add(d.name);
                }
                ArrayList added = Lists.newArrayList((Iterable)Sets.difference((Set)directNames, this._arguments.keySet()));
                ArrayList removed = Lists.newArrayList((Iterable)Sets.difference(this._arguments.keySet(), (Set)directNames));
                if (added.size() == 1 && removed.size() == 1) {
                    this._arguments.put((String)added.get(0), this._arguments.remove(removed.get(0)));
                } else {
                    this._arguments.keySet().removeAll(removed);
                }
            }

            @Override
            public Property[] getDynamicProperties() {
                return Choice.this.getOptionProperties();
            }
        }
    }

    public static class DerivedConfigParameter
    extends Direct {
        @Editable
        public String getImportantInfo() {
            return "This isn't a real parameter. This config was created from a derivation.";
        }

        @Editable(constant=true)
        public void setImportantInfo(String s) {
        }

        @Override
        public String toString() {
            return this.name + "(derived parameter)";
        }
    }

    public static class Translated
    extends Direct {
        @Editable
        public String bundle = "";

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            try {
                return new TranslatedPathProperty(reference.getConfigManager(), this.name, this.bundle, reference, this.paths);
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }
    }

    public static class Direct
    extends Parameter {
        public static final Direct[] EMPTY_ARRAY = new Direct[0];
        @Editable(width=40, editor="paths")
        public String[] paths = ArrayUtil.EMPTY_STRING;

        @Override
        public boolean validatePaths(Validator validator, ParameterizedConfig reference) {
            boolean result = true;
            for (String path : this.paths) {
                if (!reference.isInvalidParameterPath(path)) {
                    try {
                        new PathProperty(reference.getConfigManager(), this.name, reference, path);
                        continue;
                    }
                    catch (InvalidPathsException invalidPathsException) {
                        // empty catch block
                    }
                }
                validator.output("invalid path: " + path);
                result = false;
            }
            return result;
        }

        @Override
        protected Property createProperty(ParameterizedConfig reference) {
            try {
                return new PathProperty(reference.getConfigManager(), this.name, reference, this.paths);
            }
            catch (InvalidPathsException e) {
                return null;
            }
        }

        @Override
        protected Property createArgumentProperty(ParameterizedConfig reference) {
            if (this.paths.length == 0) {
                return null;
            }
            try {
                return new ArgumentPathProperty(reference.getConfigManager(), this.name, (Object)reference, this.paths[0]);
            }
            catch (InvalidPathsException e) {
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Failed to create argument property.", new Object[]{"name", this.name, e});
                return null;
            }
        }
    }
}

