/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.expr.Scope;
import com.threerings.util.DeepOmit;
import com.threerings.util.Shallow;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class DerivedConfig
extends ParameterizedConfig {
    @Editable(editor="derivedRef", nullable=true)
    public ConfigReference<? extends ManagedConfig> base;
    @Shallow
    public transient Class<? extends ManagedConfig> cclass;
    @DeepOmit
    protected transient ManagedConfig _source;
    @DeepOmit
    protected transient SoftReference<ManagedConfig> _derivation = NO_DERIVATION;
    protected static final SoftReference<ManagedConfig> NO_DERIVATION = new SoftReference<Object>(null);

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        this.wasUpdated();
    }

    @Override
    public void wasUpdated() {
        this._derivation = NO_DERIVATION;
        this._source = null;
        super.wasUpdated();
    }

    @Override
    public boolean isInvalidParameterPath(String path) {
        return super.isInvalidParameterPath(path) || path.equals("base");
    }

    @Override
    protected ManagedConfig getBound(Scope scope) {
        ManagedConfig instance = this._derivation.get();
        if (instance != null) {
            return instance;
        }
        if (this.base == null) {
            return null;
        }
        ConfigReference<? extends ManagedConfig> ref = this.base;
        Class<? extends ManagedConfig> clazz = this.cclass;
        this._source = this._cfgmgr.getConfig(clazz, ref, scope);
        if (this._source == null) {
            return null;
        }
        instance = (ManagedConfig)this._source.clone();
        this.initializeInstance(instance);
        this.addListener(instance);
        this._derivation = new SoftReference<ManagedConfig>(instance);
        return instance;
    }

    protected void initializeInstance(ManagedConfig instance) {
        instance.init(this._cfgmgr);
        instance.setName(this.getName());
        instance.setComment(this.getComment());
        if (instance instanceof ParameterizedConfig) {
            ParameterizedConfig instanceP = (ParameterizedConfig)instance;
            instanceP._base = this;
            instanceP._args = this._args;
            this.translateParameters(instanceP);
        }
    }

    protected void translateParameters(ParameterizedConfig instance) {
        ArrayList newParams = Lists.newArrayList();
        for (Parameter p : this.parameters) {
            if (p instanceof Parameter.Direct) {
                newParams.add(this.translateDirectParameter(instance, (Parameter.Direct)p));
                continue;
            }
            if (!(p instanceof Parameter.Choice)) continue;
            Parameter.Choice pChoice = (Parameter.Choice)p;
            ArrayList newDirects = Lists.newArrayList();
            for (Parameter.Direct direct : pChoice.directs) {
                newDirects.add(this.translateDirectParameter(instance, direct));
            }
            Parameter.Choice newChoice = (Parameter.Choice)pChoice.clone();
            newChoice.directs = newDirects.toArray(Parameter.Direct.EMPTY_ARRAY);
            newChoice.setOuter(instance);
            newParams.add(newChoice);
        }
        instance.parameters = newParams.toArray(Parameter.EMPTY_ARRAY);
    }

    protected Parameter.Direct translateDirectParameter(ParameterizedConfig instance, Parameter.Direct ourParam) {
        Parameter.DerivedConfigParameter newParam = new Parameter.DerivedConfigParameter();
        newParam.name = ourParam.name;
        return newParam;
    }
}

