package com.threerings.tudey.tools;

import com.samskivert.util.RandomUtil;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.UserInterfaceWindow;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.icon.ImageIcon;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.util.Phaser;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.MessageBundle;

public class LoadingWindow extends UserInterfaceWindow  {
	protected TudeyContext _ctx;
	protected TudeySceneView _view;
	protected MessageBundle _msgs;
	protected boolean _wasFirstTime;
	protected static boolean _firstTime = true;
	protected static final String DEFAULT_BACKGROUND = "default.jpg";
	
	protected static int _helpTipCount = -1;

	public static Icon createTipIcon(TudeyContext ctx, String file) {
		TextureConfig tconfig = (TextureConfig) ctx.getConfigManager().getConfig(TextureConfig.class,
				"2D/File/Default", "File", file, new Object[0]);

		Texture texture = tconfig.getTexture(ctx);
		if ((texture instanceof Texture2D)) {
			return new ImageIcon(new Image((Texture2D) texture));
		}
		return null;
	}

	public LoadingWindow(TudeyContext ctx, TudeySceneView view) {
		super(ctx, true, "ui/loading/interface.dat", "Background", "ui/loading/images/"+ DEFAULT_BACKGROUND, new Object[0]);

		this._ctx = ctx;
		this._msgs = ctx.getMessageManager().getBundle("helptips");
		this._view = view;
		setLayer(1);
		//((Label) getComponent("title")).setText(view.getSceneTitle());
		//((Label) getComponent("subtitle")).setText(view.getSceneSubtitle());
		int loadingIdx = 0;
		this._wasFirstTime = _firstTime;
		if (_firstTime)
			_firstTime = false;
		else {
			loadingIdx = getTip();
		}
		((Label) getComponent("tipheader")).setText(this._msgs.get("t.loading" + loadingIdx));
		((Label) getComponent("tipbody")).setText(this._msgs.get("m.loading" + loadingIdx));
		String ikey = "i.loading" + loadingIdx;
		String image = this._msgs.exists(ikey) ? this._msgs.get(ikey) : "tip_exclamation.png";
		((Label) getComponent("image")).setIcon(createTipIcon(ctx, "ui/tip/" + image));
	}

	protected int getTip() {
		if (_helpTipCount == -1)
			for (_helpTipCount = 0; this._msgs.exists("t.loading" + _helpTipCount); _helpTipCount += 1)
				;
		return RandomUtil.getInt(_helpTipCount);
	}

	public void update(float pct) {
		if (pct == 1.0F)
			fadeOut();
		else
			((Label) getComponent("progress")).setText(this._msgs.get("m.loading",
					new String[] { String.valueOf(Math.round(pct * 100.0F)) }));
	}

	protected void fadeOut() {
		Label progress = (Label) getComponent("progress");
		progress.setText("");
		final Label title = (Label) getComponent("title");
		final Label subtitle = (Label) getComponent("subtitle");
		this._ctx.getApp().getStreamGain().value = 0.0F;
		if (this._wasFirstTime) {
			//this._view.getHudWindow().maybeShowNews();
			this._ctx.getRoot().moveToTop(this);
		}
		this._ctx.getRoot().addTickParticipant(
				new Phaser( "fadeBackground", Float.valueOf(3.0F), "linger", Float.valueOf(1.0F),"fadeTitle", Float.valueOf(1.0F)) {
					protected boolean _calledFadedIn;

					public void tick(float elapsed) {
						/*if (LoadingWindow.this._view.getHudWindow().isAdded())
							super.tick(elapsed);
						else*/
							completed();
					}

					protected void fadeBackground() {
						LoadingWindow.this.setAlpha(this._cpct);
						title.setAlpha(1.0F);
						subtitle.setAlpha(1.0F);
						LoadingWindow.this._ctx.getApp().getStreamGain().value = (1.0f * this._pct);
					}

					protected void linger() {
						if (!this._calledFadedIn) {
							LoadingWindow.this.fadedIn();
							this._calledFadedIn = true;
						}
					}

					protected void fadeTitle() {
						title.setAlpha(this._cpct);
						subtitle.setAlpha(this._cpct);
					}

					protected void completed() {
						LoadingWindow.this._ctx.getRoot().removeWindow(LoadingWindow.this);
						LoadingWindow.this._ctx.getRoot().removeTickParticipant(this);
						LoadingWindow.this._ctx.getApp().getStreamGain().value = 1.0f;
					}
				});
	}

	public Component getHitComponent(int mx, int my) {
		return this._alpha == 1.0F ? super.getHitComponent(mx, my) : null;
	}

	protected void fadedIn() {
		//this._view.fadedIn();
	}

	protected void wasAdded() {
		super.wasAdded();
	}

	protected void wasRemoved() {
		super.wasRemoved();
	}
}
