package com.threerings.tudey.shape;

import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.util.Coord;
import com.threerings.tudey.util.TudeySceneMetrics;

public class CoordShape extends Polygon {
	public Coord _coord = new Coord();
	protected Transform2D _transform = new Transform2D();
	public CoordShape() {
	}

	public CoordShape(Coord coord) {
		setCoord(coord.x,coord.y);
	}
	
	public CoordShape(int x, int y) {
		setCoord(x,y);
	}

	public Shape transform(Transform2D transform, Shape result) {
		_transform.set(transform);
		_transform.set(_transform.getTranslation().adjustCenter(),_transform.getRotation());
		
		Vector2f center = new Vector2f(_coord.x,_coord.y);
		CoordShape cresult = (result instanceof CoordShape) ? ((CoordShape)result) : new CoordShape();
		Vector2f nc = toTransform(transform).transformPoint(center);
		cresult.setCoord(Math.round(nc.x), Math.round(nc.y));
		return cresult;
	}
	
	protected Transform2D toTransform(Transform2D transform) {
		if(transform.getType() == 0) {
			return transform;
		}else {
			Vector2f v = transform.getTranslation();
			
			Transform2D coordTransform = new  Transform2D(new Vector2f(Math.round(v.x),Math.round(v.y)),transform.getRotation());
			return coordTransform;
		}
	}
	
	
    /**
     * Checks for an intersection with this shape and the specified polygon.
     */
    public boolean intersects (Polygon polygon) {
    	if(polygon instanceof CoordShape) {
    		return ((CoordShape)polygon)._coord.x == _coord.x && ((CoordShape)polygon)._coord.y == _coord.y;
    	}
    	
    	return super.intersects(polygon);
    }
    
	public void setCoord(int x, int y) {
		this._coord.set(x,y);
		if(_vertices == null || _vertices.length == 0) {
			_vertices = new Vector2f[] {new Vector2f(),new Vector2f(),new Vector2f(),new Vector2f()};
		}

		float deta = -0.5f;
		_vertices[0].set(x - 0.5f + deta, y - 0.5f + deta);
		_vertices[1].set(x + 0.5f + deta, y - 0.5f + deta);
		_vertices[2].set(x + 0.5f + deta, y + 0.5f + deta);
		_vertices[3].set(x - 0.5f + deta, y + 0.5f + deta);
		
		updateBounds();
		System.out.println("<<<--------------------");
		System.out.println(this);
		System.out.println("<<<-------------------->>>");
	}

	public Coord getCoord() {
		return this._coord;
	}
}
