//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.tudey.dobj;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.protobuf.io.ProtobufRegistry;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import com.google.protobuf.WireFormat;
import com.google.protobuf.Message.Builder;
import com.samskivert.io.ByteArrayOutInputStream;
import com.samskivert.util.Tuple;
import com.threerings.delta.Delta;
import com.threerings.delta.ReflectiveDelta;
import com.threerings.tudey.data.actor.Actor;

/**
 * Extends {@link ReflectiveDelta} to include the id of the affected actor.  Declared final for
 * streaming efficiency.
 */
public final class ActorDelta extends ReflectiveDelta implements com.threerings.protobuf.io.ProtobufProvider<Message>
{
    /**
     * Creates a new actor delta.
     */
    public ActorDelta (Actor original, Actor revised)
    {
        super(original, revised);
        _id = original.getId();
    }

    /**
     * No-arg constructor for deserialization.
     */
    public ActorDelta ()
    {
    }

    public void setClassMapping(ClassMapping cmap){
    	this._cmap = cmap;
    }
    
    /**
     * Returns the id of the affected actor.
     */
    public int getId ()
    {
        return _id;
    }

    @Override // documentation inherited
    public Delta merge (Delta other)
    {
        ActorDelta odelta;
        if (!(other instanceof ActorDelta && (odelta = (ActorDelta)other).getId() == _id)) {
            throw new IllegalArgumentException("Cannot merge delta " + other);
        }
        ActorDelta merged = new ActorDelta();
        merged.setClassMapping(odelta._cmap);
        merged.init(odelta._clazz);
        merged._id = _id;
        populateMergedProtobuf(odelta, merged);
        return merged;
    }

    @Override // documentation inherited
    public void writeObject (ObjectOutputStream out)
        throws IOException
    {
        out.writeInt(_id);
        super.writeObject(out);
    }

    @Override // documentation inherited
    public void readObject (ObjectInputStream in)
        throws IOException, ClassNotFoundException
    {
        _id = in.readInt();
        super.readObject(in);
    }

    
    
    /** The id of the affected actor. */
    protected int _id;


    public String toString() {
    	return "id="+_id+","+super.toString();
    }

	@Override
	public void populate(Message input) throws IOException {
		com.hexnova.clyde.scene.data.ActorDelta message = (com.hexnova.clyde.scene.data.ActorDelta)input;
		this._id = message.getId();
		int type = message.getType();
		int size = message.getSize();
		CodedInputStream cint = CodedInputStream.newInstance(message.getValue().toByteArray());
		Class clazz = ProtobufRegistry.getStreamableType(type);
		this.init(clazz);
		
		for(int i=0;i<size ;i++) {
			int number = WireFormat.getTagFieldNumber(cint.readTag());
			Tuple<Field,FieldHandler> tuple = _protobufHandlers.get(number);
			if(tuple != null) {
				tuple.right.read(cint, tuple.left,number, _protobufFields);
			}
		}
	}

	@Override
	public Message transform() throws IOException {
		com.hexnova.clyde.scene.data.ActorDelta.Builder builder = (com.hexnova.clyde.scene.data.ActorDelta.Builder) getBuilder(); 
		builder.setId(_id);
		builder.setType(ProtobufRegistry.getTypeByStreamable(_clazz));
		if(_protobufFields != null) {
			builder.setSize(_protobufFields.size());
			ByteArrayOutInputStream bos = new ByteArrayOutInputStream();
			CodedOutputStream cout = CodedOutputStream.newInstance(bos);
			for(Map.Entry<Integer, Object> entry : _protobufFields.entrySet()) {
				
				Tuple<Field,FieldHandler> tuple = _protobufHandlers.get(entry.getKey());
				if(tuple != null) {
					tuple.right.write(cout, entry.getKey(), entry.getValue());
				}
			}
			cout.flush();
			builder.setValue(ByteString.copyFrom(bos.toByteArray()));
			
		}else {
			builder.setSize(0);
		}
		
		return builder.build();
	}

	@Override
	public Builder getBuilder() {
		return com.hexnova.clyde.scene.data.ActorDelta.newBuilder();
	}
	
	public static void main(String[] args) {
		
	}
}
