package com.threerings.tudey.data;

import com.google.common.collect.ComparisonChain;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;

public class IntPair extends DeepObject implements Exportable,Streamable, Comparable<IntPair> {

	@Editable(hgroup = "a")
	public int key;
	
	@Editable(hgroup = "a")
	public int value;
	
	public IntPair() {
	}

	public IntPair(IntPair paramRankPair) {
		set(paramRankPair);
	}

	public IntPair(int rank, int subrank) {
		set(rank, subrank);
	}

	public int compareTo(IntPair o) {
		return compare(o);
	}

	public int compare(int rank, int subrank) {
		return ComparisonChain.start().compare(this.key, rank)
				.compare(this.value, subrank).result();
	}

	public void set(IntPair paramRankPair) {
		set(paramRankPair.key, paramRankPair.value);
	}

	public void set(int key, int value) {
		this.key = key;
		this.value = value;
	}

	public int compare(IntPair paramRankPair) {
		return compare(paramRankPair.key, paramRankPair.value);
	}

	public String toString() {
		return String.valueOf(this.key) + "-" + this.value;
	}
	
	public int hashCode() {
		return this.key * 31 + this.value;
	}
	
	public boolean equals(Object paramObject) {
		if (paramObject instanceof IntPair) {
			IntPair localRankPair = (IntPair) paramObject;
			if (this.key == localRankPair.key && this.value == localRankPair.value) {
				return true;
			}
		}
		return false;
	}

}