package com.threerings.opengl.gui;

import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.util.GlContext;

public class MoveableContainer extends Container {
	private Window parent;
	
	float startX, startY, lastX, lastY;
	public MoveableContainer(GlContext ctx) {
		super(ctx);
		
    	
    	MouseAdapter ls = new MouseAdapter() {
    		
    		float lastX, lastY;

    		@Override
    		public void mousePressed(MouseEvent event) {
    			lastX = event.getX();
    			lastY = event.getY();
    			if(parent != null) {
    				// make a note of the current top window
    				_ctx.getApp().getRoot().moveToTop(parent);
    		        //resort
    		        _ctx.getApp().getRoot().resortWindows();
    		        _ctx.getApp().getRoot().requestFocus(parent);
    			}
    		}

    		@Override
    		public void mouseDragged(MouseEvent event) {
    			int detaX = (int) (lastX - event.getX());
    			int detaY = (int)(lastY - event.getY());
    			lastX = event.getX();
    			lastY = event.getY();
    			if(parent != null) {
    				parent.setLocation(parent._x - detaX , parent._y - detaY);
    			}
    		}
    		
    	};
    	
    	this.addListener(ls);
	}

	

	
	protected void wasAdded ()
    {
		super.wasAdded();
		Container container = this.getParent();
		while(container != null) {
			if(container instanceof Window) {
				this.parent = (Window)container;
				break;
			}
			
			container = container.getParent();
		}
    }
	
	 // documentation inherited
    protected void wasRemoved ()
    {
        super.wasRemoved();
        this.parent = null;
    }
}
