/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.samskivert.util.Config;
import com.threerings.math.FloatMath;
import com.threerings.math.Frustum;
import com.threerings.math.Quaternion;
import com.threerings.math.Rect;
import com.threerings.math.SphereCoords;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.tudey.config.CameraConfig;

public class TudeySceneMetrics {
    public static final Quaternion[] TILE_ROTATIONS = new Quaternion[]{new Quaternion(0.0f, 0.0f, 0.0f, 1.0f), new Quaternion(0.0f, 0.0f, 0.70710677f, 0.70710677f), new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.70710677f, -0.70710677f)};
    protected static float _elevationScale;
    protected static CameraConfig _defaultCameraConfig;
    protected static float _interestExpansion;
    protected static float _interestMax;
    protected static Rect _defaultLocalInterest;

    static {
        _defaultCameraConfig = new CameraConfig();
        Config config = new Config("/rsrc/config/tudey/scene");
        _elevationScale = config.getValue("elevation_scale", 0.5f);
        TudeySceneMetrics._defaultCameraConfig.priority = Integer.MIN_VALUE;
        TudeySceneMetrics._defaultCameraConfig.fov = FloatMath.toRadians(config.getValue("camera_fov", 60.0f));
        TudeySceneMetrics._defaultCameraConfig.near = config.getValue("camera_near", 1.0f);
        TudeySceneMetrics._defaultCameraConfig.far = config.getValue("camera_far", 100.0f);
        TudeySceneMetrics._defaultCameraConfig.coords.set(FloatMath.toRadians(config.getValue("camera_azimuth", 0.0f)), FloatMath.toRadians(config.getValue("camera_elevation", 45.0f)), config.getValue("camera_distance", 10.0f));
        TudeySceneMetrics._defaultCameraConfig.offset.set(config.getValue("camera_offset", new float[]{0.0f, 0.0f, 1.0f}));
        _interestExpansion = config.getValue("interest_expansion", 5.0f);
        _interestMax = config.getValue("interest_max", 20.0f);
        _defaultLocalInterest = TudeySceneMetrics.getLocalInterest(_defaultCameraConfig, 1.3333334f);
    }

    public static void getTileTransform(int width, int height, int x, int y, int elevation, int rotation, Transform3D result) {
        switch (rotation) {
            case 1: {
                x += height;
                break;
            }
            case 2: {
                x += width;
                y += height;
                break;
            }
            case 3: {
                y += width;
            }
        }
        result.setType(1);
        result.getRotation().set(TILE_ROTATIONS[rotation]);
        result.getTranslation().set(x, y, TudeySceneMetrics.getTileZ(elevation));
    }

    public static void getTileRegion(int width, int height, int x, int y, int rotation, Rectangle result) {
        result.set(x, y, TudeySceneMetrics.getTileWidth(width, height, rotation), TudeySceneMetrics.getTileHeight(width, height, rotation));
    }

    public static int getTileWidth(int width, int height, int rotation) {
        return rotation == 0 || rotation == 2 ? width : height;
    }

    public static int getTileHeight(int width, int height, int rotation) {
        return rotation == 0 || rotation == 2 ? height : width;
    }

    public static float getTileZ(int elevation) {
        return (float)elevation * _elevationScale;
    }

    public static int getTileElevation(float z) {
        return Math.round(z / _elevationScale);
    }

    public static CameraConfig getDefaultCameraConfig() {
        return _defaultCameraConfig;
    }

    public static Rect getDefaultLocalInterest() {
        return _defaultLocalInterest;
    }

    public static Rect getLocalInterest(CameraConfig config, float aspect) {
        Frustum frustum = new Frustum().setToPerspective(config.fov, aspect, config.near, Math.min(_interestMax, config.far));
        Transform3D xform = new Transform3D(2);
        SphereCoords coords = config.coords;
        float ce = FloatMath.cos(coords.elevation);
        xform.getTranslation().set(FloatMath.sin(coords.azimuth) * ce, -FloatMath.cos(coords.azimuth) * ce, FloatMath.sin(coords.elevation)).multLocal(coords.distance).addLocal(config.offset);
        xform.getRotation().fromAnglesXZ(1.5707964f - coords.elevation, coords.azimuth);
        frustum.transformLocal(xform);
        Rect interest = new Rect();
        Vector3f[] vector3fArray = frustum.getVertices();
        int n = vector3fArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3f vertex = vector3fArray[n2];
            interest.addLocal(new Vector2f(vertex.x, vertex.y));
            ++n2;
        }
        return interest.expandLocal(_interestExpansion, _interestExpansion);
    }
}

