/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.tudey.util.Array;
import com.threerings.tudey.util.ObjectMap;
import com.threerings.tudey.util.Pool;
import com.threerings.tudey.util.ReflectionPool;

public class Pools {
    private static final ObjectMap<Class, Pool> typePools = new ObjectMap();

    public static <T> Pool<T> get(Class<T> type, int max) {
        ReflectionPool<T> pool = typePools.get(type);
        if (pool == null) {
            pool = new ReflectionPool<T>(type, 4, max);
            typePools.put(type, pool);
        }
        return pool;
    }

    public static <T> Pool<T> get(Class<T> type) {
        return Pools.get(type, 100);
    }

    public static <T> void set(Class<T> type, Pool<T> pool) {
        typePools.put(type, pool);
    }

    public static <T> T obtain(Class<T> type) {
        return Pools.get(type).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            return;
        }
        Pool pool = typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Array objects) {
        Pools.freeAll(objects, false);
    }

    public static void freeAll(Array objects, boolean samePool) {
        if (objects == null) {
            throw new IllegalArgumentException("Objects cannot be null.");
        }
        Pool pool = null;
        int i = 0;
        int n = objects.size;
        while (i < n) {
            Object object = objects.get(i);
            if (object != null && (pool != null || (pool = typePools.get(object.getClass())) != null)) {
                pool.free(object);
                if (!samePool) {
                    pool = null;
                }
            }
            ++i;
        }
    }

    private Pools() {
    }
}

