/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.util;

import com.threerings.math.Vector2f;
import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.data.actor.Pawn;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.ActiveAdvancer;
import com.threerings.tudey.util.ActorAdvancer;

public class PawnAdvancer
extends ActiveAdvancer {
    protected Vector2f[] _path;
    protected int _pidx;
    protected Pawn _pawn;
    protected InputFrame _frame;
    protected Shape _swept;

    public PawnAdvancer(ActorAdvancer.Environment environment, Pawn pawn, int timestamp) {
        super(environment, pawn, timestamp);
        this._activities.put(1, (Object)new ActiveAdvancer.Activity(1, Integer.MAX_VALUE));
        this._activities.put(2, (Object)new ActiveAdvancer.Activity(2, true, 670));
        this._activities.put(Integer.MAX_VALUE, (Object)new ActiveAdvancer.Activity(Integer.MAX_VALUE, false, Integer.MAX_VALUE));
    }

    public void advance(InputFrame frame) {
        this._frame = frame;
        this.advance(frame.getTimestamp());
    }

    @Override
    public void init(Actor actor, int timestamp) {
        super.init(actor, timestamp);
        this._pawn = (Pawn)actor;
        this._frame = null;
    }

    @Override
    protected void step(float elapsed) {
        super.step(elapsed);
        if (this._frame != null) {
            this.updateInput();
        }
    }

    protected boolean ignoreInputPosition() {
        return false;
    }

    protected float getReachRadius(int ticksPerSecond) {
        float speed = ((Mobile)this.getActor()).getSpeed();
        return speed / (float)ticksPerSecond;
    }

    protected void updateInput() {
        ActiveAdvancer.Activity activity = this.getActivity();
        if (activity != null) {
            activity.updateInput();
        }
        if (this.canRotate()) {
            this.updateRotation();
        }
        if (this._frame.isSet(1) && this.canMove()) {
            this._pawn.setDirection(this._frame.getDirection());
            this._pawn.set(2);
        } else {
            this._pawn.clear(2);
        }
    }

    protected void updateRotation() {
        this._pawn.setRotation(this._frame.getRotation());
    }

    protected void setPath(Vector2f[] path) {
        if (this._path != path) {
            this._path = path;
            this._pidx = 0;
        }
    }

    protected void clearPath() {
        if (this._path != null) {
            this._pawn.stopMoving();
            this._path = null;
        }
    }
}

