/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.samskivert.util.StringUtil;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;

public class Compound
extends Shape {
    protected Shape[] _shapes;

    public Compound(Shape ... shapes) {
        this._shapes = shapes;
        this.updateBounds();
    }

    public Compound(int scount) {
        this._shapes = new Shape[scount];
    }

    public int getShapeCount() {
        return this._shapes.length;
    }

    public Shape getShape(int idx) {
        return this._shapes[idx];
    }

    public Shape[] getShapes() {
        return this._shapes;
    }

    @Override
    public void updateBounds() {
        this._bounds.setToEmpty();
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            shape.updateBounds();
            this._bounds.addLocal(shape.getBounds());
            ++n2;
        }
    }

    @Override
    public boolean contains(float x, float y) {
        return this.contains(new Vector2f(x, y));
    }

    @Override
    public boolean contains(Vector2f pt) {
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.contains(pt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Vector2f getCenter(Vector2f result) {
        result.set(0.0f, 0.0f);
        Vector2f pt = new Vector2f();
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            result.addLocal(shape.getCenter(pt));
            ++n2;
        }
        return result.multLocal(1.0f / (float)this._shapes.length);
    }

    @Override
    public Shape transform(Transform2D transform, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        int ii = 0;
        while (ii < this._shapes.length) {
            cresult._shapes[ii] = this._shapes[ii].transform(transform, cresult._shapes[ii]);
            ++ii;
        }
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public Shape expand(float amount, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        int ii = 0;
        while (ii < this._shapes.length) {
            cresult._shapes[ii] = this._shapes[ii].expand(amount, cresult._shapes[ii]);
            ++ii;
        }
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public Shape sweep(Vector2f translation, Shape result) {
        Compound cresult;
        Compound compound = cresult = result instanceof Compound ? (Compound)result : new Compound(this._shapes.length);
        if (cresult.getShapeCount() != this._shapes.length) {
            cresult._shapes = new Shape[this._shapes.length];
        }
        int ii = 0;
        while (ii < this._shapes.length) {
            cresult._shapes[ii] = this._shapes[ii].sweep(translation, cresult._shapes[ii]);
            ++ii;
        }
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector2f closest = result;
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.getIntersection(ray, result)) {
                result = Compound.updateClosest(ray.getOrigin(), result, closest);
            }
            ++n2;
        }
        return result != closest;
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        Vector2f currentResult = new Vector2f();
        float minDist = Float.MAX_VALUE;
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            shape.getNearestPoint(point, currentResult);
            float dist = point.distanceSquared(currentResult);
            if (dist < minDist) {
                minDist = dist;
                result.set(currentResult);
                if (Math.abs(minDist) < 1.0E-6f) {
                    return;
                }
            }
            ++n2;
        }
    }

    @Override
    public Shape.IntersectionType getIntersectionType(Rect rect) {
        if (!rect.intersects(this._bounds)) {
            return Shape.IntersectionType.NONE;
        }
        Shape.IntersectionType type = Shape.IntersectionType.NONE;
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            switch (shape.getIntersectionType(rect)) {
                case CONTAINS: {
                    return Shape.IntersectionType.CONTAINS;
                }
                case INTERSECTS: {
                    type = Shape.IntersectionType.INTERSECTS;
                }
            }
            ++n2;
        }
        return type;
    }

    @Override
    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    @Override
    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public boolean intersects(Point point) {
        if (!point.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.intersects(point)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean intersects(Segment segment) {
        if (!segment.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.intersects(segment)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean intersects(Circle circle) {
        if (!circle.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.intersects(circle)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean intersects(Capsule capsule) {
        if (!capsule.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.intersects(capsule)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean intersects(Polygon polygon) {
        if (!polygon.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (shape.intersects(polygon)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean intersects(Compound compound) {
        if (!compound.getBounds().intersects(this._bounds)) {
            return false;
        }
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            if (compound.intersects(shape)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Point point, Vector2f result) {
        return this.getSimplePenetration(point, result);
    }

    @Override
    public Vector2f getPenetration(Segment segment, Vector2f result) {
        return this.getSimplePenetration(segment, result);
    }

    @Override
    public Vector2f getPenetration(Circle circle, Vector2f result) {
        return this.getSimplePenetration(circle, result);
    }

    @Override
    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        return this.getSimplePenetration(capsule, result);
    }

    @Override
    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return this.getSimplePenetration(polygon, result);
    }

    @Override
    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    @Override
    public void draw(boolean outline) {
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape shape = shapeArray[n2];
            shape.draw(outline);
            ++n2;
        }
    }

    @Override
    public ShapeConfig createConfig() {
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[this._shapes.length];
        int ii = 0;
        while (ii < this._shapes.length) {
            ShapeConfig.TransformedShape tshape = compound.shapes[ii] = new ShapeConfig.TransformedShape();
            tshape.shape = this._shapes[ii].createConfig();
            ++ii;
        }
        return compound;
    }

    public String toString() {
        return "Comp:(" + StringUtil.join((Object[])this._shapes) + ")";
    }

    protected Vector2f getSimplePenetration(Shape shape, Vector2f result) {
        result.set(Vector2f.ZERO);
        Vector2f oresult = new Vector2f();
        Shape[] shapeArray = this._shapes;
        int n = this._shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape cshape = shapeArray[n2];
            if (cshape.intersects(shape)) {
                cshape.getPenetration(shape, oresult);
                if (oresult.lengthSquared() > result.lengthSquared()) {
                    result.set(oresult);
                }
            }
            ++n2;
        }
        return result;
    }
}

