/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.server.ClientLiaison;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.util.PawnAdvancer;
import com.threerings.util.ArrayDeque;

public class PawnLogic
extends ActiveLogic {
    protected PawnAdvancer _advancer;
    protected ClientLiaison _client;
    protected ArrayDeque<InputFrame> _input = new ArrayDeque(4);

    @Override
    protected void didInit() {
        super.didInit();
        this._advancer = (PawnAdvancer)((ActiveLogic)this)._advancer;
    }

    public void bodyEntered(ClientLiaison client) {
        this._client = client;
    }

    public void enqueueInput(InputFrame frame) {
        this._input.addLast(frame);
    }

    public int getControlDelta() {
        return this._client == null ? 0 : this._client.getControlDelta();
    }

    public ClientLiaison getClient() {
        return this._client;
    }

    public boolean isPlayer() {
        return this._client != null;
    }

    @Override
    public int getActivityAdvance() {
        return this.getControlDelta() / 2;
    }

    @Override
    protected void updateTracked() {
        super.updateTracked();
        if (this._tracked != null && !this._tracked.isVisible(this)) {
            this.setTracked(null);
        }
    }

    @Override
    protected void advance(int timestamp) {
        boolean newInput = false;
        while (!this._input.isEmpty() && this._input.peekFirst().getTimestamp() <= timestamp) {
            InputFrame frame = this._input.pollFirst();
            this._advancer.advance(frame);
            newInput = true;
        }
        if (!newInput) {
            super.advance(timestamp);
        }
    }
}

