/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigReference;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ConditionConfig;
import com.threerings.tudey.config.ExpressionConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.RegionConfig;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActionLogic;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.ExpressionLogic;
import com.threerings.tudey.server.logic.HandlerLogic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.logic.RegionLogic;
import com.threerings.tudey.server.logic.TargetLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.util.ShallowObject;
import java.util.Map;

public abstract class Logic
extends ShallowObject {
    protected TudeySceneManager _scenemgr;
    protected Map<String, Object> _variables;

    public void init(TudeySceneManager scenemgr) {
        this._scenemgr = scenemgr;
    }

    public TudeySceneManager getSceneManager() {
        return this._scenemgr;
    }

    public String[] getTags() {
        return ArrayUtil.EMPTY_STRING;
    }

    public boolean isDefaultEntrance() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public boolean isVisible(PawnLogic pawn) {
        return true;
    }

    public EntityKey getEntityKey() {
        return null;
    }

    public Transform2D getTransform() {
        return this.getTransform(new Transform2D());
    }

    public Transform2D getTransform(Transform2D result) {
        return result.set(this.getTranslation(), this.getRotation(), this.getScale());
    }

    public Transform2D getPortalTransform() {
        return this.getTransform();
    }

    public Vector2f getTranslation() {
        return Vector2f.ZERO;
    }

    public float getScale() {
        return 1.0f;
    }

    public float getRotation() {
        return 0.0f;
    }

    public Shape getShape() {
        return null;
    }

    public Vector2f[] getPatrolPath() {
        return new Vector2f[]{this.getTranslation()};
    }

    public void addShapeObserver(ShapeObserver observer) {
    }

    public void removeShapeObserver(ShapeObserver observer) {
    }

    public ConfigReference<ModelConfig> getModel() {
        return null;
    }

    public Logic getSource() {
        return null;
    }

    public void signal(int timestamp, Logic source, String name) {
    }

    public void setVariable(int timestamp, Logic source, String name, Object value) {
        if (this._variables == null) {
            this._variables = Maps.newHashMap();
        }
        this._variables.put(name, value);
    }

    public void removeVariable(int timestamp, Logic source, String name) {
        if (this._variables == null) {
            return;
        }
        this._variables.remove(name);
    }

    public Object getVariable(String name) {
        return this._variables == null ? null : this._variables.get(name);
    }

    public void request(int timestamp, PawnLogic source, String name) {
    }

    public Logic resolveTarget() {
        return this;
    }

    public Vector2f getSpawnTranslation() {
        return this.getTranslation();
    }

    public void transfer(Logic source, Map<Object, Object> refs) {
        this._variables = source._variables == null ? null : Maps.newHashMap(source._variables);
    }

    protected HandlerLogic createHandler(HandlerConfig config, Logic source) {
        if (config == null) {
            String configName = null;
            if (source instanceof ActorLogic) {
                configName = ((ActorLogic)source).getConfigName();
            }
            Log.log.warning((Object)("handler config is null,actor config=" + configName + ", logic=" + source.getClass().getSimpleName()), new Object[0]);
            return null;
        }
        HandlerLogic logic = (HandlerLogic)this._scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            System.out.println(config.getClass());
            return null;
        }
        logic.init(this._scenemgr, config, source);
        return logic;
    }

    protected ActionLogic createAction(ActionConfig config, Logic source) {
        if (config == null) {
            String configName = null;
            if (source instanceof ActorLogic) {
                configName = ((ActorLogic)source).getConfigName();
            }
            Log.log.warning((Object)("Action config is null,actor config=" + configName + ", logic=" + source.getClass().getSimpleName()), new Object[0]);
            return null;
        }
        if (!StringUtil.isBlank((String)config.getLogicClassName())) {
            ActionLogic logic = (ActionLogic)this._scenemgr.createLogic(config.getLogicClassName());
            if (logic == null) {
                return null;
            }
            logic.init(this._scenemgr, config, source);
            return logic;
        }
        Log.log.warning((Object)"Failed to instantiate logic.", new Object[]{"ConfigClass", config.getClass().getName()});
        return null;
    }

    protected TargetLogic createTarget(TargetConfig config, Logic source) {
        if (config == null) {
            String configName = null;
            if (source instanceof ActorLogic) {
                configName = ((ActorLogic)source).getConfigName();
            }
            Log.log.warning((Object)("Target config is null,actor config=" + configName + ", logic=" + source.getClass().getSimpleName()), new Object[0]);
            return null;
        }
        TargetLogic logic = (TargetLogic)this._scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            return null;
        }
        logic.init(this._scenemgr, config, source);
        return logic;
    }

    protected ConditionLogic createCondition(ConditionConfig config, Logic source) {
        if (config == null) {
            Log.log.warning((Object)("config is null, source logic=" + source), new Object[0]);
            return null;
        }
        ConditionLogic logic = (ConditionLogic)this._scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            return null;
        }
        logic.init(this._scenemgr, config, source);
        return logic;
    }

    protected ExpressionLogic createExpression(ExpressionConfig config, Logic source) {
        if (config == null) {
            String configName = null;
            if (source instanceof ActorLogic) {
                configName = ((ActorLogic)source).getConfigName();
            }
            Log.log.warning((Object)("Expression config is null,actor config=" + configName + ", logic=" + source.getClass().getSimpleName()), new Object[0]);
            return null;
        }
        ExpressionLogic logic = (ExpressionLogic)this._scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            return null;
        }
        logic.init(this._scenemgr, config, source);
        return logic;
    }

    protected RegionLogic createRegion(RegionConfig config, Logic source) {
        if (config == null) {
            String configName = null;
            if (source instanceof ActorLogic) {
                configName = ((ActorLogic)source).getConfigName();
            }
            Log.log.warning((Object)("Region config is null,actor config=" + configName + ", logic=" + source.getClass().getSimpleName()), new Object[0]);
            return null;
        }
        RegionLogic logic = (RegionLogic)this._scenemgr.createLogic(config.getLogicClassName());
        if (logic == null) {
            return null;
        }
        logic.init(this._scenemgr, config, source);
        return logic;
    }

    public static interface ShapeObserver {
        public void shapeWillChange(Logic var1);

        public void shapeDidChange(Logic var1);
    }
}

