/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.threerings.config.ConfigReference;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Mobile;
import com.threerings.tudey.util.ActiveAdvancer;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.util.DeepOmit;

public class Active
extends Mobile {
    public static final String SET_ACTIVITY = "set_activity";
    public static final int NONE = 0;
    public static final int LAST_ACTIVITY = 0;
    @DeepOmit
    protected int _activity;
    @DeepOmit
    protected int _activityStarted;

    public Active(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
        super(config, id, created, translation, rotation);
    }

    public Active() {
    }

    public void setActivity(int activity, int started) {
        this.setActivity(activity);
        this.setActivityStarted(started);
    }

    public void setActivity(int activity) {
        this._activity = activity;
        this.setDirty(true);
    }

    public int getActivity() {
        return this._activity;
    }

    public void setActivityStarted(int started) {
        this._activityStarted = started;
        this.setDirty(true);
    }

    public int getActivityStarted() {
        return this._activityStarted;
    }

    @Override
    public Actor interpolate(Actor other, int start, int end, int timestamp, Actor result) {
        Active aresult = (Active)super.interpolate(other, start, end, timestamp, result);
        Active oactive = (Active)other;
        int activityStarted = oactive.getActivityStarted();
        if (timestamp >= activityStarted && activityStarted != 0) {
            aresult.setActivity(oactive.getActivity(), activityStarted);
        }
        return aresult;
    }

    @Override
    public ActorAdvancer createAdvancer(ActorAdvancer.Environment environment, int timestamp) {
        return new ActiveAdvancer(environment, this, timestamp);
    }

    @Override
    public Object copy(Object dest) {
        Active result = (Active)super.copy(dest);
        result._activity = this._activity;
        result._activityStarted = this._activityStarted;
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        Active oactive = (Active)other;
        return this._activity == oactive._activity && this._activityStarted == oactive._activityStarted;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this._activity;
        hash = 31 * hash + this._activityStarted;
        return hash;
    }
}

