/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigManager;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.data.TudeySceneModel;
import java.util.Iterator;
import java.util.List;

public class PreloaderWorker
extends Thread {
    private PreloadableSet preloader;
    private List<TudeySceneModel.Entry> _remaining;
    private int count;
    private ConfigManager _cfmgr;

    public PreloaderWorker(ConfigManager cfmgr, TudeySceneModel model, PreloadableSet preloader) {
        this.preloader = preloader;
        this._remaining = Lists.newArrayList(model.getEntries());
        this.count = this._remaining.size();
        this._cfmgr = cfmgr;
    }

    @Override
    public void run() {
        Iterator<TudeySceneModel.Entry> it = this._remaining.iterator();
        while (it.hasNext()) {
            TudeySceneModel.Entry entry = it.next();
            entry.getPreloads(this._cfmgr, this.preloader);
            it.remove();
        }
    }

    public float getPercent() {
        if (this.count == 0) {
            return 1.0f;
        }
        return (float)(this.count - this._remaining.size()) / (float)this.count;
    }
}

