/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.samskivert.util.StringUtil;
import com.threerings.expr.Bound;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.CompoundConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Compound
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected CompoundConfig _config;
    protected Model[] _models;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform = new Transform3D();
    protected SceneElement.TickPolicy _tickPolicy;
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected boolean _completed;

    public Compound(GlContext ctx, Scope parentScope, CompoundConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, CompoundConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public List<Model> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this._models));
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void setVisible(boolean visible) {
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.setVisible(visible);
            ++n2;
        }
    }

    @Override
    public void reset() {
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.reset();
            ++n2;
        }
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.drawBounds();
            ++n2;
        }
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(String.valueOf(prefix) + "Compound: " + this._worldTransform + " " + this._bounds);
        String pprefix = String.valueOf(prefix) + "  ";
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.dumpInfo(pprefix);
            ++n2;
        }
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.wasAdded(scene);
            ++n2;
        }
    }

    @Override
    public void willBeRemoved() {
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.willBeRemoved();
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            if (model != null) {
                model.dispose();
            }
            ++n2;
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._completed) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._nbounds.setToEmpty();
        this._completed = true;
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.tick(elapsed);
            this._nbounds.addLocal(model.getBounds());
            this._completed &= model.hasCompleted();
            ++n2;
        }
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector3f closest = result;
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            if (model.getIntersection(ray, result)) {
                result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
            }
            ++n2;
        }
        return result != closest;
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        Model[] modelArray = this._models;
        int n = this._models.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.composite();
            ++n2;
        }
    }

    protected void updateFromConfig() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] omodels = this._models;
        this._models = new Model[this._config.models.length];
        Function getNodeFn = ScopeUtil.resolve((Scope)this, "getNode", Function.NULL);
        int ii = 0;
        while (ii < this._models.length) {
            Model model;
            boolean create = omodels == null || omodels.length <= ii;
            this._models[ii] = model = create ? new Model(this._ctx) : omodels[ii];
            CompoundConfig.ComponentModel component = this._config.models[ii];
            Scope node = StringUtil.isBlank((String)component.node) ? null : (Scope)getNodeFn.call(component.node);
            model.setParentScope(node == null ? this : node);
            model.setConfig(component.model);
            model.getLocalTransform().set(component.transform);
            if (create && scene != null) {
                model.wasAdded(scene);
            }
            ++ii;
        }
        if (omodels != null) {
            ii = this._models.length;
            while (ii < omodels.length) {
                Model model = omodels[ii];
                if (scene != null) {
                    model.willBeRemoved();
                }
                model.dispose();
                ++ii;
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            npolicy = SceneElement.TickPolicy.NEVER;
            Model[] modelArray = this._models;
            int n = this._models.length;
            int n2 = 0;
            while (n2 < n) {
                Model model = modelArray[n2];
                SceneElement.TickPolicy mpolicy = model.getTickPolicy();
                if (mpolicy.ordinal() > npolicy.ordinal()) {
                    npolicy = mpolicy;
                }
                ++n2;
            }
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        this.updateBounds();
    }
}

