/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.samskivert.util.IntTuple;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.text.CharacterTextFactory;
import com.threerings.opengl.gui.text.TextFactory;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;

public class FontConfig
extends ManagedConfig {
    public static final FontConfig NULL = new FontConfig();
    @Editable
    public Implementation implementation = new Default();

    public TextFactory getTextFactory(GlContext ctx, Style style, int size) {
        return this.getTextFactory(ctx, style.getFlags(), size);
    }

    public TextFactory getTextFactory(GlContext ctx, int style, int size) {
        return this.implementation.getTextFactory(ctx, style, size);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        this.implementation.getUpdateResources(paths);
    }

    public static class Default
    extends Implementation {
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.font_files_desc", extensions={".ttf", ".ttc"}, directory="font_dir")
        public String file;
        @Editable
        public boolean antialias = true;
        @Editable
        public Style baseStyle = Style.PLAIN;
        @Editable(min=-1.0, step=0.01, hgroup="m")
        public float descentModifier = 0.0f;
        @Editable(hgroup="m")
        public int sizeModifier = 0;
        @DeepOmit
        protected transient HashMap<IntTuple, Font> _fonts = new HashMap();

        @Override
        public TextFactory getTextFactory(GlContext ctx, int style, int size) {
            return CharacterTextFactory.getInstance(this.getFont(ctx, style, size), this.antialias, this.descentModifier);
        }

        @Override
        public void invalidate() {
            this._fonts.clear();
        }

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.file != null) {
                paths.add(this.file);
            }
        }

        protected Font getFont(GlContext ctx, int style, int size) {
            IntTuple key = new IntTuple(style, size);
            Font font = this._fonts.get(key);
            if (font == null) {
                font = this.createFont(ctx, style, size);
                this._fonts.put(key, font);
            }
            return font;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Font createFont(GlContext ctx, int style, int size) {
            if (style != 0 || size != 1) {
                return this.getFont(ctx, 0, 1).deriveFont(style |= this.baseStyle.getFlags(), size + this.sizeModifier);
            }
            if (this.file == null) return new Font("Dialog", 0, 1);
            InputStream is = null;
            is = ctx.getResourceManager().getResource(this.file);
            Font font = Font.createFont(0, is);
            if (is == null) return font;
            try {
                is.close();
                return font;
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to close font file.", new Object[]{"file", this.file, e});
            }
            return font;
            catch (Error | Exception e) {
                try {
                    Log.log.warning((Object)"Failed to load font file.", new Object[]{"file", this.file, e});
                    if (is == null) return new Font("Dialog", 0, 1);
                }
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Log.log.warning((Object)"Failed to close font file.", new Object[]{"file", this.file, e2});
                    }
                    throw throwable;
                }
                try {
                    is.close();
                    return new Font("Dialog", 0, 1);
                }
                catch (IOException e3) {
                    Log.log.warning((Object)"Failed to close font file.", new Object[]{"file", this.file, e3});
                }
                return new Font("Dialog", 0, 1);
            }
        }
    }

    @EditorTypes(value={Default.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public abstract TextFactory getTextFactory(GlContext var1, int var2, int var3);

        public abstract void invalidate();

        public abstract void getUpdateResources(HashSet<String> var1);
    }

    public static enum Style {
        PLAIN(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        protected int _flags;

        public int getFlags() {
            return this._flags;
        }

        private Style(int flags) {
            this._flags = flags;
        }
    }
}

