/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Strings;
import com.samskivert.util.IntTuple;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.config.CursorConfig;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.FocusEvent;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.TextEvent;
import com.threerings.opengl.gui.text.DefaultKeyMap;
import com.threerings.opengl.gui.text.Document;
import com.threerings.opengl.gui.text.EditCommands;
import com.threerings.opengl.gui.text.IMEComponent;
import com.threerings.opengl.gui.text.KeyMap;
import com.threerings.opengl.gui.text.LengthLimitedDocument;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import javax.swing.undo.UndoManager;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public abstract class EditableTextComponent
extends TextComponent
implements EditCommands,
Document.Listener,
IMEComponent {
    protected Document _text;
    protected KeyMap _keymap = new DefaultKeyMap();
    protected String _placeholder = "";
    protected int _prefWidth = -1;
    protected boolean _showCursor;
    protected int _cursp;
    protected int _selp;
    protected int _pendingPos = -1;
    protected int _pendingLength;
    protected Background[] _selectionBackgrounds = new Background[this.getStateCount()];
    protected Rectangle _srect = new Rectangle();
    protected UndoManager _undomgr = new UndoManager();
    protected int _lastUndoId;
    protected CompoundType _lastCompoundType;

    protected EditableTextComponent(GlContext ctx) {
        this(ctx, "", 0);
    }

    protected EditableTextComponent(GlContext ctx, String text, int maxLength) {
        super(ctx);
        this.setMaxLength(maxLength);
        this.setText(text);
    }

    public void setPlaceholder(String placeholder) {
        this._placeholder = Strings.nullToEmpty((String)placeholder);
        if (this.isAdded() && !this.hasFocus() && "".equals(this._text.getText())) {
            this.recreateGlyphs();
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!this._text.getText().equals(text)) {
            this._text.setText(text, -1);
            this._undomgr.discardAllEdits();
        }
    }

    @Override
    public String getText() {
        return this._text.getText();
    }

    @Override
    public Object getValue() {
        return this._text.getValue();
    }

    public void setMaxLength(int maxLength) {
        this.setDocument(maxLength > 0 ? new LengthLimitedDocument(maxLength) : new Document());
    }

    public void setDocument(Document document) {
        if (this._text != null) {
            this._text.removeListener(this);
            this._text.removeUndoableEditListener(this._undomgr);
        }
        this._text = document;
        this._text.addListener(this);
        this._text.addUndoableEditListener(this._undomgr);
    }

    public Document getDocument() {
        return this._text;
    }

    public void setPreferredWidth(int width) {
        this._prefWidth = width;
    }

    public Background getSelectionBackground() {
        Background background = this._selectionBackgrounds[this.getState()];
        return background != null ? background : this._selectionBackgrounds[0];
    }

    @Override
    public void textInserted(Document document, int offset, int length) {
        this.setCursorPos(offset + length);
        if (this.isAdded()) {
            this.recreateGlyphs();
        }
        this.emitEvent(new TextEvent(this, -1L));
    }

    @Override
    public void textRemoved(Document document, int offset, int length) {
        this.setCursorPos(offset);
        if (this.isAdded()) {
            this.recreateGlyphs();
        }
        this.emitEvent(new TextEvent(this, -1L));
    }

    @Override
    public boolean acceptsFocus() {
        return this.isVisible() && this.isEnabled();
    }

    @Override
    public boolean dispatchEvent(Event event) {
        block25: {
            block23: {
                KeyEvent kev;
                block24: {
                    if (!(event instanceof KeyEvent)) break block23;
                    kev = (KeyEvent)event;
                    if (kev.getType() != 0) break block24;
                    int modifiers = kev.getModifiers();
                    int cmd = this._keymap.lookupMapping(modifiers, kev.getKeyCode());
                    switch (cmd) {
                        case -1: {
                            if (((modifiers & 0xFFFFFFD7) == 0 || modifiers == 48) && this.insertChar(kev.getKeyChar())) {
                                return true;
                            }
                            break block25;
                        }
                        case 0: {
                            this.emitEvent(new ActionEvent(this, event.getWhen(), modifiers, "", this.getText()));
                            return true;
                        }
                        default: {
                            if (this.processCommand(cmd)) {
                                return true;
                            }
                            break block25;
                        }
                    }
                }
                if (kev.getKeyCode() == 0 && kev.getKeyChar() != '\u0000' && this.insertChar(kev.getKeyChar())) {
                    return true;
                }
                break block25;
            }
            if (event instanceof MouseEvent && this._text.getLength() > 0 && this.hasGlyphs()) {
                MouseEvent mev = (MouseEvent)event;
                int type = mev.getType();
                if (type != 0 && type != 6 && type != 2) {
                    return super.dispatchEvent(event);
                }
                Insets insets = this.getInsets();
                int mx = mev.getX() - this.getAbsoluteX() - insets.left;
                int my = mev.getY() - this.getAbsoluteY() - insets.bottom;
                int pos = this.getPosition(mx, my);
                if (type == 0) {
                    if (!this.selectionContains(pos)) {
                        this.setCursorPos(pos);
                    }
                    return true;
                }
                if (type == 6) {
                    this.setSelection(pos, this._selp);
                    return true;
                }
                if (type == 2) {
                    int count = (mev.getClickCount() - 1) % 3;
                    if (count == 0) {
                        this.setCursorPos(pos);
                    } else if (count == 1) {
                        IntTuple extents = this._text.getWordExtents(pos);
                        this.setSelection(extents.left, extents.right);
                    } else {
                        this.setSelection(this._text.getLength(), 0);
                    }
                    return true;
                }
            } else if (event instanceof FocusEvent) {
                FocusEvent fev = (FocusEvent)event;
                switch (fev.getType()) {
                    case 0: {
                        this.gainedFocus();
                        break;
                    }
                    case 1: {
                        this.lostFocus();
                    }
                }
            }
        }
        return super.dispatchEvent(event);
    }

    protected void clearPending() {
        if (this._pendingPos != -1) {
            int newpos;
            if (this._pendingLength > 0 && (newpos = this._text.remove(this._pendingPos, this._pendingLength, this.nextUndoId(null))) != -1) {
                this.setCursorPos(this._pendingPos);
            }
            this._pendingPos = -1;
        }
    }

    protected void replaceSelectedText(String text, CompoundType compoundType, boolean pending) {
        int newpos;
        int start = Math.min(this._cursp, this._selp);
        int end = Math.max(this._cursp, this._selp);
        int length = end - start;
        if (pending && this._pendingPos != -1) {
            start = this._pendingPos;
            length = this._pendingLength;
        }
        if ((newpos = this._text.replace(start, length, text, this.nextUndoId(compoundType))) != -1) {
            this.setSelection(newpos, newpos);
            if (pending) {
                this._pendingPos = start;
                this._pendingLength = text.length();
            } else {
                this._pendingPos = -1;
            }
            this._lastCompoundType = compoundType;
        }
    }

    protected boolean insertChar(char c) {
        if (!Character.isDefined(c) || Character.isISOControl(c) || c == '\u0000') {
            return false;
        }
        switch (c) {
            case '\n': 
            case '\r': {
                c = (char)10;
            }
        }
        this.replaceSelectedText(String.valueOf(c), Character.isLetterOrDigit(c) ? CompoundType.WORD_CHAR : CompoundType.NONWORD_CHAR);
        return true;
    }

    protected boolean processCommand(int cmd) {
        switch (cmd) {
            default: {
                return false;
            }
            case 1: {
                int newpos;
                if (!this.selectionIsEmpty()) {
                    this.deleteSelectedText();
                    break;
                }
                if (this._cursp <= 0 || this._text.getLength() <= 0 || (newpos = this._text.remove(this._cursp, -1, this.nextUndoId(CompoundType.BACKSPACE))) == -1) break;
                this.setCursorPos(newpos);
                this._lastCompoundType = CompoundType.BACKSPACE;
                break;
            }
            case 2: {
                int newpos;
                if (!this.selectionIsEmpty()) {
                    this.deleteSelectedText();
                    break;
                }
                if (this._cursp >= this._text.getLength() || (newpos = this._text.remove(this._cursp, 1, this.nextUndoId(CompoundType.DELETE))) == -1) break;
                this.setCursorPos(newpos);
                this._lastCompoundType = CompoundType.DELETE;
                break;
            }
            case 3: {
                this.setCursorPos(this._text.moveCursor(this._cursp, -1));
                break;
            }
            case 4: {
                this.setCursorPos(this._text.moveCursor(this._cursp, 1));
                break;
            }
            case 7: {
                this.setCursorPos(this._text.lastIndexOfWordStart(this._cursp));
                break;
            }
            case 8: {
                this.setCursorPos(this._text.indexOfWordEnd(this._cursp));
                break;
            }
            case 11: {
                this.getWindow().requestFocus(null);
                break;
            }
            case 12: {
                this._text.setText("", this.nextUndoId(null));
                break;
            }
            case 13: {
                if (this.selectionIsEmpty()) break;
                this.getWindow().getRoot().setClipboardText(this.deleteSelectedText());
                break;
            }
            case 14: {
                if (this.selectionIsEmpty()) break;
                this.getWindow().getRoot().setClipboardText(this.getSelectedText());
                break;
            }
            case 15: {
                String clip = this.getWindow().getRoot().getClipboardText();
                if (clip == null || (clip = this.validatePaste(clip)) == null) break;
                this.replaceSelectedText(clip, null);
                break;
            }
            case 16: {
                if (!this._undomgr.canUndo()) break;
                this._undomgr.undo();
                break;
            }
            case 17: {
                if (!this._undomgr.canRedo()) break;
                this._undomgr.redo();
            }
        }
        return true;
    }

    protected String validatePaste(String pasted) {
        return pasted;
    }

    @Override
    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        CursorConfig textCursor;
        super.updateFromStyleConfig(state, config);
        if (state == 0 && this._cursor == null && (textCursor = this._ctx.getConfigManager().getConfig(CursorConfig.class, "Text")) != null) {
            this._cursor = textCursor.getCursor(this._ctx);
        }
        this._selectionBackgrounds[state] = config.selectionBackground == null ? null : config.selectionBackground.getBackground(this._ctx);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        this.recreateGlyphs();
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        this.clearGlyphs();
    }

    @Override
    protected void layout() {
        super.layout();
        this.recreateGlyphs();
    }

    @Override
    protected void stateDidChange() {
        super.stateDidChange();
        this.recreateGlyphs();
    }

    protected void gainedFocus() {
        this._showCursor = true;
        Display.setIMEStatus((boolean)true);
        if (this.usePlaceholder()) {
            this.recreateGlyphs();
        }
    }

    protected void lostFocus() {
        this._showCursor = false;
        this._undomgr.discardAllEdits();
        Display.setIMEStatus((boolean)false);
        if (this.usePlaceholder()) {
            this.recreateGlyphs();
        }
    }

    protected boolean showCursor() {
        return this._showCursor && this._enabled;
    }

    protected boolean usePlaceholder() {
        return !"".equals(this._placeholder) && "".equals(this._text.getText());
    }

    protected String getDisplayText() {
        if (!this.hasFocus() && this.usePlaceholder()) {
            return this._placeholder;
        }
        return this._text.getText();
    }

    protected void renderCursor(Renderer renderer, int x, int y, int height) {
        renderer.setColorState(this.getColor());
        renderer.setTextureState(null);
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glEnd();
    }

    protected boolean selectionIsEmpty() {
        return this._cursp == this._selp;
    }

    protected boolean selectionContains(int pos) {
        int start = Math.min(this._cursp, this._selp);
        int end = Math.max(this._cursp, this._selp);
        return pos >= start && pos < end;
    }

    protected String getSelectedText() {
        int start = Math.min(this._cursp, this._selp);
        int end = Math.max(this._cursp, this._selp);
        return this._text.getText(start, end - start);
    }

    protected String deleteSelectedText() {
        int start = Math.min(this._cursp, this._selp);
        int end = Math.max(this._cursp, this._selp);
        int length = end - start;
        String text = this._text.getText(start, length);
        int newpos = this._text.remove(start, length, this.nextUndoId(null));
        if (newpos != -1) {
            this.setCursorPos(0);
        }
        return text;
    }

    protected void replaceSelectedText(String text, CompoundType compoundType) {
        int end;
        int length;
        int start = Math.min(this._cursp, this._selp);
        int newpos = this._text.replace(start, length = (end = Math.max(this._cursp, this._selp)) - start, text, this.nextUndoId(compoundType));
        if (newpos != -1) {
            this.setCursorPos(newpos);
            this._lastCompoundType = compoundType;
        }
    }

    protected void setCursorPos(int cursorPos) {
        this.setSelection(cursorPos, cursorPos);
    }

    protected void setSelection(int cursorPos, int selectPos) {
        this._lastCompoundType = null;
        this._cursp = cursorPos;
        this._selp = selectPos;
        this.selectionWasSet();
    }

    protected void recreateGlyphs() {
        this.clearGlyphs();
        if ("".equals(this.getDisplayText())) {
            this.setSelection(0, 0);
        } else {
            this.createGlyphs();
            this.setSelection(this._cursp, this._selp);
        }
    }

    protected abstract boolean hasGlyphs();

    protected abstract void clearGlyphs();

    protected abstract void createGlyphs();

    protected abstract int getPosition(int var1, int var2);

    protected abstract void selectionWasSet();

    protected int nextUndoId(CompoundType compoundType) {
        if (compoundType != null && compoundType == this._lastCompoundType || compoundType == CompoundType.NONWORD_CHAR && this._lastCompoundType == CompoundType.WORD_CHAR) {
            return this._lastUndoId;
        }
        return ++this._lastUndoId;
    }

    protected static enum CompoundType {
        WORD_CHAR,
        NONWORD_CHAR,
        BACKSPACE,
        DELETE;

    }
}

