/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.google.common.collect.Maps;
import com.threerings.expr.Bound;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.math.Box;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.effect.Counter;
import com.threerings.opengl.effect.Influence;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.Placer;
import com.threerings.opengl.effect.Shooter;
import com.threerings.opengl.effect.config.BaseParticleSystemConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.IdentityHashMap;

public abstract class BaseParticleSystem
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected BaseParticleSystemConfig _config;
    protected Layer[] _layers;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform = new Transform3D();
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    @Scoped
    protected Box _nbounds = new Box();
    protected Box[] _groupBounds = new Box[0];
    protected SceneElement.TickPolicy _tickPolicy;
    protected ModelConfig.TransientPolicy _transientPolicy;
    protected boolean _warmed;
    protected boolean _completed;
    protected static Vector3f _vector = new Vector3f();

    public BaseParticleSystem(GlContext ctx, Scope parentScope) {
        super(parentScope);
        this._ctx = ctx;
    }

    public void setConfig(GlContext ctx, BaseParticleSystemConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void reset() {
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.reset();
            ++n2;
        }
        this._completed = false;
        this._warmed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.drawBounds();
            ++n2;
        }
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(String.valueOf(prefix) + "ParticleSystem: " + this._worldTransform + " " + this._bounds);
    }

    @Override
    public ModelConfig.TransientPolicy getTransientPolicy() {
        return this._transientPolicy;
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        super.wasAdded();
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.wasAdded();
            ++n2;
        }
    }

    @Override
    public void willBeRemoved() {
        super.willBeRemoved();
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            layer.willBeRemoved();
            ++n2;
        }
    }

    @Override
    protected void setHalted() {
        super.setHalted();
        if (!this._warmed) {
            this.warmUp();
        }
        this._completed = true;
    }

    @Override
    public void tick(float elapsed) {
        if (this._completed || this._layers == null || this._layers.length == 0) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        if (!this._warmed && elapsed > 0.0f) {
            this.warmUp();
        }
        this.resetBounds();
        this._completed = true;
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            this._completed &= layer.tick(elapsed);
            ++n2;
        }
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._layers != null) {
            Scene scene = this.getScene();
            Layer[] layerArray = this._layers;
            int n = this._layers.length;
            int n2 = 0;
            while (n2 < n) {
                Layer layer = layerArray[n2];
                if (scene != null) {
                    layer.willBeRemoved();
                }
                layer.dispose();
                ++n2;
            }
        }
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        Layer[] layerArray = this._layers;
        int n = this._layers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            if (layer != null) {
                layer.composite();
            }
            ++n2;
        }
    }

    protected void updateFromConfig() {
        ModelConfig.TransientPolicy tpolicy;
        IdentityHashMap olayers = Maps.newIdentityHashMap();
        if (this._layers != null) {
            Layer[] layerArray = this._layers;
            int n = this._layers.length;
            int n2 = 0;
            while (n2 < n) {
                Layer layer = layerArray[n2];
                olayers.put(layer.getConfig().identity, layer);
                ++n2;
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            SceneElement.TickPolicy tickPolicy = npolicy = this._config.anyLayersRespawn() ? SceneElement.TickPolicy.WHEN_VISIBLE : SceneElement.TickPolicy.ALWAYS;
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        if ((tpolicy = this._config.transientPolicy) == ModelConfig.TransientPolicy.DEFAULT) {
            tpolicy = ModelConfig.TransientPolicy.FRUSTUM;
        }
        this._transientPolicy = tpolicy;
        BaseParticleSystemConfig.Layer[] configs = this._config.getLayers();
        this._layers = new Layer[configs.length];
        Scene scene = this.getScene();
        int ii = 0;
        while (ii < this._layers.length) {
            BaseParticleSystemConfig.Layer config = configs[ii];
            Layer layer = (Layer)olayers.remove(config.identity);
            if (layer != null) {
                layer.setConfig(config);
            } else {
                layer = this.createLayer(config);
            }
            this._layers[ii] = layer;
            if (scene != null) {
                layer.wasAdded();
            }
            ++ii;
        }
        for (Layer layer : olayers.values()) {
            if (scene != null) {
                layer.willBeRemoved();
            }
            layer.dispose();
        }
        this.updateBounds();
    }

    protected Scene getScene() {
        return ((Model)this._parentScope).getScene(this);
    }

    protected abstract Layer createLayer(BaseParticleSystemConfig.Layer var1);

    protected void warmUp() {
        float remaining = this._config.warmupTime;
        while (remaining > 0.0f) {
            float welapsed = Math.min(remaining, this._config.warmupGranularity);
            Layer[] layerArray = this._layers;
            int n = this._layers.length;
            int n2 = 0;
            while (n2 < n) {
                Layer layer = layerArray[n2];
                layer.tick(welapsed);
                ++n2;
            }
            remaining -= welapsed;
        }
        this._warmed = true;
    }

    protected void resetBounds() {
        float expand = this._config.boundsExpansion;
        Box.ZERO.expand(expand, expand, expand, this._nbounds).transformLocal(this._worldTransform);
    }

    public static abstract class Layer
    extends SimpleScope {
        protected GlContext _ctx;
        @Scoped
        protected BaseParticleSystemConfig.Layer _config;
        @Bound(value="viewTransform")
        protected Transform3D _parentViewTransform;
        @Bound(value="worldTransform")
        protected Transform3D _parentWorldTransform;
        @Bound(value="nbounds")
        protected Box _parentBounds;
        @Bound
        protected ColorState _colorState;
        @Scoped
        protected Transform3D _worldTransform = new Transform3D();
        protected Transform3D _worldTransformInv = new Transform3D();
        @Scoped
        protected Box _bounds = new Box();
        protected float _geometryRadius;
        @Scoped
        protected Particle[] _particles;
        protected Counter _counter;
        protected Placer _placer;
        protected Shooter _shooter;
        protected Influence[] _influences;
        @Scoped
        protected MutableInteger _living = new MutableInteger();
        protected int _preliving;
        protected float _total;
        protected boolean _completed;
        protected Quaternion _wrot = new Quaternion();

        public Layer(GlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }

        public void setConfig(BaseParticleSystemConfig.Layer config) {
            this._config = config;
            Particle[] oparts = this._particles;
            this._particles = new Particle[config.particleCount];
            int ii = 0;
            while (ii < this._particles.length) {
                this._particles[ii] = oparts == null || oparts.length <= ii ? new Particle() : oparts[ii];
                ++ii;
            }
            if (oparts == null) {
                this._living.value = 0;
                this._preliving = this._particles.length;
            } else {
                this._living.value = Math.min(this._living.value, this._particles.length);
                this._preliving = Math.min(this._living.value + this._preliving, this._particles.length) - this._living.value;
            }
            this._counter = config.counter.createCounter();
            this._placer = config.placer.createPlacer(this);
            this._shooter = config.shooter.createShooter(this);
            this._influences = new Influence[config.influences.length];
            ii = 0;
            while (ii < this._influences.length) {
                this._influences[ii] = config.influences[ii].createInfluence(this);
                ++ii;
            }
        }

        public BaseParticleSystemConfig.Layer getConfig() {
            return this._config;
        }

        public Camera getCamera() {
            return this._ctx.getCompositor().getCamera();
        }

        public void wasAdded() {
        }

        public void willBeRemoved() {
        }

        @Override
        public void dispose() {
            super.dispose();
        }

        public void reset() {
            this._total = 0.0f;
            this._completed = false;
            this._counter.reset();
            this._living.value = 0;
            this._preliving = this._particles.length;
        }

        public boolean tick(float elapsed) {
            float f;
            if (!this._config.visible || this._completed) {
                return true;
            }
            this._total += elapsed;
            if (f <= this._config.startTime) {
                return false;
            }
            elapsed *= this._config.timeScale;
            this._parentWorldTransform.compose(this._config.transform, this._worldTransform).invert(this._worldTransformInv);
            Influence[] influenceArray = this._influences;
            int n = this._influences.length;
            int n2 = 0;
            while (n2 < n) {
                Influence influence = influenceArray[n2];
                influence.tick(elapsed);
                ++n2;
            }
            this._bounds.setToEmpty();
            float msize = 0.0f;
            float scale = 1.0f;
            if (!this._config.moveParticlesWithEmitter) {
                scale = this._worldTransform.approximateUniformScale();
            }
            int ii = 0;
            while (ii < this._living.value) {
                Particle particle = this._particles[ii];
                if (particle.tick(elapsed)) {
                    Influence[] influenceArray2 = this._influences;
                    int n3 = this._influences.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Influence influence = influenceArray2[n4];
                        influence.apply(particle);
                        ++n4;
                    }
                    if (this._colorState != null) {
                        particle.getColor().multLocal(this._colorState.getColor());
                    }
                    if (!this._config.moveParticlesWithEmitter) {
                        particle.setSize(particle.getSize() * scale);
                    }
                    this._bounds.addLocal(particle.getPosition());
                    msize = Math.max(msize, particle.getSize());
                } else {
                    this.killParticle(ii);
                    if (ii != --this._living.value) {
                        this.swapParticles(ii, this._living.value);
                        --ii;
                    }
                    if (this._preliving != 0) {
                        this.swapParticles(this._living.value, this._living.value + this._preliving);
                    }
                }
                ++ii;
            }
            if (this._living.value == 0 && this._preliving == 0 && !this._config.respawnDeadParticles) {
                this._completed = true;
                return true;
            }
            int count = this._counter.count(elapsed, this._config.respawnDeadParticles ? this._particles.length - this._living.value : this._preliving);
            int ii2 = this._living.value;
            int nn = this._living.value + count;
            while (ii2 < nn) {
                Particle particle = this._particles[ii2];
                this._placer.place(particle);
                this._config.orientation.getValue(particle.getOrientation());
                this.vectorToLayer(this._shooter.shoot(particle).multLocal(this._config.speed.getValue()), this._config.rotateVelocitiesWithEmitter);
                this._config.angularVelocity.getValue(particle.getAngularVelocity());
                if (this._config.shouldRotateOrientations()) {
                    boolean emitter = this._config.rotateOrientationsWithEmitter;
                    this.rotationToLayer(particle.getOrientation(), emitter);
                    this.vectorToLayer(particle.getAngularVelocity(), emitter);
                }
                this.initParticle(ii2);
                ++this._living.value;
                this._preliving = Math.max(this._preliving - 1, 0);
                this._bounds.addLocal(particle.getPosition());
                msize = Math.max(msize, particle.getSize());
                ++ii2;
            }
            if (this._bounds.isEmpty()) {
                return false;
            }
            float amount = this._geometryRadius * msize;
            this._bounds.expandLocal(amount, amount, amount);
            this.addBounds();
            return false;
        }

        public Vector3f pointToLayer(Vector3f point, boolean emitter) {
            return this._config.moveParticlesWithEmitter ? (emitter ? point : this._worldTransformInv.transformPointLocal(point)) : (emitter ? this._worldTransform.transformPointLocal(point) : point);
        }

        public Vector3f vectorToLayer(Vector3f vector, boolean emitter) {
            return this._config.moveParticlesWithEmitter ? (emitter ? vector : this._worldTransformInv.transformVectorLocal(vector)) : (emitter ? this._worldTransform.transformVectorLocal(vector) : vector);
        }

        public Quaternion rotationToLayer(Quaternion rot, boolean emitter) {
            return this._config.moveParticlesWithEmitter ? (emitter ? rot : this._worldTransformInv.extractRotation(this._wrot).mult(rot, rot)) : (emitter ? this._worldTransform.extractRotation(this._wrot).mult(rot, rot) : rot);
        }

        public void drawBounds() {
            DebugBounds.draw(this._bounds, Color4f.GRAY);
        }

        public abstract void composite();

        @Override
        public String getScopeName() {
            return "layer";
        }

        protected void swapParticles(int idx0, int idx1) {
            Particle tmp = this._particles[idx0];
            this._particles[idx0] = this._particles[idx1];
            this._particles[idx1] = tmp;
        }

        protected void initParticle(int idx) {
            this._particles[idx].init(this._config.lifespan.getValue(), this._config.alphaMode, this._config.color, this._config.size, null, null, null);
        }

        protected void killParticle(int idx) {
        }

        protected void addBounds() {
            if (this._config.moveParticlesWithEmitter) {
                this._bounds.transformLocal(this._worldTransform);
            }
            this._parentBounds.addLocal(this._bounds);
        }
    }
}

