/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.Log;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.PatternSet;

public class ConfigResourcesTask
extends Task {
    protected String _id;
    protected File _configfile;
    protected File _resourcefile;

    public void setId(String id) {
        this._id = id;
    }

    public void setConfigfile(File file) {
        this._configfile = file;
    }

    public void setResourcefile(File file) {
        this._resourcefile = file;
    }

    public void execute() throws BuildException {
        FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
        rsrcmgr.init("rsrc/");
        MessageManager msgmgr = new MessageManager("rsrc.i18n");
        ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
        cfgmgr.init();
        HashSet resources = Sets.newHashSet();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this._configfile));
            ConfigGroup<?> group = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    String name = line.substring(1, line.length() - 1);
                    group = cfgmgr.getGroup(name);
                    if (group != null) continue;
                    Log.log.warning((Object)"Invalid config group name.", new Object[]{"name", name});
                    continue;
                }
                if (group == null) continue;
                this.getResources(cfgmgr, group, line, resources);
            }
        }
        catch (IOException e) {
            Log.log.warning((Object)"Error reading config list.", new Object[]{"file", this._configfile, e});
        }
        ArrayList includes = Lists.newArrayList();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this._resourcefile));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                includes.add(line);
            }
        }
        catch (IOException e) {
            Log.log.warning((Object)"Failed to read resource list.", new Object[]{"file", this._resourcefile, e});
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir("rsrc");
        scanner.setIncludes(includes.toArray(new String[includes.size()]));
        scanner.scan();
        String[] stringArray = scanner.getIncludedFiles();
        int n = stringArray.length;
        int name = 0;
        while (name < n) {
            String file = stringArray[name];
            if (file.endsWith(".dat")) {
                ManagedConfig config = cfgmgr.getResourceConfig(file);
                PropertyUtil.getResources(config.getConfigManager(), config, resources);
            }
            ++name;
        }
        PatternSet set = (PatternSet)this.getProject().createDataType("patternset");
        for (String resource : resources) {
            set.createInclude().setName(resource);
        }
        this.getProject().addReference(this._id, (Object)set);
    }

    protected void getResources(ConfigManager cfgmgr, ConfigGroup<?> group, String line, Set<String> paths) {
        PropertyUtil.getResources(cfgmgr, group.getConfig(line), paths);
    }
}

