/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.tools;

import com.threerings.config.ConfigManager;
import com.threerings.editor.util.Validator;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.tools.FileSetTask;
import com.threerings.util.MessageManager;
import com.threerings.util.ResourceContext;
import java.io.File;
import org.apache.tools.ant.BuildException;

public abstract class AbstractValidatorTask
extends FileSetTask {
    public void execute() throws BuildException {
        ValidatorContext context = this.createContext();
        Validator validator = this.createValidator();
        Iterable<File> files = this.getFiles();
        if (!this.validate(context.getConfigManager(), files, validator)) {
            throw new BuildException();
        }
    }

    protected abstract boolean validate(ConfigManager var1, Iterable<File> var2, Validator var3);

    protected Validator createValidator() {
        return new Validator(System.err);
    }

    protected ValidatorContext createContext() {
        return new ValidatorContext();
    }

    protected static class ValidatorContext
    implements ResourceContext {
        protected ResourceManager _rsrcmgr = this.createResourceManager();
        protected MessageManager _msgmgr;
        protected ConfigManager _cfgmgr;

        public ValidatorContext() {
            this._rsrcmgr.init("rsrc/");
            this._msgmgr = this.createMessageManager();
            this._cfgmgr = this.createConfigManager(this._rsrcmgr, this._msgmgr);
            this._cfgmgr.init();
        }

        @Override
        public ResourceManager getResourceManager() {
            return this._rsrcmgr;
        }

        @Override
        public MessageManager getMessageManager() {
            return this._msgmgr;
        }

        @Override
        public ConfigManager getConfigManager() {
            return this._cfgmgr;
        }

        protected ResourceManager createResourceManager() {
            return new FileResourceManager("rsrc/");
        }

        public MessageManager createMessageManager() {
            return new MessageManager("rsrc.i18n");
        }

        public ConfigManager createConfigManager(ResourceManager rsrcmgr, MessageManager msgmgr) {
            return new ConfigManager(rsrcmgr, msgmgr, "config/");
        }
    }
}

