/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors.util;

import com.google.common.base.Splitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.prefs.Preferences;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractRecentList
extends JPanel {
    protected JList _list;
    protected DefaultListModel _listModel = new DefaultListModel();
    protected String _prefKey;
    protected Preferences _prefs;
    protected boolean _block;
    protected static final int MAX_SIZE = 50;

    public AbstractRecentList(String prefKey, Preferences prefs) {
        super(new BorderLayout());
        this._prefKey = prefKey;
        this._prefs = prefs;
        this.readPrefs();
        this._list = new JList(this._listModel);
        this._list.setVisibleRowCount(4);
        JScrollPane pane = new JScrollPane(this._list, 21, 31);
        this.add((Component)pane, "Center");
        this._list.setSelectionMode(0);
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (AbstractRecentList.this._block) {
                    return;
                }
                Object selected = AbstractRecentList.this._list.getSelectedValue();
                if (selected != null) {
                    AbstractRecentList.this.valueSelected((String)selected);
                }
            }
        });
        this._list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String fullString = String.valueOf(value);
                super.getListCellRendererComponent((JList<?>)list, fullString, index, isSelected, cellHasFocus);
                int maxWidth = list.getSize().width;
                int chop = 1;
                int maxChop = AbstractRecentList.this.getMaximumChop(fullString);
                while (chop <= maxChop && this.getPreferredSize().width > maxWidth) {
                    this.setText("..." + fullString.substring(chop));
                    ++chop;
                }
                return this;
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        d.height = Math.max(d.height, this._list.getPreferredScrollableViewportSize().height);
        return d;
    }

    protected abstract void valueSelected(String var1);

    protected int getMaximumChop(String value) {
        return Math.max(0, value.length() - 10);
    }

    protected void addRecent(String value) {
        int size = this._listModel.getSize();
        int curIdx = -1;
        int ii = 0;
        while (ii < size) {
            if (value.equals(this._listModel.getElementAt(ii))) {
                curIdx = ii;
                break;
            }
            ++ii;
        }
        if (curIdx == 0) {
            return;
        }
        this._block = true;
        try {
            if (curIdx > 0) {
                this._listModel.removeElementAt(curIdx);
            } else if (size == 50) {
                this._listModel.removeElementAt(size - 1);
            }
            this._listModel.insertElementAt(value, 0);
            this._list.setSelectedIndex(0);
        }
        finally {
            this._block = false;
        }
        this.writePrefs();
    }

    protected void readPrefs() {
        if (this._prefKey == null) {
            return;
        }
        this._block = true;
        try {
            String encoded = this._prefs.get(this._prefKey, "");
            this._listModel.removeAllElements();
            for (String piece : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)encoded)) {
                this._listModel.addElement(piece.replace("%BAR%", "|"));
            }
        }
        finally {
            this._block = false;
        }
    }

    protected void writePrefs() {
        if (this._prefKey == null) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        int ii = 0;
        int nn = this._listModel.getSize();
        while (ii < nn) {
            String value = (String)this._listModel.getElementAt(ii);
            value = value.replace("|", "%BAR%");
            if (builder.length() + value.length() + 1 > 8192) break;
            builder.append(value).append('|');
            ++ii;
        }
        this._prefs.put(this._prefKey, builder.toString());
    }
}

