/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.util.QuickSort;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.media.image.ColorPository;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorizationEditor
extends PropertyEditor
implements ActionListener {
    protected JComboBox _class;
    protected JComboBox _color;

    @Override
    public void actionPerformed(ActionEvent event) {
        Integer value;
        if (this._color == null) {
            value = ((ClassItem)this._class.getSelectedItem()).record.classId;
        } else {
            if (event.getSource() == this._class) {
                this.populateColor(((ClassItem)this._class.getSelectedItem()).record);
            }
            value = ((ColorItem)this._color.getSelectedItem()).record.getColorPrint();
        }
        if (!this._property.get(this._object).equals(value)) {
            this._property.set(this._object, value);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        int value = (Integer)this._property.get(this._object);
        if (this._color == null) {
            ColorPository.ClassRecord clazz = this._ctx.getColorPository().getClassRecord(value);
            if (clazz == null) {
                this._class.setSelectedIndex(0);
            } else {
                this._class.setSelectedItem(new ClassItem(clazz));
            }
            return;
        }
        ColorPository.ColorRecord color = this._ctx.getColorPository().getColorRecord(value >> 8, value & 0xFF);
        if (color == null) {
            if (this._class != null) {
                this._class.removeActionListener(this);
                try {
                    this._class.setSelectedIndex(0);
                }
                finally {
                    this._class.addActionListener(this);
                }
                this.populateColor(((ClassItem)this._class.getSelectedItem()).record);
            }
            this._color.setSelectedIndex(0);
        } else {
            if (this._class != null) {
                this._class.removeActionListener(this);
                try {
                    this._class.setSelectedItem(new ClassItem(color.cclass));
                }
                finally {
                    this._class.addActionListener(this);
                }
                this.populateColor(color.cclass);
            }
            this._color.setSelectedItem(new ColorItem(color));
        }
    }

    @Override
    protected void didInit() {
        String mode = this.getMode();
        if (mode.equals("class")) {
            this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
            this._class = this.createClassBox();
            this.add(this._class);
        } else if (mode.length() > 0) {
            this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
            this._color = new JComboBox();
            this.add(this._color);
            this.populateColor(this._ctx.getColorPository().getClassRecord(mode));
            this._color.addActionListener(this);
        } else {
            this.setTitle(this.getPropertyLabel());
            this.setLayout((LayoutManager)new HGroupLayout(GroupLayout.STRETCH, GroupLayout.NONE, 5, GroupLayout.CENTER));
            JPanel p1 = new JPanel();
            p1.setBackground(null);
            this.add(p1);
            p1.add(new JLabel(String.valueOf(this._msgs.get("m.class")) + ":"));
            this._class = this.createClassBox();
            p1.add(this._class);
            JPanel p2 = new JPanel();
            p2.setBackground(null);
            this.add(p2);
            p2.add(new JLabel(String.valueOf(this._msgs.get("m.color")) + ":"));
            this._color = new JComboBox();
            p2.add(this._color);
            this._color.addActionListener(this);
        }
    }

    protected JComboBox createClassBox() {
        ArrayList<ClassItem> classes = new ArrayList<ClassItem>();
        for (ColorPository.ClassRecord rec : this._ctx.getColorPository().getClasses()) {
            classes.add(new ClassItem(rec));
        }
        QuickSort.sort(classes);
        JComboBox<ClassItem> box = new JComboBox<ClassItem>(classes.toArray(new ClassItem[classes.size()]));
        box.addActionListener(this);
        return box;
    }

    protected void populateColor(ColorPository.ClassRecord crec) {
        ArrayList<ColorItem> colors = new ArrayList<ColorItem>();
        for (Object color : crec.colors.values()) {
            colors.add(new ColorItem((ColorPository.ColorRecord)color));
        }
        QuickSort.sort(colors);
        this._color.setModel(new DefaultComboBoxModel<ColorItem>(colors.toArray(new ColorItem[colors.size()])));
    }

    protected static class ClassItem
    implements Comparable<ClassItem> {
        public ColorPository.ClassRecord record;

        public ClassItem(ColorPository.ClassRecord record) {
            this.record = record;
        }

        @Override
        public int compareTo(ClassItem other) {
            return this.record.classId - other.record.classId;
        }

        public String toString() {
            return this.record.name;
        }

        public boolean equals(Object other) {
            return this.record == ((ClassItem)other).record;
        }

        public int hashCode() {
            return this.record != null ? this.record.hashCode() : 0;
        }
    }

    protected static class ColorItem
    implements Comparable<ColorItem> {
        public ColorPository.ColorRecord record;

        public ColorItem(ColorPository.ColorRecord record) {
            this.record = record;
        }

        @Override
        public int compareTo(ColorItem other) {
            return this.record.colorId - other.record.colorId;
        }

        public String toString() {
            return this.record.name;
        }

        public boolean equals(Object other) {
            return this.record == ((ColorItem)other).record;
        }

        public int hashCode() {
            return this.record != null ? this.record.hashCode() : 0;
        }
    }
}

